/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.streams.parameters;

import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.impala.dsi.exceptions.InputOutputException;
import com.cloudera.impala.exceptions.JDBCMessageKey;
import com.cloudera.impala.streams.parameters.AbstractParameterStream;
import java.io.IOException;
import java.io.InputStream;

public class UnicodeParameterStream
extends AbstractParameterStream {
    public UnicodeParameterStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }

    @Deprecated
    public UnicodeParameterStream(InputStream inputStream, int n, ParameterMetadata parameterMetadata, int n2) {
        super(inputStream, n, parameterMetadata, n2);
    }

    @Override
    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        if (null == this.m_parameterMetadata) {
            throw new InputOutputException(1, JDBCMessageKey.NULL_PARAM_METADATA.name());
        }
        if (!this.m_valuesPushed) {
            this.m_valuesPushed = true;
        }
        int n = this.getNumToFetch();
        byte[] byArray = new byte[n];
        int n2 = this.m_stream.read(byArray);
        this.m_numRead += (long)n2;
        DataWrapper dataWrapper = new DataWrapper();
        if (-1L != this.m_streamLength) {
            if (-1 == n2) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = n2;
            if (n2 < byArray.length && -1 != n2) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == n2) {
                byArray = new byte[]{};
            }
        }
        try {
            if (12 == this.m_parameterMetadata.getTypeMetadata().getType()) {
                dataWrapper.setVarChar(new String(byArray, "UTF-8"));
            } else {
                dataWrapper.setLongVarChar(new String(byArray, "UTF-8"));
            }
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CORRUPT_UTF.name());
        }
        return new ParameterInputValue(this.m_parameterMetadata, dataWrapper);
    }
}

