/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.support.exceptions;

import com.cloudera.impala.support.exceptions.ClientInfoException;
import com.cloudera.impala.support.exceptions.DataException;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import com.cloudera.impala.support.exceptions.FailedPropertiesReason;
import com.cloudera.impala.support.exceptions.FeatureNotSupportedException;
import com.cloudera.impala.support.exceptions.GeneralException;
import com.cloudera.impala.support.exceptions.IntegrityConstraintViolationException;
import com.cloudera.impala.support.exceptions.InvalidAuthorizationException;
import com.cloudera.impala.support.exceptions.NonTransientConnectionException;
import com.cloudera.impala.support.exceptions.NonTransientException;
import com.cloudera.impala.support.exceptions.RecoverableException;
import com.cloudera.impala.support.exceptions.SyntaxErrorException;
import com.cloudera.impala.support.exceptions.TimeOutException;
import com.cloudera.impala.support.exceptions.TransactionRollbackException;
import com.cloudera.impala.support.exceptions.TransientConnectionException;
import com.cloudera.impala.support.exceptions.TransientException;
import java.util.Map;

public class ExceptionBuilder {
    private int m_componentId = 0;

    public ExceptionBuilder(int n) {
        this.m_componentId = n;
    }

    public ErrorException createClientInfoException(String string, Map<String, FailedPropertiesReason> map) {
        return new ClientInfoException(this.m_componentId, string, map);
    }

    public <e> ErrorException createClientInfoException(Enum<?> enum_, Map<String, FailedPropertiesReason> map) {
        return new ClientInfoException(this.m_componentId, enum_.name(), map);
    }

    public ErrorException createCustomException(String string, String string2) {
        return this.createCustomErrorException(string, string2, null, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_) {
        return this.createCustomErrorException(string, enum_.name(), null, null, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String string, String string2, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, string2, null, null, exceptionType);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, enum_.name(), null, null, exceptionType);
    }

    public ErrorException createCustomException(String string, String string2, String string3) {
        return this.createCustomErrorException(string, string2, new String[]{string3}, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String string2) {
        return this.createCustomErrorException(string, enum_.name(), new String[]{string2}, null, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String string, String string2, String string3, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, string2, new String[]{string3}, null, exceptionType);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String string2, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, enum_.name(), new String[]{string2}, null, exceptionType);
    }

    public ErrorException createClientInfoException(String string, String string2, Map<String, FailedPropertiesReason> map) {
        return new ClientInfoException(this.m_componentId, string, new String[]{string2}, map);
    }

    public <e> ErrorException createClientInfoException(Enum<?> enum_, String string, Map<String, FailedPropertiesReason> map) {
        return new ClientInfoException(this.m_componentId, enum_.name(), new String[]{string}, map);
    }

    public ErrorException createClientInfoException(String string, String[] stringArray, Map<String, FailedPropertiesReason> map) {
        return new ClientInfoException(this.m_componentId, string, stringArray, map);
    }

    public <e> ErrorException createClientInfoException(Enum<?> enum_, String[] stringArray, Map<String, FailedPropertiesReason> map) {
        return new ClientInfoException(this.m_componentId, enum_.name(), stringArray, map);
    }

    public ErrorException createCustomException(String string, String string2, String[] stringArray) {
        return this.createCustomErrorException(string, string2, stringArray, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String[] stringArray) {
        return this.createCustomErrorException(string, enum_.name(), stringArray, null, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String string, String string2, String[] stringArray, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, string2, stringArray, null, exceptionType);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String[] stringArray, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, enum_.name(), stringArray, null, exceptionType);
    }

    public ErrorException createCustomException(String string, String string2, Throwable throwable) {
        return this.createCustomErrorException(string, string2, null, throwable, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, Throwable throwable) {
        return this.createCustomErrorException(string, enum_.name(), null, throwable, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String string, String string2, Throwable throwable, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, string2, null, throwable, exceptionType);
    }

    public ErrorException createCustomException(String string, Enum<?> enum_, Throwable throwable, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, enum_.name(), null, throwable, exceptionType);
    }

    public ErrorException createCustomException(String string, String string2, String string3, Throwable throwable) {
        return this.createCustomErrorException(string, string2, new String[]{string3}, throwable, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String string2, Throwable throwable) {
        return this.createCustomErrorException(string, enum_.name(), new String[]{string2}, throwable, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String string, String string2, String string3, Throwable throwable, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, string2, new String[]{string3}, throwable, exceptionType);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String string2, Throwable throwable, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, enum_.name(), new String[]{string2}, throwable, exceptionType);
    }

    public ErrorException createCustomException(String string, String string2, String[] stringArray, Throwable throwable) {
        return this.createCustomErrorException(string, string2, stringArray, throwable, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String[] stringArray, Throwable throwable) {
        return this.createCustomErrorException(string, enum_.name(), stringArray, throwable, ExceptionType.DEFAULT);
    }

    public ErrorException createCustomException(String string, String string2, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, string2, stringArray, throwable, exceptionType);
    }

    public <e> ErrorException createCustomException(String string, Enum<?> enum_, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        return this.createCustomErrorException(string, enum_.name(), stringArray, throwable, exceptionType);
    }

    public ErrorException createGeneralException(String string) {
        return this.createException(string, null, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_) {
        return this.createException(enum_.name(), null, null, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String string, ExceptionType exceptionType) {
        return this.createException(string, null, null, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, ExceptionType exceptionType) {
        return this.createException(enum_.name(), null, null, exceptionType);
    }

    public ErrorException createGeneralException(String string, String string2) {
        return this.createException(string, new String[]{string2}, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String string) {
        return this.createException(enum_.name(), new String[]{string}, null, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String string, String string2, ExceptionType exceptionType) {
        return this.createException(string, new String[]{string2}, null, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String string, ExceptionType exceptionType) {
        return this.createException(enum_.name(), new String[]{string}, null, exceptionType);
    }

    public ErrorException createGeneralException(String string, String[] stringArray) {
        return this.createException(string, stringArray, null, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String[] stringArray) {
        return this.createException(enum_.name(), stringArray, null, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String string, String[] stringArray, ExceptionType exceptionType) {
        return this.createException(string, stringArray, null, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String[] stringArray, ExceptionType exceptionType) {
        return this.createException(enum_.name(), stringArray, null, exceptionType);
    }

    public ErrorException createGeneralException(String string, String string2, Throwable throwable) {
        return this.createException(string, new String[]{string2}, throwable, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String string, Throwable throwable) {
        return this.createException(enum_.name(), new String[]{string}, throwable, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String string, String string2, Throwable throwable, ExceptionType exceptionType) {
        return this.createException(string, new String[]{string2}, throwable, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String string, Throwable throwable, ExceptionType exceptionType) {
        return this.createException(enum_.name(), new String[]{string}, throwable, exceptionType);
    }

    public ErrorException createGeneralException(String string, String[] stringArray, Throwable throwable) {
        return this.createException(string, stringArray, throwable, ExceptionType.DEFAULT);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String[] stringArray, Throwable throwable) {
        return this.createException(enum_.name(), stringArray, throwable, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String string, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        return this.createException(string, stringArray, throwable, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        return this.createException(enum_.name(), stringArray, throwable, exceptionType);
    }

    public ErrorException createGeneralException(String string, Throwable throwable) {
        return this.createException(string, null, throwable, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(Enum<?> enum_, Throwable throwable) {
        return this.createException(enum_.name(), null, throwable, ExceptionType.DEFAULT);
    }

    public ErrorException createGeneralException(String string, Throwable throwable, ExceptionType exceptionType) {
        return this.createException(string, null, throwable, exceptionType);
    }

    public <e> ErrorException createGeneralException(Enum<?> enum_, Throwable throwable, ExceptionType exceptionType) {
        return this.createException(enum_.name(), null, throwable, exceptionType);
    }

    private ErrorException createException(String string, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 4];
        System.arraycopy(stackTraceElementArray, 3, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        ErrorException errorException = null;
        errorException = null == stringArray ? (null == throwable ? this.generateException(string, exceptionType) : this.generateException(string, throwable, exceptionType)) : (null == throwable ? this.generateException(string, stringArray, exceptionType) : this.generateException(string, stringArray, throwable, exceptionType));
        errorException.setStackTrace(stackTraceElementArray2);
        return errorException;
    }

    private ErrorException createCustomErrorException(String string, String string2, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 4];
        System.arraycopy(stackTraceElementArray, 3, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        ErrorException errorException = null;
        errorException = null == stringArray ? (null == throwable ? this.generateException(string, string2, exceptionType) : this.generateException(string, string2, throwable, exceptionType)) : (null == throwable ? this.generateException(string, string2, stringArray, exceptionType) : this.generateException(string, string2, stringArray, throwable, exceptionType));
        errorException.setStackTrace(stackTraceElementArray2);
        return errorException;
    }

    private ErrorException generateException(String string, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, string, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, string);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, string);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, string);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, string);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, string);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, string);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, string);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, string);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, string);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, string);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, string);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, string);
            }
        }
        return new GeneralException(this.m_componentId, string);
    }

    private ErrorException generateException(String string, String[] stringArray, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, string, stringArray, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, string, stringArray);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, string, stringArray);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, string, stringArray);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, string, stringArray);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, string, stringArray);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, string, stringArray);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, string, stringArray);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, string, stringArray);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, string, stringArray);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, string, stringArray);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, string, stringArray);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, string, stringArray);
            }
        }
        return new GeneralException(this.m_componentId, string, stringArray);
    }

    private ErrorException generateException(String string, Throwable throwable, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, string, throwable, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, string, throwable);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, string, throwable);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, string, throwable);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, string, throwable);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, string, throwable);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, string, throwable);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, string, throwable);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, string, throwable);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, string, throwable);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, string, throwable);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, string, throwable);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, string, throwable);
            }
        }
        return new GeneralException(this.m_componentId, string, throwable);
    }

    private ErrorException generateException(String string, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(this.m_componentId, string, stringArray, throwable, null);
            }
            case DATA: {
                return new DataException(this.m_componentId, string, stringArray, throwable);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(this.m_componentId, string, stringArray, throwable);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(this.m_componentId, string, stringArray, throwable);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(this.m_componentId, string, stringArray, throwable);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(this.m_componentId, string, stringArray, throwable);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(this.m_componentId, string, stringArray, throwable);
            }
            case RECOVERABLE: {
                return new RecoverableException(this.m_componentId, string, stringArray, throwable);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(this.m_componentId, string, stringArray, throwable);
            }
            case TIME_OUT: {
                return new TimeOutException(this.m_componentId, string, stringArray, throwable);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(this.m_componentId, string, stringArray, throwable);
            }
            case TRANSIENT: {
                return new TransientException(this.m_componentId, string, stringArray, throwable);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(this.m_componentId, string, stringArray, throwable);
            }
        }
        return new GeneralException(this.m_componentId, string, stringArray, throwable);
    }

    private ErrorException generateException(String string, String string2, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(string, this.m_componentId, string2, null);
            }
            case DATA: {
                return new DataException(string, this.m_componentId, string2);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(string, this.m_componentId, string2);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(string, this.m_componentId, string2);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(string, this.m_componentId, string2);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(string, this.m_componentId, string2);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(string, this.m_componentId, string2);
            }
            case RECOVERABLE: {
                return new RecoverableException(string, this.m_componentId, string2);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(string, this.m_componentId, string2);
            }
            case TIME_OUT: {
                return new TimeOutException(string, this.m_componentId, string2);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(string, this.m_componentId, string2);
            }
            case TRANSIENT: {
                return new TransientException(string, this.m_componentId, string2);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(string, this.m_componentId, string2);
            }
        }
        return new ErrorException(string, this.m_componentId, string2);
    }

    private ErrorException generateException(String string, String string2, String[] stringArray, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(string, this.m_componentId, string2, stringArray, null);
            }
            case DATA: {
                return new DataException(string, this.m_componentId, string2, stringArray);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(string, this.m_componentId, string2, stringArray);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(string, this.m_componentId, string2, stringArray);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(string, this.m_componentId, string2, stringArray);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(string, this.m_componentId, string2, stringArray);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(string, this.m_componentId, string2, stringArray);
            }
            case RECOVERABLE: {
                return new RecoverableException(string, this.m_componentId, string2, stringArray);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(string, this.m_componentId, string2, stringArray);
            }
            case TIME_OUT: {
                return new TimeOutException(string, this.m_componentId, string2, stringArray);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(string, this.m_componentId, string2, stringArray);
            }
            case TRANSIENT: {
                return new TransientException(string, this.m_componentId, string2, stringArray);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(string, this.m_componentId, string2, stringArray);
            }
        }
        return new ErrorException(string, this.m_componentId, string2, stringArray);
    }

    private ErrorException generateException(String string, String string2, Throwable throwable, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(string, this.m_componentId, string2, throwable, null);
            }
            case DATA: {
                return new DataException(string, this.m_componentId, string2, throwable);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(string, this.m_componentId, string2, throwable);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(string, this.m_componentId, string2, throwable);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(string, this.m_componentId, string2, throwable);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(string, this.m_componentId, string2, throwable);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(string, this.m_componentId, string2, throwable);
            }
            case RECOVERABLE: {
                return new RecoverableException(string, this.m_componentId, string2, throwable);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(string, this.m_componentId, string2, throwable);
            }
            case TIME_OUT: {
                return new TimeOutException(string, this.m_componentId, string2, throwable);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(string, this.m_componentId, string2, throwable);
            }
            case TRANSIENT: {
                return new TransientException(string, this.m_componentId, string2, throwable);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(string, this.m_componentId, string2, throwable);
            }
        }
        return new ErrorException(string, this.m_componentId, string2, throwable);
    }

    private ErrorException generateException(String string, String string2, String[] stringArray, Throwable throwable, ExceptionType exceptionType) {
        if (null == exceptionType) {
            exceptionType = ExceptionType.DEFAULT;
        }
        switch (exceptionType) {
            case CLIENT_INFO: {
                return new ClientInfoException(string, this.m_componentId, string2, stringArray, throwable, null);
            }
            case DATA: {
                return new DataException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case FEATURE_NOT_IMPLEMENTED: {
                return new FeatureNotSupportedException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case INTEGRITY_CONSTRAINT_VIOLATION: {
                return new IntegrityConstraintViolationException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case INVALID_AUTHORIZATION: {
                return new InvalidAuthorizationException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case NON_TRANSIENT: {
                return new NonTransientException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case NON_TRANSIENT_CONNECTION: {
                return new NonTransientConnectionException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case RECOVERABLE: {
                return new RecoverableException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case SYNTAX_ERROR: {
                return new SyntaxErrorException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case TIME_OUT: {
                return new TimeOutException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case TRANSACTION_ROLLBACK: {
                return new TransactionRollbackException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case TRANSIENT: {
                return new TransientException(string, this.m_componentId, string2, stringArray, throwable);
            }
            case TRANSIENT_CONNECTION: {
                return new TransientConnectionException(string, this.m_componentId, string2, stringArray, throwable);
            }
        }
        return new ErrorException(string, this.m_componentId, string2, stringArray, throwable);
    }
}

