/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.jdbc42;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.exceptions.IncorrectTypeException;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.exceptions.JDBCMessageKey;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.CurrentBufferContext;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.impala.hivecommon.jdbc42.Hive42ForwardResultSet;
import com.cloudera.impala.jdbc.common.SStatement;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ExceptionType;
import com.cloudera.impala.utilities.TypeNames;
import com.cloudera.impala.utilities.conversion.TypeConverter;
import java.sql.SQLException;
import java.sql.Timestamp;

public class Hive42ForwardMaterializedResultSet
extends Hive42ForwardResultSet {
    private HiveJDBCSettings m_settings;
    private CurrentBufferContext m_currentBufferContext;

    public Hive42ForwardMaterializedResultSet(SStatement sStatement, HiveJDBCResultSet hiveJDBCResultSet, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) throws SQLException {
        super(sStatement, hiveJDBCResultSet, iLogger);
        LogUtilities.logFunctionEntrance(iLogger, sStatement, hiveJDBCResultSet, iLogger, hiveJDBCSettings);
        this.m_settings = hiveJDBCSettings;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object;
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        this.checkIfOpen();
        this.closeCurrentStream();
        this.checkIfValidColumnNumber(n);
        this.checkIfValidRowNumber();
        --n;
        if (null == this.m_currentBufferContext) {
            this.m_currentBufferContext = ((HiveJDBCResultSet)this.m_resultSet).getCurrentBufferContext();
        }
        boolean bl = this.m_wasLastValueNull = null == (object = this.m_currentBufferContext.m_currentRowObjectArray[n]);
        if (this.m_wasLastValueNull) {
            return null;
        }
        return object;
    }

    @Override
    public String getString(int n) throws SQLException {
        try {
            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                LogUtilities.logFunctionEntrance(this.m_logger, n);
            }
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                int n2 = dataWrapper.getType();
                if (12 == n2) {
                    return dataWrapper.getVarChar();
                }
                if (1 == n2) {
                    return dataWrapper.getChar();
                }
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toString(dataWrapper, iColumn.getTypeMetadata());
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(12));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                LogUtilities.logFunctionEntrance(this.m_logger, n);
            }
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getData(n, -1L);
            try {
                this.m_wasLastValueNull = dataWrapper.isNull();
                if (93 == this.getType()) {
                    return dataWrapper.getTimestamp();
                }
                IColumn iColumn = (IColumn)this.m_resultSetColumns.get(n - 1);
                return TypeConverter.toTimestamp(dataWrapper, iColumn.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected DataWrapper getData(int n, long l) throws SQLException {
        if (-1L == l) {
            try {
                this.checkIfValidColumnNumber(n);
                this.checkIfValidRowNumber();
                return ((HiveJDBCResultSet)this.m_resultSet).getDataWrapper(--n);
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
            }
        }
        return super.getData(n, l);
    }
}

