/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.utils;

import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.jdbc.utils.DSEncryptionProperties;
import com.cloudera.impala.jdbc.utils.DSStringCache;
import com.cloudera.impala.jdbc.utils.DSStringEncryptedCache;
import com.cloudera.impala.jdbc.utils.DSStringFileCache;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.regex.Pattern;

public class OAuthTokenCache {
    private static Boolean DS_DO_NOT_REDACT_KEY_STR_IN_LOG_OR_ERR_MSG = false;
    private static Boolean DS_REDACT_VAL_STR_IN_LOG_OR_ERR_MSG = false;
    private static String TEMP_FILE_DIRECTORY_KEY = "java.io.tmpdir";
    private static char DELIMITER_CHAR = (char)32;
    private static String CACHE_FILE_NAME_SUFFIX = "OAuth2TokenCache";
    private static final String SYSTEM_CURRENT_USER = "user.name";
    private DSStringEncryptedCache m_cache;

    public OAuthTokenCache(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, String string) throws ErrorException {
        String string2 = "Cloudera" + hiveJDBCSettings.m_platformVersionUtils.getDriverNamePrefix();
        Pattern pattern = Pattern.compile("[\\\\\\\\/:*?\\\"<>|.]");
        String string3 = System.getProperty(TEMP_FILE_DIRECTORY_KEY) + string2 + "_" + CACHE_FILE_NAME_SUFFIX + "_" + pattern.matcher(System.getProperty(SYSTEM_CURRENT_USER)).replaceAll("");
        DSEncryptionProperties dSEncryptionProperties = new DSEncryptionProperties(hiveJDBCSettings.m_tokenCachePassphrase, string, iLogger, false);
        this.m_cache = new DSStringEncryptedCache(iLogger, new DSStringFileCache(iLogger, string3, DS_DO_NOT_REDACT_KEY_STR_IN_LOG_OR_ERR_MSG, DS_REDACT_VAL_STR_IN_LOG_OR_ERR_MSG, DELIMITER_CHAR), DS_DO_NOT_REDACT_KEY_STR_IN_LOG_OR_ERR_MSG, DS_REDACT_VAL_STR_IN_LOG_OR_ERR_MSG, dSEncryptionProperties);
    }

    public DSStringCache getTokenCache() {
        return this.m_cache;
    }
}

