/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.jsontype.impl;

import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.annotation.JsonTypeInfo;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.DatabindContext;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.DeserializationContext;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.DeserializationFeature;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.JavaType;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.cfg.MapperConfig;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.jsontype.NamedType;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.type.TypeFactory;
import com.cloudera.impala.jdbc42.internal.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class ClassNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JAVA_UTIL_PKG = "java.util.";
    protected final PolymorphicTypeValidator _subTypeValidator;
    protected final Set<String> _allowedSubtypes;

    @Deprecated
    protected ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
        this(baseType, typeFactory, LaissezFaireSubTypeValidator.instance);
    }

    @Deprecated
    public ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory, PolymorphicTypeValidator ptv) {
        this(baseType, typeFactory, null, ptv);
    }

    public ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory, Collection<NamedType> subtypes, PolymorphicTypeValidator ptv) {
        super(baseType, typeFactory);
        this._subTypeValidator = ptv;
        HashSet<String> allowedSubtypes = null;
        if (subtypes != null) {
            for (NamedType t : subtypes) {
                if (allowedSubtypes == null) {
                    allowedSubtypes = new HashSet<String>();
                }
                allowedSubtypes.add(t.getType().getName());
            }
        }
        this._allowedSubtypes = allowedSubtypes == null ? Collections.emptySet() : allowedSubtypes;
    }

    @Deprecated
    public static ClassNameIdResolver construct(JavaType baseType, MapperConfig<?> config, PolymorphicTypeValidator ptv) {
        return new ClassNameIdResolver(baseType, config.getTypeFactory(), ptv);
    }

    public static ClassNameIdResolver construct(JavaType baseType, MapperConfig<?> config, Collection<NamedType> subtypes, PolymorphicTypeValidator ptv) {
        return new ClassNameIdResolver(baseType, config.getTypeFactory(), subtypes, ptv);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    @Deprecated
    public void registerSubtype(Class<?> type, String name) {
    }

    @Override
    public String idFromValue(Object value) {
        return this._idFrom(value, value.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> type) {
        return this._idFrom(value, type, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        return this._typeFromId(id, context);
    }

    protected JavaType _typeFromId(String id, DatabindContext ctxt) throws IOException {
        DeserializationContext deserializationContext = null;
        if (ctxt instanceof DeserializationContext) {
            deserializationContext = (DeserializationContext)ctxt;
        }
        if (this._allowedSubtypes != null && deserializationContext != null && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED) && !this._allowedSubtypes.contains(id)) {
            throw deserializationContext.invalidTypeIdException(this._baseType, id, "`DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED` is enabled and the input class is not registered using `@JsonSubTypes` annotation");
        }
        JavaType t = ctxt.resolveAndValidateSubType(this._baseType, id, this._subTypeValidator);
        if (t == null && deserializationContext != null) {
            return deserializationContext.handleUnknownTypeId(this._baseType, id, this, "no such class found");
        }
        return t;
    }

    protected String _idFrom(Object value, Class<?> cls, TypeFactory typeFactory) {
        Class<?> staticType;
        Class<?> outer;
        String str = (cls = this._resolveToParentAsNecessary(cls)).getName();
        if (str.startsWith(JAVA_UTIL_PKG)) {
            if (value instanceof EnumSet) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumSet)value);
                str = typeFactory.constructCollectionType(EnumSet.class, enumClass).toCanonical();
            } else if (value instanceof EnumMap) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumMap)value);
                Class<Object> valueClass = Object.class;
                str = typeFactory.constructMapType(EnumMap.class, enumClass, valueClass).toCanonical();
            }
        } else if (str.indexOf(36) >= 0 && (outer = ClassUtil.getOuterClass(cls)) != null && ClassUtil.getOuterClass(staticType = this._baseType.getRawClass()) == null) {
            cls = this._baseType.getRawClass();
            str = cls.getName();
        }
        return str;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

