/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aeoptimizer;

import com.cloudera.impala.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AERename;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEUnaryValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class NullExpressionVisitor
extends AEDefaultVisitor<Set<AERelationalExpr>> {
    private static final NullExpressionVisitor INSTANCE = new NullExpressionVisitor();

    NullExpressionVisitor() {
    }

    public static NullExpressionVisitor instance() {
        return INSTANCE;
    }

    @Override
    public Set<AERelationalExpr> visit(AEColumnReference aEColumnReference) throws ErrorException {
        return new HashSet<AERelationalExpr>(Arrays.asList(aEColumnReference.getNamedRelationalExpr()));
    }

    @Override
    public Set<AERelationalExpr> visit(AEValueExprList aEValueExprList) throws ErrorException {
        return ((AEValueExpr)aEValueExprList.getChild(0)).acceptVisitor(this);
    }

    @Override
    public Set<AERelationalExpr> visit(AEAdd aEAdd) throws ErrorException {
        return this.visitBinary(aEAdd);
    }

    @Override
    public Set<AERelationalExpr> visit(AESubtract aESubtract) throws ErrorException {
        return this.visitBinary(aESubtract);
    }

    @Override
    public Set<AERelationalExpr> visit(AEMultiply aEMultiply) throws ErrorException {
        return this.visitBinary(aEMultiply);
    }

    @Override
    public Set<AERelationalExpr> visit(AEDivide aEDivide) throws ErrorException {
        return this.visitBinary(aEDivide);
    }

    @Override
    public Set<AERelationalExpr> visit(AEConcat aEConcat) throws ErrorException {
        return this.visitBinary(aEConcat);
    }

    @Override
    public Set<AERelationalExpr> visit(AENegate aENegate) throws ErrorException {
        return this.visitUnary(aENegate);
    }

    @Override
    public Set<AERelationalExpr> visit(AERename aERename) throws ErrorException {
        return this.visitUnary(aERename);
    }

    @Override
    protected Set<AERelationalExpr> defaultVisit(IAENode iAENode) throws ErrorException {
        return new HashSet<AERelationalExpr>();
    }

    private Set<AERelationalExpr> visitUnary(AEUnaryValueExpr aEUnaryValueExpr) throws ErrorException {
        return aEUnaryValueExpr.getOperand().acceptVisitor(this);
    }

    private Set<AERelationalExpr> visitBinary(AEBinaryValueExpr aEBinaryValueExpr) throws ErrorException {
        Set<AERelationalExpr> set = aEBinaryValueExpr.getLeftOperand().acceptVisitor(this);
        set.addAll((Collection<AERelationalExpr>)aEBinaryValueExpr.getRightOperand().acceptVisitor(this));
        return set;
    }
}

