/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.aeprocessor.aetree.value;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.AEAbstractColumnInfo;
import com.cloudera.impala.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.impala.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.Collections;
import java.util.Iterator;

public class AEProxyColumn
extends AEValueExpr {
    private static final int NUM_CHILDREN = 0;
    private AEQueryScope m_resolvedQueryScope;
    private int m_columnNumber;
    private AERelationalExpr m_relExpr;
    private IColumnInfo m_columnInfo;
    private final String m_refToLogString;

    public AEProxyColumn(AEValueExpr aEValueExpr, AEQueryScope aEQueryScope, int n) {
        assert (null != aEQueryScope && null != aEValueExpr);
        AECoercionColumnInfo.ColumnTypeFinder columnTypeFinder = new AECoercionColumnInfo.ColumnTypeFinder();
        IColumnInfo.ColumnType columnType = null;
        try {
            columnType = aEValueExpr.acceptVisitor(columnTypeFinder);
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
        String string = columnTypeFinder.getLiterString();
        this.m_columnInfo = new ProxyColumnInfo(columnType, string, aEValueExpr.getColumn());
        this.m_resolvedQueryScope = aEQueryScope;
        this.m_columnNumber = n;
        this.m_refToLogString = aEValueExpr.getLogString();
    }

    public AEProxyColumn(AEProxyColumn aEProxyColumn) {
        this.m_columnNumber = aEProxyColumn.m_columnNumber;
        this.m_resolvedQueryScope = aEProxyColumn.m_resolvedQueryScope;
        this.m_relExpr = aEProxyColumn.m_relExpr;
        this.m_refToLogString = aEProxyColumn.m_refToLogString;
        try {
            this.m_columnInfo = new ProxyColumnInfo(aEProxyColumn.m_columnInfo.getColumnType(), aEProxyColumn.m_columnInfo.getLiteralString(), new ColumnMetadata(TypeMetadata.createTypeMetadata(aEProxyColumn.m_columnInfo.getType(), aEProxyColumn.m_columnInfo.getPrecision(), aEProxyColumn.m_columnInfo.getScale(), aEProxyColumn.m_columnInfo.getIntervalPrecision(), aEProxyColumn.m_columnInfo.isSigned())));
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.runtimeException(errorException);
        }
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    public IColumnInfo getProxiedColumnInfo() {
        return this.m_columnInfo;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (iAENode == this) {
            return true;
        }
        if (!(iAENode instanceof AEProxyColumn)) {
            return false;
        }
        AEProxyColumn aEProxyColumn = (AEProxyColumn)iAENode;
        return aEProxyColumn.m_relExpr == this.m_relExpr && aEProxyColumn.m_columnNumber == this.m_columnNumber;
    }

    @Override
    public IColumn getColumn() {
        if (null != this.m_relExpr) {
            return this.m_relExpr.getColumn(this.m_columnNumber);
        }
        return ((ProxyColumnInfo)this.m_columnInfo).m_columnMeta;
    }

    public AEQueryScope getResolvedQueryScope() {
        return this.m_resolvedQueryScope;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public AEProxyColumn copy() {
        return new AEProxyColumn(this);
    }

    public AERelationalExpr getRelationalExpr() {
        return this.m_relExpr;
    }

    @Override
    public String getLogString() {
        String string = super.getLogString() + ": " + this.m_refToLogString;
        IColumn iColumn = this.getColumn();
        if (null == iColumn || iColumn.isUnnamed()) {
            string = string + ": column #" + Integer.toString(this.getColumnNumber());
        } else {
            String string2;
            String string3;
            StringBuilder stringBuilder = new StringBuilder(30);
            stringBuilder.append(string);
            stringBuilder.append(": ");
            String string4 = iColumn.getCatalogName();
            if (null != string4 && string4.length() > 0) {
                stringBuilder.append(string4);
                stringBuilder.append(".");
            }
            if (null != (string3 = iColumn.getSchemaName()) && string3.length() > 0) {
                stringBuilder.append(string3);
                stringBuilder.append(".");
            }
            if (null != (string2 = iColumn.getTableName()) && string2.length() > 0) {
                stringBuilder.append(string2);
                stringBuilder.append(".");
            }
            stringBuilder.append(iColumn.getName());
            string = stringBuilder.toString();
        }
        return string;
    }

    public void setRelationalExpr(AERelationalExpr aERelationalExpr) {
        this.m_relExpr = aERelationalExpr;
    }

    @Override
    public void updateColumn() throws ErrorException {
    }

    private static class ProxyColumnInfo
    extends AEAbstractColumnInfo {
        private IColumnInfo.ColumnType m_type;
        private String m_literalString;
        private IColumn m_columnMeta;

        public ProxyColumnInfo(IColumnInfo.ColumnType columnType, String string, IColumn iColumn) {
            this.m_type = columnType;
            this.m_literalString = string;
            this.m_columnMeta = iColumn;
        }

        @Override
        public IColumnInfo.ColumnType getColumnType() {
            return this.m_type;
        }

        @Override
        public String getLiteralString() {
            return this.m_literalString;
        }

        @Override
        public IColumn getColumnMetadata() {
            return this.m_columnMeta;
        }
    }
}

