/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.sqlengine.executor.conversions.ConversionUtil;
import com.cloudera.impala.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.impala.sqlengine.executor.etree.value.ETUnaryValueExpr;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.support.exceptions.ErrorException;

public final class ETConvert
extends ETUnaryValueExpr {
    private final ETDataRequest m_sourceData;
    private final ISqlConverter m_converter;
    private final boolean m_errorOnTruncation;

    public ETConvert(ETValueExpr eTValueExpr, IColumn iColumn, ISqlConverter iSqlConverter) throws ErrorException {
        this(eTValueExpr, iColumn, iSqlConverter, false);
    }

    public ETConvert(ETValueExpr eTValueExpr, IColumn iColumn, ISqlConverter iSqlConverter, boolean bl) throws ErrorException {
        super(eTValueExpr);
        this.m_sourceData = new ETDataRequest(iColumn);
        this.m_sourceData.setMaxBytes(-1L);
        this.m_sourceData.setOffset(0L);
        this.m_converter = iSqlConverter;
        this.m_errorOnTruncation = bl;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        boolean bl = this.getOperand().retrieveData(this.m_sourceData);
        if (bl) {
            throw new IllegalStateException("Has more data after retrieve all data");
        }
        return ConversionUtil.doConvert(eTDataRequest, this.m_sourceData.getData(), this.m_converter, this.getWarningListener(), this.m_errorOnTruncation);
    }

    @Override
    public DataWrapper getCachedDataWrapper() {
        return this.getOperand().getCachedDataWrapper();
    }

    @Override
    public void setCachedDataWrapper(DataWrapper dataWrapper) {
        this.getOperand().setCachedDataWrapper(dataWrapper);
    }
}

