/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value.scalar;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.impala.support.conv.ConverterConstants;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.sql.Time;
import java.util.GregorianCalendar;
import java.util.List;

public final class ETCurrentTime1Fn
extends ETScalarFn {
    private int m_outputTimePrecision;
    private long m_timeInMillis;

    public ETCurrentTime1Fn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == list.size() && 1 == list2.size());
        this.m_outputTimePrecision = Math.min(iColumn.getTypeMetadata().getPrecision(), 3);
    }

    @Override
    public void open() throws ErrorException {
        super.open();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1970, 0, 1);
        long l = gregorianCalendar.getTimeInMillis();
        this.m_timeInMillis = l - l % (long)ConverterConstants.MILLIS_MOD[this.m_outputTimePrecision];
    }

    @Override
    public String getLogString() {
        return "ETCurrentTime1Fn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        assert (this.isOpen());
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            int n = Math.max((int)iSqlDataWrapper.getInteger(), 0);
            long l = this.m_timeInMillis;
            if (n < this.m_outputTimePrecision) {
                l -= l % (long)ConverterConstants.MILLIS_MOD[n];
            }
            eTDataRequest.getData().setTime(new Time(l));
        }
        return false;
    }
}

