/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.support.channels;

import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.channels.AbstractSocketChannel;
import com.cloudera.impala.support.channels.IHostNameValidator;
import com.cloudera.impala.support.channels.SocketChannelMessageKey;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class HostNameValidator
implements IHostNameValidator {
    @Override
    public void enableHostnameValidation(SSLEngine sSLEngine, ILogger iLogger) throws ErrorException {
        try {
            SSLParameters sSLParameters = new SSLParameters();
            Method method = sSLParameters.getClass().getMethod("setEndpointIdentificationAlgorithm", String.class);
            method.invoke((Object)sSLParameters, "HTTPS");
            sSLEngine.setSSLParameters(sSLParameters);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogUtilities.logError(noSuchMethodException, iLogger);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VALIDATION_ERR_JVM_NOT_CAPABLE.name(), noSuchMethodException.getMessage(), (Throwable)noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogUtilities.logError(illegalArgumentException, iLogger);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VALIDATION_ERR_JVM_NOT_CAPABLE.name(), illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogUtilities.logError(illegalAccessException, iLogger);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VERIFICATION_ERR_JVM_PREVENTING_ACCESS.name(), illegalAccessException.getMessage(), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogUtilities.logError(invocationTargetException, iLogger);
            throw AbstractSocketChannel.EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.TLS_HOSTNAME_VERIFICATION_ERR.name(), invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
    }
}

