/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cert.crmf;

import com.databricks.internal.bouncycastle.asn1.ASN1OctetString;
import com.databricks.internal.bouncycastle.asn1.DERBitString;
import com.databricks.internal.bouncycastle.asn1.crmf.EncryptedValue;
import com.databricks.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.cert.X509CertificateHolder;
import com.databricks.internal.bouncycastle.cert.crmf.CRMFException;
import com.databricks.internal.bouncycastle.cert.crmf.EncryptedValuePadder;
import com.databricks.internal.bouncycastle.operator.KeyWrapper;
import com.databricks.internal.bouncycastle.operator.OperatorException;
import com.databricks.internal.bouncycastle.operator.OutputEncryptor;
import com.databricks.internal.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.databricks.internal.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfoBuilder;
import com.databricks.internal.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedValueBuilder {
    private KeyWrapper wrapper;
    private OutputEncryptor encryptor;
    private EncryptedValuePadder padder;

    public EncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        this(keyWrapper, outputEncryptor, null);
    }

    public EncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor, EncryptedValuePadder encryptedValuePadder) {
        this.wrapper = keyWrapper;
        this.encryptor = outputEncryptor;
        this.padder = encryptedValuePadder;
    }

    public EncryptedValue build(char[] cArray) throws CRMFException {
        return this.encryptData(this.padData(Strings.toUTF8ByteArray(cArray)));
    }

    public EncryptedValue build(X509CertificateHolder x509CertificateHolder) throws CRMFException {
        try {
            return this.encryptData(this.padData(x509CertificateHolder.getEncoded()));
        }
        catch (IOException iOException) {
            throw new CRMFException("cannot encode certificate: " + iOException.getMessage(), iOException);
        }
    }

    public EncryptedValue build(PrivateKeyInfo privateKeyInfo) throws CRMFException {
        PKCS8EncryptedPrivateKeyInfoBuilder pKCS8EncryptedPrivateKeyInfoBuilder = new PKCS8EncryptedPrivateKeyInfoBuilder(privateKeyInfo);
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        AlgorithmIdentifier algorithmIdentifier2 = this.encryptor.getAlgorithmIdentifier();
        try {
            PKCS8EncryptedPrivateKeyInfo pKCS8EncryptedPrivateKeyInfo = pKCS8EncryptedPrivateKeyInfoBuilder.build(this.encryptor);
            DERBitString dERBitString = new DERBitString(this.wrapper.generateWrappedKey(this.encryptor.getKey()));
            AlgorithmIdentifier algorithmIdentifier3 = this.wrapper.getAlgorithmIdentifier();
            ASN1OctetString aSN1OctetString = null;
            return new EncryptedValue(algorithmIdentifier, algorithmIdentifier2, dERBitString, algorithmIdentifier3, aSN1OctetString, new DERBitString(pKCS8EncryptedPrivateKeyInfo.getEncryptedData()));
        }
        catch (IllegalStateException illegalStateException) {
            throw new CRMFException("cannot encode key: " + illegalStateException.getMessage(), illegalStateException);
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("cannot wrap key: " + operatorException.getMessage(), operatorException);
        }
    }

    private EncryptedValue encryptData(byte[] byArray) throws CRMFException {
        DERBitString dERBitString;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = this.encryptor.getOutputStream(byteArrayOutputStream);
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("cannot process data: " + iOException.getMessage(), iOException);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = this.encryptor.getAlgorithmIdentifier();
        try {
            this.wrapper.generateWrappedKey(this.encryptor.getKey());
            dERBitString = new DERBitString(this.wrapper.generateWrappedKey(this.encryptor.getKey()));
        }
        catch (OperatorException operatorException) {
            throw new CRMFException("cannot wrap key: " + operatorException.getMessage(), operatorException);
        }
        AlgorithmIdentifier algorithmIdentifier3 = this.wrapper.getAlgorithmIdentifier();
        ASN1OctetString aSN1OctetString = null;
        DERBitString dERBitString2 = new DERBitString(byteArrayOutputStream.toByteArray());
        return new EncryptedValue(algorithmIdentifier, algorithmIdentifier2, dERBitString, algorithmIdentifier3, aSN1OctetString, dERBitString2);
    }

    private byte[] padData(byte[] byArray) {
        if (this.padder != null) {
            return this.padder.getPaddedData(byArray);
        }
        return byArray;
    }
}

