/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.common;

import com.databricks.jdbc.dbclient.IDatabricksClient;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksTimeoutException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.util.concurrent.TimeUnit;

public class TimeoutHandler {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(TimeoutHandler.class);
    private final long startTimeMillis = System.currentTimeMillis();
    private final int timeoutSeconds;
    private final String operationDescription;
    private final Runnable onTimeoutAction;

    public TimeoutHandler(int timeoutSeconds, String operationDescription, Runnable onTimeoutAction) {
        this.timeoutSeconds = timeoutSeconds;
        this.operationDescription = operationDescription;
        this.onTimeoutAction = onTimeoutAction;
    }

    public void checkTimeout() throws DatabricksTimeoutException {
        if (this.timeoutSeconds <= 0) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        long elapsedTimeSeconds = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis - this.startTimeMillis);
        if (elapsedTimeSeconds > (long)this.timeoutSeconds) {
            try {
                if (this.onTimeoutAction != null) {
                    this.onTimeoutAction.run();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to execute timeout action: " + e.getMessage());
            }
            String timeoutErrorMessage = String.format("Statement execution timed-out after %d seconds. Operation: %s", this.timeoutSeconds, this.operationDescription);
            LOGGER.error(timeoutErrorMessage);
            throw new DatabricksTimeoutException(timeoutErrorMessage);
        }
    }

    public static TimeoutHandler forStatement(int timeoutSeconds, StatementId statementId, IDatabricksClient client) {
        return new TimeoutHandler(timeoutSeconds, "Statement ID: " + String.valueOf(statementId), () -> {
            try {
                client.cancelStatement(statementId);
            }
            catch (Exception e) {
                LOGGER.warn("Cancel statement on timeout failed: " + e.getMessage());
            }
        });
    }
}

