/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.nio.ByteBuffer;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.ByteString;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;

public class PutResult
implements AutoCloseable {
    private ArrowBuf applicationMetadata;

    private PutResult(ArrowBuf metadata) {
        this.applicationMetadata = metadata;
    }

    public static PutResult metadata(ArrowBuf metadata) {
        if (metadata == null) {
            return PutResult.empty();
        }
        return new PutResult(metadata);
    }

    public static PutResult empty() {
        return new PutResult(null);
    }

    public ArrowBuf getApplicationMetadata() {
        return this.applicationMetadata;
    }

    Flight.PutResult toProtocol() {
        if (this.applicationMetadata == null) {
            return Flight.PutResult.getDefaultInstance();
        }
        return Flight.PutResult.newBuilder().setAppMetadata(ByteString.copyFrom(this.applicationMetadata.nioBuffer())).build();
    }

    static PutResult fromProtocol(BufferAllocator allocator, Flight.PutResult message) {
        ArrowBuf buf = allocator.buffer(message.getAppMetadata().size());
        message.getAppMetadata().asReadOnlyByteBufferList().forEach(bb -> {
            buf.setBytes(buf.writerIndex(), (ByteBuffer)bb);
            buf.writerIndex(buf.writerIndex() + (long)bb.limit());
        });
        return new PutResult(buf);
    }

    @Override
    public void close() {
        if (this.applicationMetadata != null) {
            this.applicationMetadata.close();
        }
    }
}

