/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.AbstractService;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.Service;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public abstract class JsonService
extends AbstractService {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public abstract String apply(String var1);

    @Override
    AbstractService.SerializationType getSerializationType() {
        return AbstractService.SerializationType.JSON;
    }

    protected static <T> T decode(String response, Class<T> expectedType) throws IOException {
        Service.Response resp = MAPPER.readValue(response, Service.Response.class);
        if (resp instanceof Service.ErrorResponse) {
            throw ((Service.ErrorResponse)resp).toException();
        }
        if (!expectedType.isAssignableFrom(resp.getClass())) {
            throw new ClassCastException("Cannot cast " + resp.getClass() + " into " + expectedType);
        }
        return expectedType.cast(resp);
    }

    protected static <T> String encode(T request) throws IOException {
        StringWriter w = new StringWriter();
        MAPPER.writeValue(w, request);
        return w.toString();
    }

    protected RuntimeException handle(IOException e) {
        return new RuntimeException(e);
    }

    @Override
    public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.SchemasRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.TablesRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.TableTypesRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.TypeInfoRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.ColumnsRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.PrepareResponse apply(Service.PrepareRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.PrepareResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ExecuteResponse apply(Service.PrepareAndExecuteRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ExecuteResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.FetchResponse apply(Service.FetchRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.FetchResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ExecuteResponse apply(Service.ExecuteRequest request) {
        try {
            return this.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ExecuteResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.CreateStatementResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CloseStatementResponse apply(Service.CloseStatementRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.CloseStatementResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.OpenConnectionResponse apply(Service.OpenConnectionRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.OpenConnectionResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CloseConnectionResponse apply(Service.CloseConnectionRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.CloseConnectionResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ConnectionSyncResponse apply(Service.ConnectionSyncRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ConnectionSyncResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.DatabasePropertyResponse apply(Service.DatabasePropertyRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.DatabasePropertyResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.SyncResultsResponse apply(Service.SyncResultsRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.SyncResultsResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CommitResponse apply(Service.CommitRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.CommitResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.RollbackResponse apply(Service.RollbackRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.RollbackResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ExecuteBatchResponse apply(Service.PrepareAndExecuteBatchRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ExecuteBatchResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ExecuteBatchResponse apply(Service.ExecuteBatchRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ExecuteBatchResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    static {
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        MAPPER.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

