/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.influxdb;

import com.influxdb.client.QueryApi;
import com.influxdb.client.domain.Bucket;
import com.influxdb.client.domain.Organization;
import com.influxdb.query.FluxColumn;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.wisecoders.jdbc.common.ArrayResultSet;
import com.wisecoders.jdbc.common.sql.AbstractDatabaseMetaData;
import com.wisecoders.jdbc.influxdb.InfluxConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J=\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0010\u0010\u000e\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J,\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0002J0\u0010\u0016\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0016J6\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0002J&\u0010\u001e\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u000bH\u0016J6\u0010!\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/wisecoders/jdbc/influxdb/InfluxMetaData;", "Lcom/wisecoders/jdbc/common/sql/AbstractDatabaseMetaData;", "influxConnection", "Lcom/wisecoders/jdbc/influxdb/InfluxConnection;", "<init>", "(Lcom/wisecoders/jdbc/influxdb/InfluxConnection;)V", "getSchemas", "Ljava/sql/ResultSet;", "getCatalogs", "getTables", "catalog", "", "schemaPattern", "tableNamePattern", "types", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/ResultSet;", "createTableRow", "", "catalogName", "tableName", "comment", "getColumns", "columnNamePattern", "addColumn", "", "result", "Lcom/wisecoders/jdbc/common/ArrayResultSet;", "columnName", "columnDataType", "getPrimaryKeys", "schema", "table", "getIndexInfo", "unique", "", "approximate", "Companion", "jdbc-driver-influxdb"})
public final class InfluxMetaData
extends AbstractDatabaseMetaData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InfluxConnection influxConnection;

    public InfluxMetaData(@NotNull InfluxConnection influxConnection) {
        Intrinsics.checkNotNullParameter((Object)((Object)influxConnection), (String)"influxConnection");
        this.influxConnection = influxConnection;
    }

    @NotNull
    public ResultSet getSchemas() {
        ArrayResultSet result = new ArrayResultSet();
        String[] stringArray = new String[]{"TABLE_SCHEMA", "TABLE_CAT"};
        result.setColumnNames(CollectionsKt.listOf((Object[])stringArray));
        try {
            for (Bucket bucket : this.influxConnection.getClient().getBucketsApi().findBuckets()) {
                Object[] objectArray = new String[]{bucket.getName().toString(), null};
                result.addRow(CollectionsKt.listOf((Object[])objectArray));
            }
        }
        catch (Throwable ex) {
            for (FluxTable fluxTable : this.influxConnection.getClient().getQueryApi().query("buckets()")) {
                for (FluxRecord fluxRecord : fluxTable.getRecords()) {
                    Object[] objectArray = new String[]{String.valueOf(fluxRecord.getValueByKey("name")), null};
                    result.addRow(CollectionsKt.listOf((Object[])objectArray));
                }
            }
        }
        return (ResultSet)result;
    }

    @NotNull
    public ResultSet getCatalogs() {
        ArrayResultSet result = new ArrayResultSet();
        String[] stringArray = new String[]{"TABLE_SCHEMA", "TABLE_CAT"};
        result.setColumnNames(CollectionsKt.listOf((Object[])stringArray));
        for (Organization organization : this.influxConnection.getClient().getOrganizationsApi().findOrganizations()) {
            result.addRow(CollectionsKt.listOf((Object)organization.getName().toString()));
        }
        return (ResultSet)result;
    }

    @NotNull
    public ResultSet getTables(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String[] types) {
        ArrayResultSet result = new ArrayResultSet();
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEMA", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
        result.setColumnNames(CollectionsKt.listOf((Object[])stringArray));
        result.setColumnNames(CollectionsKt.listOf((Object)"TABLE_CAT"));
        for (FluxTable fluxTable : this.influxConnection.getClient().getQueryApi().query("import \"influxdata/influxdb/schema\"\n\n  schema.measurements(bucket: \"" + schemaPattern + "\")")) {
            for (FluxRecord fluxRecord : fluxTable.getRecords()) {
                result.addRow(this.createTableRow(catalog, String.valueOf(fluxRecord.getValueByKey("_value")), null));
            }
        }
        return (ResultSet)result;
    }

    private final List<String> createTableRow(String catalogName, String tableName, String comment) {
        Object[] objectArray = new String[]{catalogName, "", tableName, "TABLE", comment, "", "", "", "", ""};
        List data = CollectionsKt.listOf((Object[])objectArray);
        return data;
    }

    @NotNull
    public ResultSet getColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String columnNamePattern) {
        ArrayResultSet result = new ArrayResultSet();
        Object[] objectArray = new String[]{"TABLE_CAT", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "OPTIONS"};
        result.setColumnNames(CollectionsKt.listOf((Object[])objectArray));
        String fluxQuery = StringsKt.trimIndent((String)("\n             import \"influxdata/influxdb/schema\"\n             schema.measurementFieldKeys(bucket: \"" + schemaPattern + "\", measurement: \"" + tableNamePattern + "\", start: " + this.influxConnection.getStartDays() + "d )\n             "));
        for (FluxTable columnNames : this.influxConnection.getClient().getQueryApi().query(fluxQuery)) {
            for (FluxRecord columnNamesRecord : columnNames.getRecords()) {
                String columnName = String.valueOf(columnNamesRecord.getValueByKey("_value"));
                if (StringsKt.startsWith$default((String)columnName, (String)"_", (boolean)false, (int)2, null)) continue;
                QueryApi queryApi = this.influxConnection.getClient().getQueryApi();
                Intrinsics.checkNotNullExpressionValue((Object)queryApi, (String)"getQueryApi(...)");
                String columnDataType = Companion.getColumnDataType(queryApi, schemaPattern, tableNamePattern, columnName);
                this.addColumn(catalog, tableNamePattern, result, columnName, columnDataType);
            }
        }
        String fluxQuery2 = "import \"influxdata/influxdb/schema\"\nschema.measurementTagKeys(bucket: \"" + schemaPattern + "\", measurement: \"" + tableNamePattern + "\" )";
        for (FluxTable columnNames : this.influxConnection.getClient().getQueryApi().query(fluxQuery2)) {
            for (FluxRecord columnNamesRecord : columnNames.getRecords()) {
                String columnName = String.valueOf(columnNamesRecord.getValueByKey("_value"));
                if (StringsKt.startsWith$default((String)columnName, (String)"_", (boolean)false, (int)2, null)) continue;
                this.addColumn(catalog, tableNamePattern, result, columnName, "string");
            }
        }
        return (ResultSet)result;
    }

    private final void addColumn(String catalogName, String tableName, ArrayResultSet result, String columnName, String columnDataType) {
        Object[] objectArray = new String[]{catalogName, null, tableName, columnName, "4", columnDataType, "800", "0", "0", "10", "0", "", "", "0", "0", "800", "1", "NO", null, null, null, null, "NO", null};
        result.addRow(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public ResultSet getPrimaryKeys(@Nullable String catalog, @Nullable String schema, @Nullable String table) {
        ArrayResultSet result = new ArrayResultSet();
        String fluxQuery2 = "import \"influxdata/influxdb/schema\"\nschema.measurementTagKeys(bucket: \"" + schema + "\", measurement: \"" + table + "\" )";
        int seq = 0;
        for (FluxTable columnNames : this.influxConnection.getClient().getQueryApi().query(fluxQuery2)) {
            for (FluxRecord columnNamesRecord : columnNames.getRecords()) {
                String columnName = String.valueOf(columnNamesRecord.getValueByKey("_value"));
                if (StringsKt.startsWith$default((String)columnName, (String)"_", (boolean)false, (int)2, null)) continue;
                Object[] objectArray = new String[]{catalog, schema, table, columnName, "" + ++seq, "PK_" + table};
                result.addRow(CollectionsKt.listOf((Object[])objectArray));
            }
        }
        return (ResultSet)result;
    }

    @NotNull
    public ResultSet getIndexInfo(@Nullable String catalog, @Nullable String schema, @Nullable String table, boolean unique, boolean approximate) throws SQLException {
        ArrayResultSet result = new ArrayResultSet();
        Object[] objectArray = new String[]{"TABLE_CAT", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        result.setColumnNames(CollectionsKt.listOf((Object[])objectArray));
        return (ResultSet)result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lcom/wisecoders/jdbc/influxdb/InfluxMetaData$Companion;", "", "<init>", "()V", "getColumnDataType", "", "queryApi", "Lcom/influxdb/client/QueryApi;", "schemaName", "measurement", "columnName", "jdbc-driver-influxdb"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getColumnDataType(@NotNull QueryApi queryApi, @Nullable String schemaName, @Nullable String measurement, @NotNull String columnName) {
            Intrinsics.checkNotNullParameter((Object)queryApi, (String)"queryApi");
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            String fluxToGetDataType = StringsKt.trimIndent((String)("\n                from(bucket: \"" + schemaName + "\") \n                |> range(start: -40d) \n                |> filter(fn: (r) => r._measurement == \"" + measurement + "\") \n                |> filter(fn: (r) => r._field == \"" + columnName + "\") \n                |> keep(columns: [\"_value\"]) \n                |> last() \n                \n                "));
            List list = queryApi.query(fluxToGetDataType);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query(...)");
            List tableList = list;
            if (tableList.size() > 0) {
                FluxTable columnTypeTable = (FluxTable)tableList.get(0);
                for (FluxColumn columnType : columnTypeTable.getColumns()) {
                    if (!Intrinsics.areEqual((Object)columnType.getLabel(), (Object)"_value")) continue;
                    return columnType.getDataType();
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

