/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.influxdb;

import com.influxdb.client.domain.Organization;
import com.influxdb.exceptions.NotFoundException;
import com.wisecoders.jdbc.common.ArrayResultSet;
import com.wisecoders.jdbc.common.sql.AbstractPreparedStatement;
import com.wisecoders.jdbc.influxdb.InfluxConnection;
import com.wisecoders.jdbc.influxdb.InfluxResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/wisecoders/jdbc/influxdb/InfluxPreparedStatement;", "Lcom/wisecoders/jdbc/common/sql/AbstractPreparedStatement;", "connection", "Lcom/wisecoders/jdbc/influxdb/InfluxConnection;", "query", "", "<init>", "(Lcom/wisecoders/jdbc/influxdb/InfluxConnection;Ljava/lang/String;)V", "executeQuery", "Ljava/sql/ResultSet;", "executeUpdate", "", "sql", "execute", "", "getResultSet", "Companion", "jdbc-driver-influxdb"})
@SourceDebugExtension(value={"SMAP\nInfluxPreparedStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InfluxPreparedStatement.kt\ncom/wisecoders/jdbc/influxdb/InfluxPreparedStatement\n+ 2 slf4jLogger.kt\ncom/wisecoders/common/slf4j/Slf4jLoggerKt\n*L\n1#1,85:1\n6#2,5:86\n*S KotlinDebug\n*F\n+ 1 InfluxPreparedStatement.kt\ncom/wisecoders/jdbc/influxdb/InfluxPreparedStatement\n*L\n82#1:86,5\n*E\n"})
public final class InfluxPreparedStatement
extends AbstractPreparedStatement {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final InfluxConnection connection;
    @NotNull
    private String query;
    @NotNull
    private static final Logger LOGGER;

    public InfluxPreparedStatement(@NotNull InfluxConnection connection, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)((Object)connection), (String)"connection");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        super(null, 1, null);
        this.connection = connection;
        this.query = query;
    }

    @NotNull
    public ResultSet executeQuery() throws SQLException {
        this.setRs(null);
        String string = ((Object)StringsKt.trim((CharSequence)this.query)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = string;
        if (new Regex("list\\s+organizations").matches(charSequence)) {
            LOGGER.atInfo().setMessage("List organizations").log();
            ArrayResultSet result = new ArrayResultSet();
            result.setColumnNames(CollectionsKt.listOf((Object)"ORGANIZATIONS"));
            try {
                for (Organization organization : this.connection.getClient().getOrganizationsApi().findOrganizations()) {
                    result.addRow(CollectionsKt.listOf((Object)organization.getName().toString()));
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            return (ResultSet)result;
        }
        List list = this.connection.getClient().getQueryApi().query(this.query);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query(...)");
        List queryResult = list;
        return (ResultSet)((Object)new InfluxResultSet(queryResult));
    }

    public int executeUpdate() throws SQLException {
        return 0;
    }

    @NotNull
    public ResultSet executeQuery(@NotNull String sql) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.query = sql;
        this.setRs(this.executeQuery());
        ResultSet resultSet = this.getRs();
        Intrinsics.checkNotNull((Object)resultSet);
        return resultSet;
    }

    public boolean execute(@NotNull String sql) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.query = sql;
        this.setRs(this.executeQuery());
        return true;
    }

    @NotNull
    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = this.getRs();
        Intrinsics.checkNotNull((Object)resultSet);
        return resultSet;
    }

    public int executeUpdate(@NotNull String sql) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.executeQuery();
        return 0;
    }

    public boolean execute() throws SQLException {
        this.setRs(this.executeQuery());
        return true;
    }

    static {
        Logger logger;
        Companion $this$slf4jLogger$iv = Companion = new Companion(null);
        boolean $i$f$slf4jLogger = false;
        if (Reflection.getOrCreateKotlinClass(Companion.class).isCompanion()) {
            Logger logger2 = LoggerFactory.getLogger(Companion.class.getEnclosingClass());
            Intrinsics.checkNotNull((Object)logger2);
            logger = logger2;
        } else {
            Logger logger3 = LoggerFactory.getLogger(Companion.class);
            Intrinsics.checkNotNull((Object)logger3);
            logger = logger3;
        }
        LOGGER = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/wisecoders/jdbc/influxdb/InfluxPreparedStatement$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "jdbc-driver-influxdb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

