/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.influxdb;

import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.wisecoders.jdbc.common.sql.AbstractResultSet;
import com.wisecoders.jdbc.influxdb.InfluxResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/wisecoders/jdbc/influxdb/InfluxResultSet;", "Lcom/wisecoders/jdbc/common/sql/AbstractResultSet;", "fluxTables", "", "Lcom/influxdb/query/FluxTable;", "<init>", "(Ljava/util/List;)V", "posTable", "", "posRecord", "fluxTable", "fluxRecord", "Lcom/influxdb/query/FluxRecord;", "resultSetMetaData", "Lcom/wisecoders/jdbc/influxdb/InfluxResultSetMetaData;", "next", "", "oneFluxRecord", "getOneFluxRecord", "()Lcom/influxdb/query/FluxRecord;", "getMetaData", "Ljava/sql/ResultSetMetaData;", "close", "", "wasNull", "getString", "", "columnIndex", "getBoolean", "getByte", "", "getShort", "", "getInt", "getLong", "", "getFloat", "", "getDouble", "", "jdbc-driver-influxdb"})
public final class InfluxResultSet
extends AbstractResultSet {
    @NotNull
    private final List<FluxTable> fluxTables;
    private int posTable;
    private int posRecord;
    @Nullable
    private FluxTable fluxTable;
    @Nullable
    private FluxRecord fluxRecord;
    @NotNull
    private final InfluxResultSetMetaData resultSetMetaData;

    public InfluxResultSet(@NotNull List<FluxTable> fluxTables) {
        Intrinsics.checkNotNullParameter(fluxTables, (String)"fluxTables");
        this.fluxTables = fluxTables;
        this.posTable = -1;
        this.posRecord = -1;
        this.resultSetMetaData = new InfluxResultSetMetaData(this);
    }

    public boolean next() throws SQLException {
        boolean doLoop = false;
        do {
            int n;
            if (this.fluxTable == null) {
                n = this.posTable;
                this.posTable = n + 1;
                if (this.posTable < this.fluxTables.size()) {
                    this.fluxTable = this.fluxTables.get(this.posTable);
                    this.posRecord = -1;
                } else {
                    return false;
                }
            }
            n = this.posRecord;
            this.posRecord = n + 1;
            FluxTable fluxTable = this.fluxTable;
            Intrinsics.checkNotNull((Object)fluxTable);
            if (this.posRecord >= fluxTable.getRecords().size()) {
                this.fluxTable = null;
                doLoop = true;
                continue;
            }
            doLoop = false;
        } while (doLoop);
        FluxTable fluxTable = this.fluxTable;
        Intrinsics.checkNotNull((Object)fluxTable);
        this.fluxRecord = (FluxRecord)fluxTable.getRecords().get(this.posRecord);
        return true;
    }

    @Nullable
    public final FluxRecord getOneFluxRecord() {
        if (this.fluxRecord != null) {
            return this.fluxRecord;
        }
        FluxTable fluxTable = this.fluxTable;
        if (fluxTable == null) {
            fluxTable = this.fluxTables.get(0);
        }
        return (FluxRecord)fluxTable.getRecords().get(0);
    }

    @NotNull
    public ResultSetMetaData getMetaData() {
        return (ResultSetMetaData)((Object)this.resultSetMetaData);
    }

    public void close() {
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    @NotNull
    public String getString(int columnIndex) throws SQLException {
        FluxRecord fluxRecord = this.fluxRecord;
        Intrinsics.checkNotNull((Object)fluxRecord);
        return "" + fluxRecord.getValues().get(this.resultSetMetaData.getColumnName(columnIndex));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public byte getByte(int columnIndex) throws SQLException {
        return 0;
    }

    public short getShort(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        return value instanceof Number ? ((Number)value).shortValue() : (short)-1;
    }

    public int getInt(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        return value instanceof Number ? ((Number)value).intValue() : -1;
    }

    public long getLong(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        return value instanceof Number ? ((Number)value).longValue() : -1L;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return 0.0f;
    }

    public double getDouble(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        return value instanceof Number ? ((Number)value).doubleValue() : -1.0;
    }
}

