/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.influxdb;

import com.influxdb.query.FluxRecord;
import com.wisecoders.jdbc.common.sql.AbstractResultSetMetaData;
import com.wisecoders.jdbc.influxdb.InfluxResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/wisecoders/jdbc/influxdb/InfluxResultSetMetaData;", "Lcom/wisecoders/jdbc/common/sql/AbstractResultSetMetaData;", "influxResultSet", "Lcom/wisecoders/jdbc/influxdb/InfluxResultSet;", "<init>", "(Lcom/wisecoders/jdbc/influxdb/InfluxResultSet;)V", "columnNames", "", "", "columnClasses", "", "Ljava/lang/Class;", "init", "", "getColumnCount", "", "getColumnName", "column", "getColumnType", "getColumnTypeName", "jdbc-driver-influxdb"})
public final class InfluxResultSetMetaData
extends AbstractResultSetMetaData {
    @NotNull
    private final InfluxResultSet influxResultSet;
    @NotNull
    private final List<String> columnNames;
    @NotNull
    private final Map<String, Class<?>> columnClasses;

    public InfluxResultSetMetaData(@NotNull InfluxResultSet influxResultSet) {
        Intrinsics.checkNotNullParameter((Object)((Object)influxResultSet), (String)"influxResultSet");
        this.influxResultSet = influxResultSet;
        this.columnNames = new ArrayList();
        this.columnClasses = new HashMap();
    }

    private final void init() {
        FluxRecord fluxRecord = this.influxResultSet.getOneFluxRecord();
        if (fluxRecord != null) {
            for (String columnName : fluxRecord.getValues().keySet()) {
                Object value;
                if (!this.columnNames.contains(columnName)) {
                    Intrinsics.checkNotNull((Object)columnName);
                    this.columnNames.add(columnName);
                }
                if (this.columnClasses.containsKey(columnName) || (value = fluxRecord.getValues().get(columnName)) == null) continue;
                this.columnClasses.put(columnName, value.getClass());
            }
        }
    }

    public int getColumnCount() throws SQLException {
        this.init();
        return this.columnNames.size();
    }

    @NotNull
    public String getColumnName(int column) throws SQLException {
        this.init();
        if (column < this.columnNames.size()) {
            return this.columnNames.get(column);
        }
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        if (column < this.columnNames.size()) {
            Class<?> clazz = this.columnClasses.get(this.columnNames.get(column));
            Intrinsics.checkNotNull(clazz);
            Class<?> cls = clazz;
            if (Intrinsics.areEqual(String.class, cls)) {
                return 12;
            }
            if (Intrinsics.areEqual(Double.TYPE, cls)) {
                return 8;
            }
            if (Intrinsics.areEqual(Integer.TYPE, cls)) {
                return 8;
            }
        }
        return 12;
    }

    @NotNull
    public String getColumnTypeName(int column) throws SQLException {
        if (column < this.columnClasses.size()) {
            String string;
            Class<?> cls;
            Class<?> clazz = cls = this.columnClasses.get(this.columnNames.get(column));
            if (clazz != null) {
                String string2 = clazz.getSimpleName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
            } else {
                string = "string";
            }
            return string;
        }
        return "string";
    }
}

