/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.influxdb;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.wisecoders.jdbc.influxdb.InfluxConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/wisecoders/jdbc/influxdb/JdbcDriver;", "Ljava/sql/Driver;", "<init>", "()V", "connect", "Ljava/sql/Connection;", "url", "", "info", "Ljava/util/Properties;", "acceptsURL", "", "getPropertyInfo", "", "Ljava/sql/DriverPropertyInfo;", "(Ljava/lang/String;Ljava/util/Properties;)[Ljava/sql/DriverPropertyInfo;", "getMajorVersion", "", "getMinorVersion", "jdbcCompliant", "getParentLogger", "Ljava/util/logging/Logger;", "Companion", "jdbc-driver-influxdb"})
@SourceDebugExtension(value={"SMAP\nJdbcDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDriver.kt\ncom/wisecoders/jdbc/influxdb/JdbcDriver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 slf4jLogger.kt\ncom/wisecoders/common/slf4j/Slf4jLoggerKt\n*L\n1#1,125:1\n1869#2:126\n1870#2:128\n1#3:127\n6#4,5:129\n*S KotlinDebug\n*F\n+ 1 JdbcDriver.kt\ncom/wisecoders/jdbc/influxdb/JdbcDriver\n*L\n38#1:126\n38#1:128\n116#1:129,5\n*E\n"})
public final class JdbcDriver
implements Driver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final String DAYS = "days";

    @Override
    @Nullable
    public Connection connect(@Nullable String url, @Nullable Properties info) throws SQLException {
        InfluxDBClient influxDBClient;
        int n;
        if (url == null || !this.acceptsURL(url)) {
            return null;
        }
        Properties properties = info;
        if (properties == null) {
            properties = new Properties();
        }
        Properties parameters = properties;
        String[] stringArray = new String[]{"&"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)StringsKt.substringAfter((String)url, (String)"?", (String)""), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            String pair = (String)element$iv;
            boolean bl = false;
            Object object2 = new String[]{"="};
            Object it = object2 = StringsKt.split$default((CharSequence)pair, (String[])object2, (boolean)false, (int)2, (int)2, null);
            boolean bl2 = false;
            if ((it.size() == 2 ? object2 : null) == null) continue;
            object = object;
            String key = (String)object.get(0);
            String value = (String)object.get(1);
            if (parameters.containsKey(key)) continue;
            ((Map)parameters).put(key, URLDecoder.decode(value, StandardCharsets.UTF_8));
            LOGGER.atInfo().setMessage("Param " + key + "=" + parameters.get(key)).log();
        }
        String userName = (String)parameters.get("user");
        String password = (String)parameters.get("password");
        String token = (String)parameters.get("token");
        String org = (String)parameters.get("org");
        String startDaysStr = (String)parameters.get(DAYS);
        LOGGER.atInfo().setMessage("Connection URL=" + url + " user=" + userName + " password=" + password + " org=" + org + " token=" + token + " days=" + startDaysStr).log();
        Object object = startDaysStr;
        if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            n = it > 0 ? -it : it;
        } else {
            n = -30;
        }
        int startDays = n;
        LOGGER.atInfo().setMessage("Use days=" + startDays).log();
        if (userName != null && password != null) {
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            influxDBClient = InfluxDBClientFactory.create((String)url, (String)userName, (char[])cArray);
        } else {
            String string = token;
            if (string != null) {
                char[] cArray = string.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                influxDBClient = InfluxDBClientFactory.create((String)url, (char[])cArray, (String)org);
            } else {
                influxDBClient = InfluxDBClientFactory.create((String)url);
            }
        }
        InfluxDBClient influxDBClient2 = influxDBClient;
        Intrinsics.checkNotNull((Object)influxDBClient2);
        InfluxDBClient client = influxDBClient2;
        return (Connection)((Object)new InfluxConnection(client, startDays));
    }

    @Override
    public boolean acceptsURL(@NotNull String url) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null);
    }

    @Override
    @Nullable
    public DriverPropertyInfo[] getPropertyInfo(@NotNull String url, @NotNull Properties info) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    @Nullable
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        Logger logger;
        Companion $this$slf4jLogger$iv = Companion = new Companion(null);
        boolean $i$f$slf4jLogger = false;
        if (Reflection.getOrCreateKotlinClass(Companion.class).isCompanion()) {
            Logger logger2 = LoggerFactory.getLogger(Companion.class.getEnclosingClass());
            Intrinsics.checkNotNull((Object)logger2);
            logger = logger2;
        } else {
            Logger logger3 = LoggerFactory.getLogger(Companion.class);
            Intrinsics.checkNotNull((Object)logger3);
            logger = logger3;
        }
        LOGGER = logger;
        DriverManager.registerDriver(new JdbcDriver());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/wisecoders/jdbc/influxdb/JdbcDriver$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "DAYS", "", "jdbc-driver-influxdb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

