/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.common.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007J$\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\f"}, d2={"Lcom/wisecoders/jdbc/common/sql/AWSUtil;", "", "<init>", "()V", "getSecretValue", "", "regionName", "secretName", "secretKey", "getValue", "secretsClient", "Lsoftware/amazon/awssdk/services/secretsmanager/SecretsManagerClient;", "driver-common"})
public final class AWSUtil {
    @NotNull
    public static final AWSUtil INSTANCE = new AWSUtil();

    private AWSUtil() {
    }

    @JvmStatic
    @Nullable
    public static final String getSecretValue(@NotNull String regionName, @Nullable String secretName, @Nullable String secretKey) {
        Intrinsics.checkNotNullParameter((Object)regionName, (String)"regionName");
        Region region = Region.of((String)regionName);
        SecretsManagerClient secretsClient = (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(region)).build();
        Intrinsics.checkNotNull((Object)secretsClient);
        return INSTANCE.getValue(secretsClient, secretName, secretKey);
    }

    @Nullable
    public final String getValue(@NotNull SecretsManagerClient secretsClient, @Nullable String secretName, @Nullable String secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretsClient, (String)"secretsClient");
        try {
            GetSecretValueRequest valueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
            GetSecretValueResponse valueResponse = secretsClient.getSecretValue(valueRequest);
            String secret = valueResponse.secretString();
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(secret, Map.class);
            secretsClient.close();
            Intrinsics.checkNotNull((Object)map);
            Object v = map.get(secretKey);
            return v instanceof String ? (String)v : null;
        }
        catch (SecretsManagerException e) {
            System.err.println(e.awsErrorDetails().errorMessage());
            throw e;
        }
        catch (JsonProcessingException e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

