/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.common.sql;

import com.wisecoders.jdbc.common.sql.AbstractResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0012\u0010\u001c\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\u0016\u0010!\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lcom/wisecoders/jdbc/common/sql/SimpleResultSet;", "Lcom/wisecoders/jdbc/common/sql/AbstractResultSet;", "columns", "", "", "rows", "", "", "<init>", "([Ljava/lang/String;Ljava/util/List;)V", "getColumns", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getRows", "()Ljava/util/List;", "cursor", "", "getCursor", "()I", "setCursor", "(I)V", "next", "", "labelToIndex", "columnLabel", "getString", "columnIndex", "getInt", "getBoolean", "getObject", "close", "", "wasNull", "isWrapperFor", "iface", "Ljava/lang/Class;", "getMetaData", "Ljava/sql/ResultSetMetaData;", "Meta", "driver-common"})
public final class SimpleResultSet
extends AbstractResultSet {
    @NotNull
    private final String[] columns;
    @NotNull
    private final List<Object[]> rows;
    private int cursor;

    public SimpleResultSet(@NotNull String[] columns, @NotNull List<Object[]> rows) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this.columns = columns;
        this.rows = rows;
        this.cursor = -1;
    }

    @NotNull
    public final String[] getColumns() {
        return this.columns;
    }

    @NotNull
    public final List<Object[]> getRows() {
        return this.rows;
    }

    public final int getCursor() {
        return this.cursor;
    }

    public final void setCursor(int n) {
        this.cursor = n;
    }

    @Override
    public boolean next() {
        ++this.cursor;
        return this.cursor < this.rows.size();
    }

    private final int labelToIndex(String columnLabel) {
        return ArraysKt.indexOf((Object[])this.columns, (Object)columnLabel) + 1;
    }

    @Override
    @NotNull
    public String getString(@Nullable String columnLabel) {
        return this.getObject(this.labelToIndex(columnLabel)).toString();
    }

    @Override
    @NotNull
    public String getString(int columnIndex) {
        return this.getObject(columnIndex).toString();
    }

    @Override
    public int getInt(@Nullable String columnLabel) {
        return this.getInt(this.labelToIndex(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) {
        Object value = this.getObject(columnIndex);
        if (!(value instanceof Number)) {
            return 0;
        }
        return ((Number)value).intValue();
    }

    @Override
    public boolean getBoolean(@Nullable String columnLabel) {
        return this.getBoolean(this.labelToIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        Object value = this.getObject(columnIndex);
        Boolean bl = value instanceof Boolean ? (Boolean)value : null;
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Object getObject(int columnIndex) {
        Object object;
        boolean bl = 0 <= columnIndex ? columnIndex <= this.columns.length : false;
        if (bl) {
            object = this.rows.get(this.cursor)[columnIndex - 1];
            if (object == null) {
                object = "";
            }
        } else {
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " out of bounds for columns size " + this.columns.length);
        }
        return object;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean wasNull() {
        return false;
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) {
        return false;
    }

    @Override
    @NotNull
    public ResultSetMetaData getMetaData() {
        return new Meta();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0016\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001fH\u0016J)\u0010 \u001a\u0002H!\"\n\b\u0000\u0010!*\u0004\u0018\u00010\"2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u0002H!\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Lcom/wisecoders/jdbc/common/sql/SimpleResultSet$Meta;", "Ljava/sql/ResultSetMetaData;", "<init>", "(Lcom/wisecoders/jdbc/common/sql/SimpleResultSet;)V", "getColumnCount", "", "getColumnName", "", "column", "getColumnType", "getColumnTypeName", "isNullable", "getColumnDisplaySize", "getColumnLabel", "getTableName", "getSchemaName", "getCatalogName", "getPrecision", "getScale", "isAutoIncrement", "", "isCaseSensitive", "isSearchable", "isCurrency", "isSigned", "isReadOnly", "isWritable", "isDefinitelyWritable", "getColumnClassName", "isWrapperFor", "iface", "Ljava/lang/Class;", "unwrap", "T", "", "(Ljava/lang/Class;)Ljava/lang/Object;", "driver-common"})
    public final class Meta
    implements ResultSetMetaData {
        @Override
        public int getColumnCount() {
            return SimpleResultSet.this.getColumns().length;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return SimpleResultSet.this.getColumns()[column - 1];
        }

        @Override
        public int getColumnType(int column) {
            return 12;
        }

        @Override
        @NotNull
        public String getColumnTypeName(int column) {
            return "VARCHAR";
        }

        @Override
        public int isNullable(int column) {
            return 1;
        }

        @Override
        public int getColumnDisplaySize(int column) {
            return 255;
        }

        @Override
        @NotNull
        public String getColumnLabel(int column) {
            return SimpleResultSet.this.getColumns()[column - 1];
        }

        @Override
        @NotNull
        public String getTableName(int column) {
            return "";
        }

        @Override
        @NotNull
        public String getSchemaName(int column) {
            return "";
        }

        @Override
        @NotNull
        public String getCatalogName(int column) {
            return "";
        }

        @Override
        public int getPrecision(int column) {
            return 0;
        }

        @Override
        public int getScale(int column) {
            return 0;
        }

        @Override
        public boolean isAutoIncrement(int column) {
            return false;
        }

        @Override
        public boolean isCaseSensitive(int column) {
            return true;
        }

        @Override
        public boolean isSearchable(int column) {
            return true;
        }

        @Override
        public boolean isCurrency(int column) {
            return false;
        }

        @Override
        public boolean isSigned(int column) {
            return false;
        }

        @Override
        public boolean isReadOnly(int column) {
            return true;
        }

        @Override
        public boolean isWritable(int column) {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) {
            return false;
        }

        @Override
        @NotNull
        public String getColumnClassName(int column) {
            String string = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        public boolean isWrapperFor(@Nullable Class<?> iface) {
            return false;
        }

        @Override
        public <T> T unwrap(@Nullable Class<T> iface) {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }
}

