/*
 * Decompiled with CFR 0.152.
 */
package com.wisecoders.jdbc.common.sql;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0001\u001a9\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u0002H\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u000e\u001a\u001c\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00110\u0010*\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u0013"}, d2={"md5", "", "parseProperties", "Ljava/util/Properties;", "setOrGrow", "", "T", "", "index", "", "value", "filler", "(Ljava/util/List;ILjava/lang/Object;Ljava/lang/Object;)V", "printResultSet", "Ljava/sql/ResultSet;", "parseOptions", "", "", "maskAllPasswords", "driver-common"})
@SourceDebugExtension(value={"SMAP\nSqlHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlHelper.kt\ncom/wisecoders/jdbc/common/sql/SqlHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,86:1\n1869#2:87\n1563#2:88\n1634#2,3:89\n1870#2:92\n774#2:93\n865#2,2:94\n1563#2:96\n1634#2,3:97\n1504#2:100\n1534#2,3:101\n1537#2,3:111\n382#3,7:104\n*S KotlinDebug\n*F\n+ 1 SqlHelper.kt\ncom/wisecoders/jdbc/common/sql/SqlHelperKt\n*L\n32#1:87\n33#1:88\n33#1:89,3\n32#1:92\n69#1:93\n69#1:94,2\n70#1:96\n70#1:97,3\n74#1:100\n74#1:101,3\n74#1:111,3\n74#1:104,7\n*E\n"})
public final class SqlHelperKt {
    @NotNull
    public static final String md5(@NotNull String $this$md5) {
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"<this>");
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hash = md.digest(byArray);
        StringBuilder sb = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String string2 = "%02x";
            Object[] objectArray = new Object[]{b & 0xFF};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            sb.append(string3);
        }
        String string4 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Properties parseProperties(@NotNull String $this$parseProperties) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$parseProperties, (String)"<this>");
        String withoutPrefix = StringsKt.removePrefix((String)$this$parseProperties, (CharSequence)"jdbc:");
        URI uri = new URI(withoutPrefix);
        String host = uri.getHost();
        String port = uri.getPort() != -1 ? ":" + uri.getPort() : "";
        String endpoint = "http://" + host + port;
        Properties props = new Properties();
        Object object = uri.getQuery();
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"&"}), (boolean)false, (int)0, (int)6, null)) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                String it = (String)element$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{"="};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(URLDecoder.decode((String)it2, "UTF-8"));
                }
                List list = (List)destination$iv$iv;
                String key = (String)list.get(0);
                String value = (String)list.get(1);
                props.setProperty(key, value);
            }
        }
        props.setProperty("endpoint", endpoint);
        return props;
    }

    public static final <T> void setOrGrow(@NotNull List<T> $this$setOrGrow, int index, T value, @Nullable T filler) {
        Intrinsics.checkNotNullParameter($this$setOrGrow, (String)"<this>");
        while ($this$setOrGrow.size() <= index) {
            $this$setOrGrow.add(filler);
        }
        $this$setOrGrow.set(index, value);
    }

    public static /* synthetic */ void setOrGrow$default(List list, int n, Object object, Object object2, int n2, Object object3) {
        if ((n2 & 4) != 0) {
            object2 = null;
        }
        SqlHelperKt.setOrGrow(list, n, object, object2);
    }

    public static final void printResultSet(@NotNull ResultSet $this$printResultSet) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$printResultSet, (String)"<this>");
        ResultSetMetaData metaData = $this$printResultSet.getMetaData();
        int i = 1;
        int n = metaData.getColumnCount();
        if (i <= n) {
            while (true) {
                objectArray = new Object[]{metaData.getColumnName(i) + "(" + metaData.getColumnType(i) + ")"};
                System.out.printf("%30s", objectArray);
                if (i == n) break;
                ++i;
            }
        }
        System.out.println();
        while ($this$printResultSet.next()) {
            i = 1;
            n = metaData.getColumnCount();
            if (i <= n) {
                while (true) {
                    objectArray = new Object[]{$this$printResultSet.getString(i)};
                    System.out.printf("%30s", objectArray);
                    if (i == n) break;
                    ++i;
                }
            }
            System.out.println();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<String>> parseOptions(@NotNull String $this$parseOptions) {
        void $this$groupByTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$parseOptions, (String)"<this>");
        String[] stringArray = new String[]{"&", ";"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)$this$parseOptions, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)it) && StringsKt.contains$default((CharSequence)it, (CharSequence)"=", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void part;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"="};
            List list = StringsKt.split$default((CharSequence)((CharSequence)part), (String[])stringArray2, (boolean)false, (int)2, (int)2, null);
            String key = (String)list.get(0);
            String value = (String)list.get(1);
            String string = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(TuplesKt.to((Object)string, (Object)value));
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it2;
            Object object;
            it = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-SqlHelperKt$parseOptions$52 = false;
            String key$iv$iv = (String)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-SqlHelperKt$parseOptions$52 = (Pair)element$iv$iv;
            collection = list$iv$iv;
            boolean bl = false;
            collection.add((String)it2.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final String maskAllPasswords(@NotNull String $this$maskAllPasswords) {
        Intrinsics.checkNotNullParameter((Object)$this$maskAllPasswords, (String)"<this>");
        Regex pattern = new Regex("(?i)(password=)([^&]*)");
        CharSequence charSequence = $this$maskAllPasswords;
        Function1 function1 = SqlHelperKt::maskAllPasswords$lambda$6;
        return pattern.replace(charSequence, function1);
    }

    private static final CharSequence maskAllPasswords$lambda$6(MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String prefix = (String)match.getGroupValues().get(1);
        String password = (String)match.getGroupValues().get(2);
        return prefix + StringsKt.repeat((CharSequence)"*", (int)password.length());
    }
}

