/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing;

import com.amazon.athena.client.results.parsing.ResultRowsParser;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;

public class LineParser
implements ResultRowsParser {
    private final Deque<byte[]> currentLineChunks = new LinkedList<byte[]>();
    private int currentLineLength = 0;

    @Override
    public int parse(ByteBuffer chunk, Consumer<String[]> onRow) throws ParseException {
        int rowCount = 0;
        chunk.mark();
        while (chunk.hasRemaining()) {
            if (chunk.get() != 10) continue;
            this.pushSliceFromMark(chunk);
            ++rowCount;
            onRow.accept(new String[]{this.materializeCurrentLine(false)});
            chunk.mark();
        }
        this.pushSliceFromMark(chunk);
        return rowCount;
    }

    @Override
    public int finish(Consumer<String[]> onRow) throws ParseException {
        if (this.currentLineLength > 0) {
            onRow.accept(new String[]{this.materializeCurrentLine(true)});
            return 1;
        }
        return 0;
    }

    private void pushSliceFromMark(ByteBuffer chunk) {
        int endPosition = chunk.position();
        chunk.reset();
        if (endPosition > chunk.position()) {
            byte[] line = new byte[endPosition - chunk.position()];
            chunk.get(line);
            chunk.position(endPosition);
            this.currentLineChunks.add(line);
            this.currentLineLength += line.length;
        }
    }

    private String materializeCurrentLine(boolean isTrailing) {
        int lineLength = this.currentLineLength;
        ByteBuffer buffer = ByteBuffer.allocate(lineLength);
        for (byte[] lineChunk : this.currentLineChunks) {
            int length = lineChunk.length;
            if (lineChunk == this.currentLineChunks.peekLast() && !isTrailing) {
                --length;
            }
            buffer.put(lineChunk, 0, length);
        }
        this.currentLineChunks.clear();
        this.currentLineLength = 0;
        buffer.flip();
        return StandardCharsets.UTF_8.decode(buffer).toString();
    }
}

