/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.client.results.parsing.metadata;

import com.amazon.athena.client.error.QueryResultException;
import com.amazon.athena.client.results.AthenaMetadataParser;
import com.amazon.athena.client.results.S3UriHelper;
import com.amazon.athena.client.results.parsing.metadata.MetadataFetcher;
import com.amazon.athena.logging.AthenaLogger;
import java.text.ParseException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Pair;

public class S3MetadataFetcher
implements MetadataFetcher {
    private static final AthenaLogger logger = AthenaLogger.of(S3MetadataFetcher.class);
    private final S3AsyncClient s3Client;
    private final QueryExecution queryMetadata;
    private final boolean parseContents;
    private final AthenaMetadataParser metadataParser;

    public S3MetadataFetcher(S3AsyncClient s3Client, QueryExecution queryMetadata, boolean parseContents) {
        this.s3Client = s3Client;
        this.queryMetadata = queryMetadata;
        this.parseContents = parseContents;
        this.metadataParser = new AthenaMetadataParser();
    }

    public static MetadataFetcher createAccessValidatingS3MetadataFetcher(S3AsyncClient s3Client, QueryExecution queryMetadata, MetadataFetcher wrappedFetcher) {
        S3MetadataFetcher accessValidatingFetcher = new S3MetadataFetcher(s3Client, queryMetadata, false);
        CompletableFuture<GetQueryResultsResponse> accessCheck = accessValidatingFetcher.fetchMetadata();
        CompletableFuture<GetQueryResultsResponse> actualMetadata = wrappedFetcher.fetchMetadata();
        return () -> ((CompletableFuture)accessCheck.handle((result, error) -> {
            if (error == null || S3MetadataFetcher.isNoSuchKeyError(error)) {
                return null;
            }
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new CompletionException((Throwable)error);
        })).thenCompose(ignored -> actualMetadata);
    }

    private static boolean isNoSuchKeyError(Throwable error) {
        for (Throwable t = error; t != null; t = t.getCause()) {
            if (!(t instanceof S3Exception)) continue;
            return ((S3Exception)t).statusCode() == 404;
        }
        return false;
    }

    @Override
    public CompletableFuture<GetQueryResultsResponse> fetchMetadata() {
        String outputLocation = this.queryMetadata.resultConfiguration().outputLocation();
        Optional<Pair<String, String>> bucketAndKey = S3UriHelper.toBucketAndKey(outputLocation);
        if (bucketAndKey.isPresent()) {
            Pair<String, String> pair = bucketAndKey.get();
            String bucket = pair.left();
            String metadataKey = pair.right() + ".metadata";
            logger.debug("Query execution {} loading metadata from \"s3://{}/{}\"", this.queryMetadata.queryExecutionId(), bucket, metadataKey);
            return this.loadResultMetadata(this.queryMetadata, bucket, metadataKey);
        }
        logger.warn("Query execution {} failed loading query result metadata, got an invalid output location: \"{}\"", this.queryMetadata.queryExecutionId(), outputLocation);
        return CompletableFutureUtils.failedFuture(new QueryResultException(this.queryMetadata, String.format("Invalid output location: \"%s\"", outputLocation)));
    }

    private CompletableFuture<GetQueryResultsResponse> loadResultMetadata(QueryExecution queryMetadata, String bucket, String metadataKey) {
        GetObjectRequest metadataRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(metadataKey).build();
        return ((CompletableFuture)this.s3Client.getObject(metadataRequest, AsyncResponseTransformer.toBytes()).exceptionally(e -> {
            logger.warn(String.format("Query execution %s failed loading query result metadata from \"s3://%s/%s\": %s", queryMetadata.queryExecutionId(), bucket, metadataKey, e.getMessage()), (Throwable)e);
            throw new CompletionException(new QueryResultException(queryMetadata, String.format("Could not load query result metadata from \"s3://%s/%s\": %s", bucket, metadataKey, e.getMessage()), (Throwable)e));
        })).thenApply(metadataResponse -> {
            try {
                logger.info("Query execution {} loaded query result metadata from \"s3://{}/{}\"", queryMetadata.queryExecutionId(), bucket, metadataKey);
                if (this.parseContents) {
                    GetQueryResultsResponse metadata = this.metadataParser.parse(metadataResponse.asByteBuffer());
                    logger.trace("Query execution {} loaded query result metadata: {}", queryMetadata.queryExecutionId(), metadata);
                    return metadata;
                }
                logger.trace("Query execution {} loaded query result metadata (parsing skipped, access check only)", queryMetadata.queryExecutionId());
                return null;
            }
            catch (ParseException e) {
                logger.warn("Query execution {} failed parsing metadata from \"s3://{}/{}\": {}", queryMetadata.queryExecutionId(), bucket, metadataKey, e.getMessage(), e);
                throw new CompletionException(e);
            }
        });
    }
}

