/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AthenaDataType {
    TINYINT("tinyint", -6, 1, Integer.class),
    SMALLINT("smallint", 5, 2, Integer.class),
    INT("int", 4, 4, Integer.class),
    INTEGER("integer", 4, 4, Integer.class),
    BIGINT("bigint", -5, 8, Long.class),
    FLOAT("float", 6, 4, Float.class),
    REAL("real", 6, 4, Float.class),
    DOUBLE("double", 8, 8, Double.class),
    DECIMAL("decimal", 3, 38, BigDecimal.class),
    BOOLEAN("boolean", 16, 1, Boolean.class),
    CHAR("char", 1, 255, String.class),
    STRING("string", 12, 65535, String.class),
    VARCHAR("varchar", 12, 65535, String.class),
    JSON("json", 12, 65535, String.class),
    INTERVAL_DAY_TO_SECOND("interval day to second", 12, -1, String.class),
    INTERVAL_YEAR_TO_MONTH("interval year to month", 12, -1, String.class),
    BINARY("binary", -2, 65535, byte[].class),
    VARBINARY("varbinary", -3, 65535, byte[].class),
    DATE("date", 91, 10, Date.class),
    TIME("time", 92, 12, Time.class),
    TIME_WITH_TIME_ZONE("time with time zone", 2013, -1, Time.class),
    TIMESTAMP("timestamp", 93, 23, Timestamp.class),
    TIMESTAMP_WITH_TIME_ZONE("timestamp with time zone", 2014, -1, Timestamp.class),
    ARRAY("array", 2003, -1, Array.class),
    MAP("map", 1111, -1, Object.class),
    ROW("row", 2002, -1, Struct.class),
    STRUCT("struct", 2002, -1, Struct.class),
    UNKNOWN(null, 1111, -1, Object.class);

    private static final Map<String, AthenaDataType> reverseLookup;
    private final String name;
    private final int jdbcType;
    private final int maxSize;
    private final Class<?> javaClass;

    public static AthenaDataType of(String typeName) {
        return reverseLookup.getOrDefault(typeName, UNKNOWN);
    }

    private AthenaDataType(String name, int jdbcType, int maxSize, Class<?> javaClass) {
        this.name = name;
        this.jdbcType = jdbcType;
        this.maxSize = maxSize;
        this.javaClass = javaClass;
    }

    public String athenaName() {
        return this.name;
    }

    public int jdbcType() {
        return this.jdbcType;
    }

    public int maxSizeInBytes() {
        return this.maxSize;
    }

    public Class<?> javaClass() {
        return this.javaClass;
    }

    public boolean isResultType() {
        switch (this) {
            case JSON: 
            case REAL: 
            case ROW: 
            case TIME: 
            case INTERVAL_DAY_TO_SECOND: 
            case INTERVAL_YEAR_TO_MONTH: 
            case TIME_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case UNKNOWN: {
                return false;
            }
        }
        return true;
    }

    static {
        reverseLookup = Arrays.stream(AthenaDataType.values()).collect(Collectors.toMap(AthenaDataType::athenaName, Function.identity()));
    }
}

