/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc;

import com.amazon.athena.client.AsyncAthena;
import com.amazon.athena.client.AsyncQueryExecution;
import com.amazon.athena.client.error.QueryExecutionException;
import com.amazon.athena.client.error.QueryExecutionTimedOutException;
import com.amazon.athena.client.results.AsyncQueryResults;
import com.amazon.athena.jdbc.AthenaConnection;
import com.amazon.athena.jdbc.AthenaQueryExecution;
import com.amazon.athena.jdbc.AthenaResultSet;
import com.amazon.athena.jdbc.support.AutoUnwrap;
import com.amazon.athena.jdbc.support.sql.EscapeProcessor;
import com.amazon.athena.logging.AthenaLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ParseException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutionException;

abstract class AthenaStatementBase
implements Statement,
AthenaQueryExecution,
AutoUnwrap {
    private static final AthenaLogger logger = AthenaLogger.of(AthenaStatementBase.class);
    private final AthenaConnection connection;
    private final AsyncAthena athenaClient;
    private final Object stateLock;
    private StatementState statementState;
    private AsyncQueryExecution queryExecution;
    private int queryTimeout;
    private int fetchSize;
    private int maxFieldSize;
    private int maxRows;
    private boolean poolable;
    private boolean closeOnCompletion;
    private boolean escapeProcessingEnabled;
    protected AthenaResultSet resultSet;

    AthenaStatementBase(AthenaConnection connection) {
        this.connection = connection;
        this.athenaClient = connection.getConfiguration().getAthenaClient();
        this.stateLock = new Object();
        this.statementState = StatementState.NEW;
        this.queryExecution = null;
        this.resultSet = null;
        this.queryTimeout = 0;
        this.fetchSize = connection.getConfiguration().getFetchSize();
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.poolable = false;
        this.closeOnCompletion = false;
        this.escapeProcessingEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInState(StatementState queryState) {
        Object object = this.stateLock;
        synchronized (object) {
            return this.statementState == queryState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setStateWhenInState(StatementState newState, StatementState expectedState) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.statementState == expectedState) {
                this.statementState = newState;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setStateIfNotInState(StatementState newState) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.statementState != newState) {
                this.statementState = newState;
                return true;
            }
            return false;
        }
    }

    protected void ensureOpen() throws SQLException {
        if (this.isInState(StatementState.CLOSED)) {
            throw new SQLException("Statement is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.queryExecution = null;
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultSetClosed(AthenaResultSet closedResultSet) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (closedResultSet == this.resultSet && this.closeOnCompletion) {
                this.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AthenaResultSet runQuery(String sql, List<String> parameters) throws SQLException {
        Object unescapedSql;
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.isInState(StatementState.EXECUTING)) {
                throw new SQLException("Statements cannot execute queries concurrently");
            }
            this.reset();
            this.ensureOpen();
            try {
                unescapedSql = this.escapeProcessingEnabled ? EscapeProcessor.unescape(sql) : sql;
            }
            catch (ParseException e) {
                throw new SQLException(String.format("Escape syntax processing failed at character %d: %s", e.getErrorOffset(), e.getMessage()), e);
            }
            this.queryExecution = this.athenaClient.execute((String)unescapedSql, parameters, this.getQueryTimeoutAsDuration());
            this.setStateIfNotInState(StatementState.EXECUTING);
        }
        logger.info("Query {} is executing", this.getQueryExecutionId());
        try {
            AthenaResultSet queryResult = new AthenaResultSet(this, (AsyncQueryResults)this.queryExecution.get(), this.maxRows, this.maxFieldSize, this.fetchSize);
            logger.info("Query {} successfully completed", this.getQueryExecutionId());
            unescapedSql = queryResult;
            return unescapedSql;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            Throwable ee = null;
            int errorCode = 0;
            if (c instanceof QueryExecutionException) {
                QueryExecutionException qee = (QueryExecutionException)c;
                errorCode = qee.athenaErrorType().orElse(0);
                if (c instanceof QueryExecutionTimedOutException) {
                    ee = new SQLTimeoutException(c.getMessage(), null, errorCode, c);
                }
            }
            if (ee == null) {
                ee = new SQLException(String.format("Query execution failed: %s", c.getMessage()), null, errorCode, c);
            }
            ee.addSuppressed(e);
            logger.warn(String.format("Query %s failed", this.getQueryExecutionId()), ee);
            throw ee;
        }
        finally {
            this.setStateWhenInState(StatementState.COMPLETED, StatementState.EXECUTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQueryExecutionId() throws SQLException {
        AsyncQueryExecution localQueryExecution = null;
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.queryExecution != null) {
                localQueryExecution = this.queryExecution;
            }
        }
        if (localQueryExecution == null) {
            return null;
        }
        try {
            return localQueryExecution.queryExecutionId().toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            SQLException ee = new SQLException(String.format("Could not get query execution ID: %s", c.getMessage()), c);
            ee.addSuppressed(e);
            throw ee;
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean cancelIfExecuting) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (cancelIfExecuting && this.isInState(StatementState.EXECUTING)) {
                this.cancel();
            }
            if (this.setStateIfNotInState(StatementState.CLOSED)) {
                this.reset();
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureOpen();
        if (max < 0) {
            throw new IllegalArgumentException(String.format("Invalid max field size: %d (expected a non-negative integer)", max));
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureOpen();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.ensureOpen();
        if (max < 0) {
            throw new IllegalArgumentException(String.format("Invalid max rows: %d (expected a non-negative integer)", max));
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    protected Duration getQueryTimeoutAsDuration() {
        if (this.queryTimeout == 0) {
            return ChronoUnit.FOREVER.getDuration();
        }
        return Duration.ofSeconds(this.queryTimeout);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new IllegalArgumentException(String.format("Invalid query timeout: %d (expected a non-negative integer)", seconds));
        }
        this.queryTimeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.ensureOpen();
            if (this.setStateWhenInState(StatementState.CANCELLED, StatementState.EXECUTING)) {
                this.queryExecution.cancel(false);
            } else if (this.isInState(StatementState.NEW)) {
                throw new SQLException("Cannot cancel a statement before it is executed");
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Named cursors are not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.ensureOpen();
        return this.resultSet != null && this.resultSet.hasUpdateCount() ? this.resultSet.updateCount() : -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureOpen();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Fetch is only supported in the forward direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new IllegalArgumentException(String.format("Invalid fetch size: %d (expected a positive integer)", rows));
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Batches are not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batches are not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batches are not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureOpen();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.ensureOpen();
        if (this.resultSet != null) {
            if (current == 1 || current == 3) {
                this.resultSet.close();
            }
            this.resultSet = null;
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isInState(StatementState.CLOSED);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureOpen();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureOpen();
        return this.poolable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOnCompletion() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.closeOnCompletion = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            return this.closeOnCompletion;
        }
    }

    protected static enum StatementState {
        NEW,
        EXECUTING,
        COMPLETED,
        CANCELLED,
        CLOSED;

    }
}

