/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.AzureAdCredentialsProvider;
import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class AzureAdCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final ConnectionParameter<String> AZURE_AD_TENANT_ID = ConnectionParameter.builder().name("AzureAdTenantId").deprecatedAlias("tenant_id").build();
    public static final ConnectionParameter<String> AZURE_AD_CLIENT_ID = ConnectionParameter.builder().name("AzureAdClientId").deprecatedAlias("client_id").build();
    public static final ConnectionParameter<String> AZURE_AD_CLIENT_SECRET = ConnectionParameter.builder().name("AzureAdClientSecret").deprecatedAlias("client_secret").isSecret(true).build();
    private final AzureAdCredentialsProvider.Builder credentialsProviderBuilder;

    public AzureAdCredentialsProviderFactory() {
        this.credentialsProviderBuilder = AzureAdCredentialsProvider.builder();
    }

    AzureAdCredentialsProviderFactory(AzureAdCredentialsProvider.Builder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    @Override
    public String name() {
        return "AzureAD";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        Optional<String> username = ConnectionParameters.USER_PARAMETER.findValue(parameters);
        Optional<String> password = ConnectionParameters.PASSWORD_PARAMETER.findValue(parameters);
        Optional<String> tenantId = AZURE_AD_TENANT_ID.findValue(parameters);
        Optional<String> clientId = AZURE_AD_CLIENT_ID.findValue(parameters);
        Optional<String> clientSecret = AZURE_AD_CLIENT_SECRET.findValue(parameters);
        Optional<String> preferredRole = ConnectionParameters.PREFERRED_ROLE_PARAMETER.findValue(parameters);
        Optional<Integer> roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters);
        Optional<Region> region = ConnectionParameters.REGION_PARAMETER.findValue(parameters);
        Optional<Boolean> lakeFormationEnabled = ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.findValue(parameters);
        ArrayList<String> errors = new ArrayList<String>();
        if (!username.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.USER_PARAMETER.name(), this.name()));
        }
        if (!password.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.PASSWORD_PARAMETER.name(), this.name()));
        }
        if (!tenantId.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", AZURE_AD_TENANT_ID.name(), this.name()));
        }
        if (!clientId.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", AZURE_AD_CLIENT_ID.name(), this.name()));
        }
        if (!clientSecret.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", AZURE_AD_CLIENT_SECRET.name(), this.name()));
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            throw new IllegalArgumentException(errorMessage);
        }
        return this.credentialsProviderBuilder.username(username.get()).password(password.get()).tenantId(tenantId.get()).clientId(clientId.get()).clientSecret(clientSecret.get()).preferredRole(preferredRole.orElse(null)).roleSessionDuration(roleSessionDuration.orElse(null)).region(region.get()).lakeFormationEnabled(lakeFormationEnabled.get()).connectionParameters(parameters).build();
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER, ConnectionParameters.PASSWORD_PARAMETER, ConnectionParameters.PREFERRED_ROLE_PARAMETER, ConnectionParameters.REGION_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.USER_PARAMETER, AZURE_AD_CLIENT_ID, AZURE_AD_CLIENT_SECRET, AZURE_AD_TENANT_ID);
    }
}

