/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.authentication;

import com.amazon.athena.jdbc.authentication.CredentialsProviderFactory;
import com.amazon.athena.jdbc.authentication.PingCredentialsProvider;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class PingCredentialsProviderFactory
implements CredentialsProviderFactory {
    public static final ConnectionParameter<String> PING_PARTNER_SPID = ConnectionParameter.builder().name("PingPartnerSpId").deprecatedAlias("Partner_SPID").build();
    private final PingCredentialsProvider.Builder credentialsProviderBuilder;

    public PingCredentialsProviderFactory() {
        this.credentialsProviderBuilder = PingCredentialsProvider.builder();
    }

    PingCredentialsProviderFactory(PingCredentialsProvider.Builder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    @Override
    public String name() {
        return "Ping";
    }

    @Override
    public AwsCredentialsProvider create(Map<ConnectionParameter<?>, String> parameters) {
        Optional<String> username = ConnectionParameters.USER_PARAMETER.findValue(parameters);
        Optional<String> password = ConnectionParameters.PASSWORD_PARAMETER.findValue(parameters);
        Optional<String> hostName = ConnectionParameters.IDP_HOST_NAME.findValue(parameters);
        Optional<Integer> portNumber = ConnectionParameters.IDP_PORT_NUMBER.findValue(parameters);
        Optional<String> partnerSpId = PING_PARTNER_SPID.findValue(parameters);
        Optional<String> preferredRole = ConnectionParameters.PREFERRED_ROLE_PARAMETER.findValue(parameters);
        Optional<Integer> roleSessionDuration = ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER.findValue(parameters);
        Optional<Region> region = ConnectionParameters.REGION_PARAMETER.findValue(parameters);
        Optional<Boolean> lakeFormationEnabled = ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER.findValue(parameters);
        ArrayList<String> errors = new ArrayList<String>();
        if (!username.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.USER_PARAMETER.name(), this.name()));
        }
        if (!password.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.PASSWORD_PARAMETER.name(), this.name()));
        }
        if (!hostName.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.IDP_HOST_NAME.name(), this.name()));
        }
        if (!portNumber.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", ConnectionParameters.IDP_PORT_NUMBER.name(), this.name()));
        }
        if (!partnerSpId.isPresent()) {
            errors.add(String.format("The %s parameter must be specified when using the %s credentials provider", PING_PARTNER_SPID.name(), this.name()));
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            throw new IllegalArgumentException(errorMessage);
        }
        return this.credentialsProviderBuilder.username(username.get()).password(password.get()).hostName(hostName.get()).portNumber((int)portNumber.get()).partnerSpId(partnerSpId.get()).preferredRole(preferredRole.orElse(null)).roleSessionDuration(roleSessionDuration.orElse(null)).region(region.get()).lakeFormationEnabled(lakeFormationEnabled.get()).connectionParameters(parameters).build();
    }

    @Override
    public Collection<ConnectionParameter<?>> connectionParameters() {
        return Arrays.asList(ConnectionParameters.IDP_HOST_NAME, ConnectionParameters.IDP_PORT_NUMBER, ConnectionParameters.LAKE_FORMATION_ENABLED_PARAMETER, ConnectionParameters.PASSWORD_PARAMETER, ConnectionParameters.PREFERRED_ROLE_PARAMETER, ConnectionParameters.REGION_PARAMETER, ConnectionParameters.ROLE_SESSION_DURATION_PARAMETER, ConnectionParameters.USER_PARAMETER, PING_PARTNER_SPID);
    }
}

