/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.configuration;

import com.amazon.athena.client.AsyncAthena;
import com.amazon.athena.client.polling.BackoffPollingStrategy;
import com.amazon.athena.client.polling.PollingStrategy;
import com.amazon.athena.client.results.AsyncQueryResultsFactory;
import com.amazon.athena.client.results.AutoQueryResultsFactory;
import com.amazon.athena.client.results.GetQueryResultsQueryResultsFactory;
import com.amazon.athena.client.results.GetQueryResultsStreamQueryResultsFactory;
import com.amazon.athena.client.results.ResultParserFactory;
import com.amazon.athena.client.results.S3StreamingQueryResultsFactory;
import com.amazon.athena.jdbc.authentication.CredentialsProviderRegistry;
import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import com.amazon.athena.jdbc.support.DriverVersion;
import com.amazon.athena.jdbc.support.EndpointHelper;
import com.amazon.athena.jdbc.support.ProxyHelper;
import com.amazon.athena.logging.AthenaFileAppender;
import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.event.Level;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.AthenaAsyncClientBuilder;
import software.amazon.awssdk.services.athena.model.AclConfiguration;
import software.amazon.awssdk.services.athena.model.EncryptionConfiguration;
import software.amazon.awssdk.services.athena.model.EncryptionOption;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingAsyncClient;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingAsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

public class ConnectionConfiguration
implements AutoCloseable {
    private static final AthenaLogger logger = AthenaLogger.of(ConnectionConfiguration.class);
    public static final Duration PRACTICALLY_INFINITE_DURATION = Duration.ofMillis(Long.MAX_VALUE);
    private static final int HTTPS_PORT = 443;
    private static final int STREAMING_PORT = 444;
    private static final String STREAMING_API_URI_TEMPLATE = "https://athena.%s.amazonaws.com:444";
    private static final int DEFAULT_STREAMING_PAGE_SIZE = 10000;
    private static final String AUTO_FETCHER = "auto";
    private static final String S3_FETCHER = "S3";
    private static final String GET_QUERY_RESULTS_FETCHER = "GetQueryResults";
    private static final String GET_QUERY_RESULTS_STREAM_FETCHER = "GetQueryResultsStream";
    private final Map<ConnectionParameter<?>, String> parameters;
    private final CredentialsProviderRegistry credentialsProviderRegistry;
    private final Supplier<AsyncAthena.AsyncAthenaBuilder> athenaClientBuilderFactory;
    private final Supplier<AthenaAsyncClientBuilder> athenaSdkClientBuilderFactory;
    private final Supplier<S3AsyncClientBuilder> s3SdkClientBuilderFactory;
    private final Supplier<AthenaStreamingAsyncClientBuilder> athenaStreamingClientBuilderFactory;
    private final Supplier<NettyNioAsyncHttpClient.Builder> asyncHttpClientBuilderFactory;
    private final Supplier<AthenaFileAppender> loggingCaptureFactory;
    private final Supplier<ClientAsyncConfiguration.Builder> clientAsyncConfigurationBuilderFactory;
    private final Executor executor;
    private AsyncAthena athenaClient;
    private AthenaAsyncClient athenaSdkClient;
    private S3AsyncClient s3SdkClient;
    private AthenaStreamingAsyncClient athenaStreamingClient;
    private Duration apiRequestTimeout;
    private AwsCredentialsProvider awsCredentialsProvider;
    private String applicationNameOverride;
    private AthenaFileAppender loggingCapture;

    private ConnectionConfiguration(Map<ConnectionParameter<?>, String> parameters, CredentialsProviderRegistry credentialsProviderRegistry, Supplier<AsyncAthena.AsyncAthenaBuilder> athenaClientBuilderFactory, Supplier<AthenaAsyncClientBuilder> athenaSdkClientBuilderFactory, Supplier<S3AsyncClientBuilder> s3SdkClientBuilderFactory, Supplier<AthenaStreamingAsyncClientBuilder> athenaStreamingClientBuilderFactory, Supplier<ClientAsyncConfiguration.Builder> clientAsyncConfigurationBuilderFactory, Supplier<NettyNioAsyncHttpClient.Builder> asyncHttpClientBuilderFactory, Supplier<AthenaFileAppender> loggingCaptureFactory) {
        this.parameters = parameters;
        this.credentialsProviderRegistry = credentialsProviderRegistry;
        this.athenaClientBuilderFactory = athenaClientBuilderFactory;
        this.athenaSdkClientBuilderFactory = athenaSdkClientBuilderFactory;
        this.s3SdkClientBuilderFactory = s3SdkClientBuilderFactory;
        this.athenaStreamingClientBuilderFactory = athenaStreamingClientBuilderFactory;
        this.clientAsyncConfigurationBuilderFactory = clientAsyncConfigurationBuilderFactory;
        this.asyncHttpClientBuilderFactory = asyncHttpClientBuilderFactory;
        this.loggingCaptureFactory = loggingCaptureFactory;
        this.athenaClient = null;
        this.athenaSdkClient = null;
        this.awsCredentialsProvider = null;
        this.apiRequestTimeout = ConnectionParameters.NETWORK_TIMEOUT_MILLIS.findValue(parameters).orElse(PRACTICALLY_INFINITE_DURATION);
        this.executor = ConnectionConfiguration.createExecutor();
    }

    public static ConnectionConfiguration from(Map<ConnectionParameter<?>, String> parameters, CredentialsProviderRegistry credentialsProviderRegistry) {
        return ConnectionConfiguration.from(parameters, credentialsProviderRegistry, AsyncAthena::builder, AthenaAsyncClient::builder, S3AsyncClient::builder, AthenaStreamingAsyncClient::builder, ClientAsyncConfiguration::builder, NettyNioAsyncHttpClient::builder, AthenaLogger::createAppender);
    }

    static ConnectionConfiguration from(Map<ConnectionParameter<?>, String> parameters, CredentialsProviderRegistry credentialsProviderRegistry, Supplier<AsyncAthena.AsyncAthenaBuilder> athenaClientBuilderFactory, Supplier<AthenaAsyncClientBuilder> athenaSdkClientBuilderFactory, Supplier<S3AsyncClientBuilder> s3SdkClientBuilderFactory, Supplier<AthenaStreamingAsyncClientBuilder> athenaStreamingClientBuilderFactory, Supplier<ClientAsyncConfiguration.Builder> clientAsyncConfigurationFactory, Supplier<NettyNioAsyncHttpClient.Builder> asyncHttpClientBuilderFactory, Supplier<AthenaFileAppender> loggingCaptureFactory) {
        return new ConnectionConfiguration(parameters, credentialsProviderRegistry, athenaClientBuilderFactory, athenaSdkClientBuilderFactory, s3SdkClientBuilderFactory, athenaStreamingClientBuilderFactory, clientAsyncConfigurationFactory, asyncHttpClientBuilderFactory, loggingCaptureFactory).validate().logConnectionParameters();
    }

    private static ThreadPoolExecutor createExecutor() {
        int processors = Runtime.getRuntime().availableProcessors();
        int corePoolSize = Math.max(8, processors);
        int maxPoolSize = Math.max(64, processors * 2);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().threadNamePrefix("athena-jdbc").build());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private String getCredentialsProviderName() {
        Optional<String> name = ConnectionParameters.CREDENTIALS_PROVIDER_PARAMETER.findValue(this.parameters);
        if (name.isPresent()) {
            return name.flatMap(this.credentialsProviderRegistry::normalizeName).orElse("Custom");
        }
        Optional<String> accessKeyId = ConnectionParameters.USER_PARAMETER.findValue(this.parameters);
        Optional<String> secretAccessKey = ConnectionParameters.PASSWORD_PARAMETER.findValue(this.parameters);
        if (accessKeyId.isPresent() && secretAccessKey.isPresent()) {
            return "Static";
        }
        throw new IllegalArgumentException("Either a credentials provider or an access key ID and a secret access key must be provided");
    }

    private AwsCredentialsProvider getCredentialsProvider() {
        if (this.awsCredentialsProvider == null) {
            this.awsCredentialsProvider = this.credentialsProviderRegistry.create(this.getCredentialsProviderName(), this.parameters).orElse(null);
        }
        return this.awsCredentialsProvider;
    }

    private Optional<EncryptionConfiguration> getEncryptionConfiguration() {
        Optional<String> kmsKey = ConnectionParameters.KMS_KEY_PARAMETER.findValue(this.parameters);
        Optional<String> encryptionOptionString = ConnectionParameters.ENCRYPTION_OPTION_PARAMETER.findValue(this.parameters);
        Optional<EncryptionOption> encryptionOption = encryptionOptionString.map(EncryptionOption::fromValue);
        if (!encryptionOptionString.isPresent()) {
            if (kmsKey.isPresent()) {
                throw new IllegalArgumentException("KMS key provided but no encryption option.");
            }
            return Optional.empty();
        }
        if (encryptionOption.map(value -> value.equals((Object)EncryptionOption.UNKNOWN_TO_SDK_VERSION)).orElse(false).booleanValue()) {
            throw new IllegalArgumentException(String.format("%s is not a valid encryption option.", encryptionOptionString.get()));
        }
        if (encryptionOption.map(value -> value.equals((Object)EncryptionOption.SSE_S3)).orElse(false).booleanValue()) {
            if (kmsKey.isPresent()) {
                throw new IllegalArgumentException(String.format("KMS key provided for %s encryption option.", encryptionOptionString.get()));
            }
        } else if (!kmsKey.isPresent()) {
            throw new IllegalArgumentException(String.format("KMS key is required for %s encryption option.", encryptionOptionString.get()));
        }
        return encryptionOption.map(value -> (EncryptionConfiguration)EncryptionConfiguration.builder().encryptionOption((EncryptionOption)((Object)value)).kmsKey(kmsKey.orElse(null)).build());
    }

    private Optional<AclConfiguration> getAclConfiguration() {
        return ConnectionParameters.ACL_OPTION_PARAMETER.findValue(this.parameters).map(acl -> (AclConfiguration)AclConfiguration.builder().s3AclOption((String)acl).build());
    }

    private Optional<PollingStrategy> getPollingStrategy() {
        Duration min = ConnectionParameters.MIN_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER.findValue(this.parameters).orElseThrow(() -> new NoSuchElementException("The minimum value of the query execution status polling interval should not be missing when creating a polling strategy."));
        Duration max = ConnectionParameters.MAX_QUERY_EXECUTION_POLLING_INTERVAL_MILLIS_PARAMETER.findValue(this.parameters).orElseThrow(() -> new NoSuchElementException("The maximum value of the query execution status polling interval should not be missing when creating a polling strategy."));
        long multiplier = ConnectionParameters.QUERY_EXECUTION_POLLING_INTERVAL_MULTIPLIER_PARAMETER.findValue(this.parameters).orElseThrow(() -> new NoSuchElementException("The query execution polling interval multiplier should not be missing when creating a polling strategy."));
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("The minimum value of the query execution status polling interval (%s) cannot be larger than the maximum (%s).", min.toMillis(), max.toMillis()));
        }
        return Optional.of(new BackoffPollingStrategy(multiplier, min, max));
    }

    private Optional<URI> getAthenaEndpoint() {
        Optional<String> host = ConnectionParameters.HOST.findValue(this.parameters);
        Optional<String> endpoint = ConnectionParameters.ATHENA_ENDPOINT_PARAMETER.findValue(this.parameters);
        if (host.isPresent() && endpoint.isPresent()) {
            throw new IllegalArgumentException("The Athena endpoint cannot be specified both in the host part of the connection string and as an endpoint parameter");
        }
        if (host.isPresent()) {
            return host.map(h -> EndpointHelper.constructEndpointUri(h, "Athena"));
        }
        return endpoint.map(e -> EndpointHelper.constructEndpointUri(e, "Athena"));
    }

    public String getCatalog() {
        return ConnectionParameters.CATALOG_PARAMETER.findValue(this.parameters).orElse(null);
    }

    public void setCatalog(String newCatalog) {
        Optional<String> catalog = ConnectionParameters.CATALOG_PARAMETER.findValue(this.parameters);
        boolean isNewValue = catalog.map(currentCatalog -> !currentCatalog.equalsIgnoreCase(newCatalog)).orElse(true);
        if (isNewValue) {
            this.parameters.put(ConnectionParameters.CATALOG_PARAMETER, newCatalog);
            this.athenaClient = null;
        }
    }

    public String getSchema() {
        return ConnectionParameters.DATABASE_PARAMETER.findValue(this.parameters).orElse(null);
    }

    public void setSchema(String newSchema) {
        Optional<String> schema = ConnectionParameters.DATABASE_PARAMETER.findValue(this.parameters);
        boolean isNewValue = schema.map(currentSchema -> !currentSchema.equalsIgnoreCase(newSchema)).orElse(true);
        if (isNewValue) {
            this.parameters.put(ConnectionParameters.DATABASE_PARAMETER, newSchema);
            this.athenaClient = null;
        }
    }

    public AsyncAthena getAthenaClient() {
        if (this.athenaClient == null) {
            AsyncAthena.AsyncAthenaBuilder builder = this.athenaClientBuilderFactory.get();
            builder.athenaClient(this.getAthenaSdkClient());
            ConnectionParameters.WORK_GROUP_PARAMETER.findValue(this.parameters).ifPresent(builder::workGroup);
            ConnectionParameters.CATALOG_PARAMETER.findValue(this.parameters).ifPresent(builder::catalog);
            ConnectionParameters.DATABASE_PARAMETER.findValue(this.parameters).ifPresent(builder::database);
            ConnectionParameters.OUTPUT_LOCATION_PARAMETER.findValue(this.parameters).ifPresent(builder::outputLocation);
            builder.credentialsProvider(this.getCredentialsProvider());
            this.getEncryptionConfiguration().ifPresent(builder::encryptionConfiguration);
            ConnectionParameters.EXPECTED_BUCKET_OWNER_PARAMETER.findValue(this.parameters).ifPresent(builder::expectedBucketOwner);
            this.getAclConfiguration().ifPresent(builder::aclConfiguration);
            this.getPollingStrategy().ifPresent(builder::pollingStrategy);
            this.getAthenaEndpoint().ifPresent(builder::endpoint);
            this.getEnableResultReuseByAge().ifPresent(builder::enableResultReuseByAge);
            this.getMaxResultReuseAgeInMinutes().ifPresent(builder::maxResultReuseAgeInMinutes);
            this.getQueryResultsFactory().ifPresent(builder::queryResultsFactory);
            this.athenaClient = builder.build();
        }
        return this.athenaClient;
    }

    private Optional<AsyncQueryResultsFactory> getQueryResultsFactory() {
        return ConnectionParameters.RESULT_FETCHER.findValue(this.parameters).map(resultFetcher -> {
            int fetchSize = ConnectionParameters.FETCH_SIZE_PARAMETER.findValue(this.parameters).filter(value -> value > 0).orElse(10000);
            if (resultFetcher.equalsIgnoreCase(AUTO_FETCHER)) {
                return new AutoQueryResultsFactory(this.getAthenaSdkClient(), this.getAthenaStreamingClient(), this.getS3SdkClient(), this.executor, this.getResultParserFactory(fetchSize));
            }
            if (resultFetcher.equalsIgnoreCase(S3_FETCHER)) {
                return new S3StreamingQueryResultsFactory(this.getAthenaSdkClient(), this.getS3SdkClient(), this.executor, this.getResultParserFactory(fetchSize), false);
            }
            if (resultFetcher.equalsIgnoreCase(GET_QUERY_RESULTS_FETCHER)) {
                return new GetQueryResultsQueryResultsFactory(this.getAthenaSdkClient(), this.executor, this.getResultParserFactory(0));
            }
            if (resultFetcher.equalsIgnoreCase(GET_QUERY_RESULTS_STREAM_FETCHER)) {
                return new GetQueryResultsStreamQueryResultsFactory(this.getAthenaStreamingClient(), this.executor, this.getResultParserFactory(fetchSize));
            }
            throw new IllegalArgumentException(String.format("Invalid result fetcher: \"%s\"", resultFetcher));
        });
    }

    private NettyNioAsyncHttpClient.Builder getHttpClientBuilder() {
        NettyNioAsyncHttpClient.Builder builder = this.asyncHttpClientBuilderFactory.get();
        ProxyHelper.getAsyncProxyConfiguration(this.parameters).ifPresent(builder::proxyConfiguration);
        if (!this.apiRequestTimeout.equals(PRACTICALLY_INFINITE_DURATION)) {
            builder.connectionAcquisitionTimeout(this.apiRequestTimeout);
        }
        return builder;
    }

    private S3AsyncClient getS3SdkClient() {
        if (this.s3SdkClient == null) {
            S3AsyncClientBuilder s3SdkClientBuilder = this.s3SdkClientBuilderFactory.get();
            ConnectionParameters.REGION_PARAMETER.findValue(this.parameters).ifPresent(s3SdkClientBuilder::region);
            s3SdkClientBuilder.credentialsProvider(this.getCredentialsProvider());
            s3SdkClientBuilder.httpClientBuilder(this.getHttpClientBuilder());
            this.getS3Endpoint().ifPresent(s3SdkClientBuilder::endpointOverride);
            s3SdkClientBuilder.asyncConfiguration((ClientAsyncConfiguration)this.clientAsyncConfigurationBuilderFactory.get().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, this.executor).build());
            this.s3SdkClient = (S3AsyncClient)s3SdkClientBuilder.build();
        }
        return this.s3SdkClient;
    }

    private Optional<URI> getS3Endpoint() {
        return ConnectionParameters.S3_ENDPOINT_PARAMETER.findValue(this.parameters).map(s -> EndpointHelper.constructEndpointUri(s, S3_FETCHER));
    }

    public AthenaStreamingAsyncClient getAthenaStreamingClient() {
        if (this.athenaStreamingClient == null) {
            AthenaStreamingAsyncClientBuilder athenaStreamingClientBuilder = this.athenaStreamingClientBuilderFactory.get();
            ConnectionParameters.REGION_PARAMETER.findValue(this.parameters).ifPresent(athenaStreamingClientBuilder::region);
            athenaStreamingClientBuilder.credentialsProvider(this.getCredentialsProvider());
            this.getAthenaStreamingEndpoint().ifPresent(athenaStreamingClientBuilder::endpointOverride);
            athenaStreamingClientBuilder.httpClientBuilder(this.getHttpClientBuilder());
            athenaStreamingClientBuilder.asyncConfiguration((ClientAsyncConfiguration)this.clientAsyncConfigurationBuilderFactory.get().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, this.executor).build());
            this.athenaStreamingClient = (AthenaStreamingAsyncClient)athenaStreamingClientBuilder.build();
        }
        return this.athenaStreamingClient;
    }

    private Optional<URI> getAthenaStreamingEndpoint() {
        Optional<String> streamingEndpoint = ConnectionParameters.ATHENA_STREAMING_ENDPOINT_PARAMETER.findValue(this.parameters);
        Optional<Region> region = ConnectionParameters.REGION_PARAMETER.findValue(this.parameters);
        try {
            if (streamingEndpoint.isPresent()) {
                URI endpointUri = EndpointHelper.constructEndpointUri(streamingEndpoint.get(), "Athena streaming");
                if (endpointUri.getPort() == -1) {
                    logger.info(String.format("The provided streaming endpoint (%s) is missing a port number. Adding \":%s\"", endpointUri, 444), new Object[0]);
                    endpointUri = new URI(endpointUri.getScheme() + "://" + endpointUri.getHost() + ":" + 444 + endpointUri.getPath());
                } else if (endpointUri.getPort() != 444) {
                    logger.info("The provided port of the Athena streaming endpoint is {} (typically, port {} is used)", endpointUri.getPort(), 444);
                }
                return Optional.of(endpointUri);
            }
            if (this.getAthenaEndpoint().isPresent()) {
                logger.info("An Athena streaming endpoint is not provided. Will attempt to construct it from the Athena endpoint", new Object[0]);
                URI endpointUri = this.getAthenaEndpoint().get();
                if (endpointUri.getPort() == -1 || endpointUri.getPort() == 443) {
                    logger.info("Adding port number 444 to the Athena streaming endpoint under construction", new Object[0]);
                    return Optional.of(new URI(endpointUri.getScheme() + "://" + endpointUri.getHost() + ":" + 444 + endpointUri.getPath()));
                }
                logger.warn("An Athena streaming endpoint is not provided and will not be automatically set because the AthenaEndpoint uses the non-standard port {}", endpointUri.getPort());
                return Optional.empty();
            }
            if (region.isPresent()) {
                return Optional.of(new URI(String.format(STREAMING_API_URI_TEMPLATE, region.get())));
            }
            Region awsRegion = this.athenaSdkClient.serviceClientConfiguration().region();
            return Optional.of(new URI(String.format(STREAMING_API_URI_TEMPLATE, awsRegion)));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The Athena streaming endpoint is not a syntactically correct URI", e);
        }
    }

    public AthenaAsyncClient getAthenaSdkClient() {
        if (this.athenaSdkClient == null) {
            AthenaAsyncClientBuilder athenaClientBuilder = this.athenaSdkClientBuilderFactory.get();
            ConnectionParameters.REGION_PARAMETER.findValue(this.parameters).ifPresent(athenaClientBuilder::region);
            this.getAthenaEndpoint().ifPresent(athenaClientBuilder::endpointOverride);
            ClientOverrideConfiguration.Builder clientOverrideConfigurationBuilder = ClientOverrideConfiguration.builder();
            Optional<Integer> numRetries = ConnectionParameters.NUM_RETRIES_PARAMETER.findValue(this.parameters);
            numRetries.ifPresent(numRetriesValue -> clientOverrideConfigurationBuilder.retryPolicy(RetryPolicy.builder().numRetries((Integer)numRetriesValue).build()));
            clientOverrideConfigurationBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, this.getUserAgentString()).build();
            athenaClientBuilder.overrideConfiguration((ClientOverrideConfiguration)clientOverrideConfigurationBuilder.build());
            athenaClientBuilder.httpClientBuilder(this.getHttpClientBuilder());
            athenaClientBuilder.asyncConfiguration((ClientAsyncConfiguration)this.clientAsyncConfigurationBuilderFactory.get().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, this.executor).build());
            this.athenaSdkClient = (AthenaAsyncClient)((AthenaAsyncClientBuilder)athenaClientBuilder.credentialsProvider(this.getCredentialsProvider())).build();
        }
        return this.athenaSdkClient;
    }

    private String getUserAgentString() {
        StringBuilder userAgent = new StringBuilder("AthenaJDBC/").append(DriverVersion.instance().fullVersion());
        userAgent.append(" (CredentialsProvider:").append(this.getCredentialsProviderName());
        this.getApplicationName().ifPresent(applicationName -> userAgent.append("; ApplicationName:").append((String)applicationName));
        userAgent.append(")");
        return userAgent.toString();
    }

    public void setApplicationName(String newApplicationName) {
        String currentApplicationName = this.getApplicationName().orElse(null);
        if (!Objects.equals(newApplicationName, currentApplicationName)) {
            this.applicationNameOverride = newApplicationName;
            this.athenaSdkClient = null;
        }
    }

    private Optional<String> getApplicationName() {
        if (this.applicationNameOverride != null) {
            return Optional.of(this.applicationNameOverride);
        }
        return ConnectionParameters.APPLICATION_NAME_PARAMETER.findValue(this.parameters);
    }

    public void setApiRequestTimeout(Duration timeout) {
        if (!timeout.equals(this.apiRequestTimeout)) {
            this.apiRequestTimeout = timeout;
            this.athenaClient = null;
            this.athenaSdkClient = null;
            this.athenaStreamingClient = null;
            this.s3SdkClient = null;
        }
    }

    public Duration getApiRequestTimeout() {
        return this.apiRequestTimeout;
    }

    public int getFetchSize() {
        return ConnectionParameters.FETCH_SIZE_PARAMETER.findValue(this.parameters).get();
    }

    public boolean getConnectionTest() {
        return ConnectionParameters.CONNECTION_TEST_PARAMETER.findValue(this.parameters).get();
    }

    public Optional<Boolean> getEnableResultReuseByAge() {
        return ConnectionParameters.ENABLE_RESULT_REUSE_BY_AGE_PARAMETER.findValue(this.parameters);
    }

    public Optional<Integer> getMaxResultReuseAgeInMinutes() {
        Optional<Integer> maxResultReuseAgeInMinutes = ConnectionParameters.MAX_RESULT_REUSE_AGE_IN_MINUTES_PARAMETER.findValue(this.parameters);
        if (maxResultReuseAgeInMinutes.isPresent() && !this.getEnableResultReuseByAge().isPresent()) {
            logger.warn("{} will be ignored by Athena because {} is not set", ConnectionParameters.MAX_RESULT_REUSE_AGE_IN_MINUTES_PARAMETER.name(), ConnectionParameters.ENABLE_RESULT_REUSE_BY_AGE_PARAMETER.name());
        }
        return maxResultReuseAgeInMinutes;
    }

    private void configureLogging() {
        Optional<Path> logPath = ConnectionParameters.LOG_PATH_PARAMETER.findValue(this.parameters);
        Level logLevel = ConnectionParameters.LOG_LEVEL_PARAMETER.findValue(this.parameters).orElse(null);
        if (logPath.isPresent() && logLevel != null) {
            this.loggingCapture = this.loggingCaptureFactory.get();
            try {
                this.loggingCapture.start(logPath.get(), logLevel);
                logger.info("Athena JDBC driver {}, logging configured", DriverVersion.instance().fullVersion());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not start logging -- %s", e.getMessage()), e);
            }
        }
    }

    public String getWorkGroup() {
        return ConnectionParameters.WORK_GROUP_PARAMETER.findValue(this.parameters).get();
    }

    private ConnectionConfiguration validate() {
        ArrayList<IllegalArgumentException> exceptions = new ArrayList<IllegalArgumentException>();
        List<Runnable> validationMethods = Arrays.asList(this::configureLogging, this::getFetchSize, this::getEncryptionConfiguration, this::getAclConfiguration, this::getCredentialsProvider, this::getPollingStrategy, this::getConnectionTest, this::getAthenaEndpoint, this::getEnableResultReuseByAge, this::getMaxResultReuseAgeInMinutes, this::getAthenaSdkClient, this::getQueryResultsFactory);
        for (Runnable validationMethod : validationMethods) {
            try {
                validationMethod.run();
            }
            catch (IllegalArgumentException e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return this;
        }
        StringBuilder message = new StringBuilder("Invalid connection parameter(s):");
        for (IllegalArgumentException e : exceptions) {
            message.append(String.format(" %s;", e.getMessage()));
        }
        throw new IllegalArgumentException(message.toString());
    }

    private ResultParserFactory getResultParserFactory(int fetchSize) {
        Set<String> legacyModes = ConnectionParameters.LEGACY_MODES_PARAMETER.findValue(this.parameters).orElse(Collections.emptySet());
        return new ResultParserFactory(legacyModes, fetchSize);
    }

    private ConnectionConfiguration logConnectionParameters() {
        String message = "Connection parameters:\n" + this.parameters.entrySet().stream().map(entry -> this.toLoggableString((ConnectionParameter)entry.getKey(), (String)entry.getValue())).sorted().collect(Collectors.joining("\n"));
        logger.trace(message, new Object[0]);
        return this;
    }

    private String toLoggableString(ConnectionParameter<?> parameter, String value) {
        if (parameter.isSecret()) {
            return String.format("\t%s: %s", parameter.name(), "*******");
        }
        return String.format("\t%s: %s", parameter.name(), value);
    }

    public String getEffectiveAccessKeyId() {
        return this.getCredentialsProvider().resolveCredentials().accessKeyId();
    }

    public String getEffectiveUrl() {
        String prefix = "jdbc:athena://";
        String parsedParametersString = this.parameters.entrySet().stream().map(entry -> String.format("%s=%s", ((ConnectionParameter)entry.getKey()).name(), entry.getValue())).collect(Collectors.joining(";"));
        return prefix + parsedParametersString;
    }

    @Override
    public void close() {
        if (this.athenaClient != null) {
            this.athenaClient.close();
            this.athenaClient = null;
        }
        if (this.athenaSdkClient != null) {
            this.athenaSdkClient.close();
            this.athenaSdkClient = null;
        }
        if (this.s3SdkClient != null) {
            this.s3SdkClient.close();
            this.s3SdkClient = null;
        }
        if (this.athenaStreamingClient != null) {
            this.athenaStreamingClient.close();
            this.athenaStreamingClient = null;
        }
        if (this.loggingCapture != null) {
            this.loggingCapture.close();
            this.loggingCapture = null;
        }
        this.awsCredentialsProvider = null;
    }
}

