/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.results;

import com.amazon.athena.jdbc.AthenaDataType;
import com.amazon.athena.jdbc.results.ExtendedTableMetadata;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import software.amazon.awssdk.services.athena.model.Column;
import software.amazon.awssdk.services.athena.model.TableMetadata;

public final class ExtendedColumnMetadata
extends ExtendedTableMetadata {
    private static final Pattern COLUMN_FORMAT = Pattern.compile("^(\\w+)(?:\\((\\d+)(?:,\\s*(\\d+))?\\)|<[^<>]+>)?$");
    private final Column column;
    private final String name;
    private final String comment;
    private final String type;
    private final int columnSize;
    private final int decimalDigits;
    private final int columnIndex;

    public ExtendedColumnMetadata(TableMetadata tableMetadata, String catalogName, String schemaName, Column column, int columnIndex) {
        super(tableMetadata, catalogName, schemaName);
        this.column = column;
        this.name = column == null ? null : column.name();
        this.comment = column == null ? null : column.comment();
        this.columnIndex = columnIndex;
        if (column != null && column.type() != null) {
            Matcher columnMatcher = COLUMN_FORMAT.matcher(column.type());
            if (columnMatcher.find()) {
                this.type = columnMatcher.group(1);
                this.columnSize = columnMatcher.group(2) == null ? AthenaDataType.of(column.type()).maxSizeInBytes() : Integer.parseInt(columnMatcher.group(2));
                this.decimalDigits = columnMatcher.group(3) == null ? -1 : Integer.parseInt(columnMatcher.group(3));
            } else {
                this.type = null;
                this.columnSize = AthenaDataType.of(column.type()).maxSizeInBytes();
                this.decimalDigits = -1;
            }
        } else {
            this.type = null;
            this.columnSize = -1;
            this.decimalDigits = -1;
        }
    }

    @Generated
    public Column getColumn() {
        return this.column;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public int getColumnSize() {
        return this.columnSize;
    }

    @Generated
    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    @Generated
    public int getColumnIndex() {
        return this.columnIndex;
    }
}

