/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support;

import com.amazon.athena.logging.AthenaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DriverVersion {
    private static final AthenaLogger logger = AthenaLogger.of(DriverVersion.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+).*$");
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("\\A.+/athena-jdbc-(\\d+\\.\\d+\\.\\d+(?:-\\w+)?).*?!.+\\z");
    private static final String DEFAULT_VERSION_RESOURCE_PATH = "com/amazon/athena/version.properties";
    private static final String FALLBACK_VERSION_STRING = "3.0.0-UNKNOWN";
    private static final DriverVersion INSTANCE = DriverVersion.of("com/amazon/athena/version.properties");
    private final String fullVersion;
    private final int majorVersion;
    private final int minorVersion;

    private DriverVersion(String fullVersion) {
        this.fullVersion = fullVersion;
        Matcher matcher = VERSION_PATTERN.matcher(fullVersion);
        if (matcher.matches()) {
            this.majorVersion = Integer.parseInt(matcher.group(1));
            this.minorVersion = Integer.parseInt(matcher.group(2));
        } else {
            logger.warn("Could not parse driver version from \"{}\"", fullVersion);
            this.majorVersion = 0;
            this.minorVersion = 0;
        }
    }

    public static DriverVersion instance() {
        return INSTANCE;
    }

    static DriverVersion of(String resourcePath) {
        return DriverVersion.of(DriverVersion.class.getClassLoader(), resourcePath);
    }

    static DriverVersion of(ClassLoader classLoader, String resourcePath) {
        String version = DriverVersion.readVersion(classLoader, resourcePath);
        if (version == null && (version = DriverVersion.parseFileName(classLoader)) == null) {
            logger.warn("Could not find driver version number, falling back on \"{}\"", FALLBACK_VERSION_STRING);
            version = FALLBACK_VERSION_STRING;
        }
        return new DriverVersion(version);
    }

    private static String readVersion(ClassLoader classLoader, String resourcePath) {
        InputStream stream = classLoader.getResourceAsStream(resourcePath);
        if (stream == null) {
            logger.warn("Could not find driver version number, version resource not found (looked for \"{}\")", resourcePath);
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(stream);
            String version = properties.getProperty("version");
            if (version == null) {
                logger.warn("Could not find driver version number, no version property found", new Object[0]);
            }
            return version;
        }
        catch (IOException e) {
            logger.warn(String.format("Could not find driver version number, error while reading the version resource (got \"%s\")", e.getMessage()), e);
            return null;
        }
    }

    private static String parseFileName(ClassLoader classLoader) {
        URL url = classLoader.getResource(DriverVersion.class.getName().replaceAll("\\.", "/") + ".class");
        if (url == null) {
            logger.warn("Could not find driver version number from the file name, could not get class URL", new Object[0]);
            return null;
        }
        if (!url.getProtocol().equals("jar")) {
            logger.warn("Could not find driver version number from the file name, file is not a jar (file URL was \"{}\")", url);
            return null;
        }
        Matcher fileNameMatcher = FILE_NAME_PATTERN.matcher(url.getPath());
        if (fileNameMatcher.matches()) {
            return fileNameMatcher.group(1);
        }
        logger.warn("Could not find driver version number in file name (\"{}\" did not match the expected pattern)", url.getPath());
        return null;
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }
}

