/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support;

import com.amazon.athena.jdbc.configuration.ConnectionParameter;
import com.amazon.athena.jdbc.configuration.ConnectionParameters;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public class ProxyHelper {
    public static Optional<software.amazon.awssdk.http.nio.netty.ProxyConfiguration> getAsyncProxyConfiguration(Map<ConnectionParameter<?>, String> parameters) {
        return ProxyParameterValues.of(parameters).map(values -> (software.amazon.awssdk.http.nio.netty.ProxyConfiguration)software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().scheme(values.scheme()).host(values.host()).port(values.port()).username(values.username()).password(values.password()).nonProxyHosts(values.nonProxyHosts()).build());
    }

    public static Optional<ProxyConfiguration> getSyncProxyConfiguration(Map<ConnectionParameter<?>, String> parameters) {
        return ProxyParameterValues.of(parameters).map(values -> (ProxyConfiguration)ProxyConfiguration.builder().scheme(values.scheme()).endpoint(values.endpoint()).username(values.username()).password(values.password()).nonProxyHosts(values.nonProxyHosts()).build());
    }

    private static class ProxyParameterValues {
        private final String host;
        private final String scheme;
        private final Integer port;
        private final URI endpoint;
        private final String username;
        private final String password;
        private final Set<String> nonProxyHosts;

        public static Optional<ProxyParameterValues> of(Map<ConnectionParameter<?>, String> parameters) {
            String host = ConnectionParameters.PROXY_HOST_PARAMETER.findValue(parameters).orElse(null);
            Integer port = ConnectionParameters.PROXY_PORT_PARAMETER.findValue(parameters).orElse(null);
            if (host == null && port == null) {
                return Optional.empty();
            }
            return Optional.of(new ProxyParameterValues(host, port, ConnectionParameters.PROXY_USERNAME_PARAMETER.findValue(parameters).orElse(null), ConnectionParameters.PROXY_PASSWORD_PARAMETER.findValue(parameters).orElse(null), ConnectionParameters.PROXY_EXEMPT_HOSTS_PARAMETER.findValue(parameters).orElse(null)));
        }

        public ProxyParameterValues(String host, Integer port, String username, String password, Set<String> nonProxyHosts) {
            if (host == null || port == null) {
                throw new IllegalArgumentException("Both a proxy host and a proxy port must be provided, or neither");
            }
            if (username == null && password != null || username != null && password == null) {
                throw new IllegalArgumentException("Both a proxy username and a proxy password must be provided, or neither");
            }
            int schemeSeparatorIndex = host.indexOf("://");
            this.host = schemeSeparatorIndex == -1 ? host : host.substring(schemeSeparatorIndex + 3);
            this.scheme = schemeSeparatorIndex == -1 ? "https" : host.substring(0, schemeSeparatorIndex);
            this.port = port;
            this.endpoint = URI.create(String.format(host.startsWith("http://") || host.startsWith("https://") ? "%s:%d" : "https://%s:%d", host, port));
            this.username = username;
            this.password = password;
            this.nonProxyHosts = nonProxyHosts;
        }

        @Generated
        public String host() {
            return this.host;
        }

        @Generated
        public String scheme() {
            return this.scheme;
        }

        @Generated
        public Integer port() {
            return this.port;
        }

        @Generated
        public URI endpoint() {
            return this.endpoint;
        }

        @Generated
        public String username() {
            return this.username;
        }

        @Generated
        public String password() {
            return this.password;
        }

        @Generated
        public Set<String> nonProxyHosts() {
            return this.nonProxyHosts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyParameterValues)) {
                return false;
            }
            ProxyParameterValues other = (ProxyParameterValues)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$port = this.port();
            Integer other$port = other.port();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$host = this.host();
            String other$host = other.host();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$scheme = this.scheme();
            String other$scheme = other.scheme();
            if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
                return false;
            }
            URI this$endpoint = this.endpoint();
            URI other$endpoint = other.endpoint();
            if (this$endpoint == null ? other$endpoint != null : !((Object)this$endpoint).equals(other$endpoint)) {
                return false;
            }
            String this$username = this.username();
            String other$username = other.username();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            Set<String> this$nonProxyHosts = this.nonProxyHosts();
            Set<String> other$nonProxyHosts = other.nonProxyHosts();
            return !(this$nonProxyHosts == null ? other$nonProxyHosts != null : !((Object)this$nonProxyHosts).equals(other$nonProxyHosts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProxyParameterValues;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $port = this.port();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $host = this.host();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $scheme = this.scheme();
            result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
            URI $endpoint = this.endpoint();
            result = result * 59 + ($endpoint == null ? 43 : ((Object)$endpoint).hashCode());
            String $username = this.username();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            Set<String> $nonProxyHosts = this.nonProxyHosts();
            result = result * 59 + ($nonProxyHosts == null ? 43 : ((Object)$nonProxyHosts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProxyHelper.ProxyParameterValues(host=" + this.host() + ", scheme=" + this.scheme() + ", port=" + this.port() + ", endpoint=" + this.endpoint() + ", username=" + this.username() + ", password=" + this.password() + ", nonProxyHosts=" + this.nonProxyHosts() + ")";
        }
    }
}

