/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscriberIterator
implements Subscriber<String[]>,
Iterator<String[]> {
    private static final String[] END_SENTINEL = new String[0];
    private static final String[] ERROR_SENTINEL = new String[0];
    private final BlockingQueue<String[]> queue = new LinkedBlockingQueue<String[]>();
    private final AtomicReference<Throwable> error = new AtomicReference<Object>(null);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final int fetchSize;
    private Subscription subscription;
    private String[] nextRow;

    public SubscriberIterator(int fetchSize) {
        this.fetchSize = fetchSize;
        this.subscription = null;
        this.nextRow = null;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow == null) {
            try {
                this.nextRow = this.queue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.nextRow = END_SENTINEL;
            }
        }
        return this.nextRow != END_SENTINEL;
    }

    @Override
    public String[] next() {
        if (this.hasNext()) {
            if (this.nextRow == ERROR_SENTINEL) {
                throw new CompletionException(this.error.get());
            }
            String[] r = this.nextRow;
            this.nextRow = null;
            if (!this.complete.get()) {
                this.subscription.request(1L);
            }
            return r;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        if (this.subscription == null) {
            this.subscription = subscription;
            subscription.request(this.fetchSize);
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onNext(String[] row) {
        this.queue.add(row);
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("Error cannot be null");
        }
        this.error.set(throwable);
        this.queue.add(ERROR_SENTINEL);
        this.complete.set(true);
    }

    @Override
    public void onComplete() {
        this.queue.add(END_SENTINEL);
        this.complete.set(true);
    }
}

