/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.LinkedList;
import java.util.List;

class PositionFunction
extends JdbcFunction {
    PositionFunction() {
        super("POSITION", "POSITION", JdbcFunction.FunctionCategory.STRING, 1, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        LinkedList<List<Token>> processedArgs = new LinkedList<List<Token>>();
        if (args.size() == 2) {
            String type = this.findFirstExpression(args.get(1)).map(Token::value).orElse("");
            if (type.equalsIgnoreCase("OCTETS")) {
                throw new FunctionExpressionException(String.format("The function %s does not support the OCTETS argument", this.jdbcName()));
            }
            if (!type.equalsIgnoreCase("CHARACTERS")) throw new FunctionExpressionException(String.format("The second argument to the POSITION function must be \"CHARACTERS\" or \"OCTETS\", got \"%s\"", type));
            processedArgs.add(args.get(0));
            return processedArgs;
        } else {
            processedArgs.add(args.get(0));
        }
        return processedArgs;
    }
}

