/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.jdbc.support.sql;

import com.amazon.athena.jdbc.support.sql.FunctionExpressionException;
import com.amazon.athena.jdbc.support.sql.JdbcFunction;
import com.amazon.athena.jdbc.support.sql.Token;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class SpaceFunction
extends JdbcFunction {
    SpaceFunction() {
        super("SPACE", "RPAD", JdbcFunction.FunctionCategory.STRING, 1, 1);
    }

    @Override
    protected List<List<Token>> processArguments(List<List<Token>> rawArgs) throws FunctionExpressionException {
        List<List<Token>> args = super.processArguments(rawArgs);
        List<Token> lengthArg = this.ensureHasWhitespacePrefix(args.get(0));
        return Arrays.asList(Collections.singletonList(Token.sql("''")), lengthArg, Arrays.asList(Token.space(), Token.sql("' '")));
    }
}

