/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.athena.logging;

import com.amazon.athena.logging.AthenaLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;
import software.amazon.awssdk.utils.IoUtils;

public class AthenaFileAppender
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AthenaFileAppender.class);
    private static final DateTimeFormatter FILE_NAME_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter LOG_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private final Clock clock;
    private final Fs fileSystem;
    private final Object outLock;
    private PrintWriter out;
    private Level level;

    AthenaFileAppender(Clock clock, Fs fileSystem) {
        this.clock = clock;
        this.fileSystem = fileSystem;
        this.out = null;
        this.outLock = new Object();
    }

    private ZonedDateTime now() {
        return ZonedDateTime.ofInstant(this.clock.instant(), ZoneId.of("UTC"));
    }

    private String createFileName() {
        StringBuilder fileName = new StringBuilder("AthenaJdbcDriver-");
        fileName.append(FILE_NAME_DATE_TIME_FORMAT.format(this.now()));
        fileName.append("-");
        fileName.append(UUID.randomUUID().toString().substring(0, 4));
        fileName.append(".log");
        return fileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile(Path logFile) throws IOException {
        Object object = this.outLock;
        synchronized (object) {
            Path directory = logFile.getParent();
            if (!this.fileSystem.exists(directory)) {
                try {
                    this.fileSystem.createDirectories(directory);
                }
                catch (IOException e) {
                    throw new IOException(String.format("Could not create log file (could not create directory \"%s\")", directory), e);
                }
            } else if (!this.fileSystem.isDirectory(directory)) {
                throw new IOException(String.format("Could not create log file (\"%s\" exists but is not a directory)", directory));
            }
            try {
                this.out = new PrintWriter(this.fileSystem.newBufferedWriter(logFile, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not create log file (\"%s\") -- %s", logFile.toAbsolutePath(), e.getMessage()), e);
            }
        }
    }

    public void start(Path directory, Level level) throws IOException {
        this.level = level;
        Path logFile = directory.resolve(this.createFileName());
        logger.info("Writing driver logs to {}", (Object)logFile);
        this.openFile(logFile);
    }

    void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        AthenaLogger.appenderStopped(this);
        IoUtils.closeQuietly(this.out, null);
        this.out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(String loggerName, Level level, String message, Object[] args, Throwable cause) {
        if (this.level.compareTo(level) < 0) {
            return;
        }
        String time = LOG_DATE_TIME_FORMAT.format(this.now());
        String line = MessageFormatter.arrayFormat(message, args, cause).getMessage();
        Object object = this.outLock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.out.print(time);
            this.out.print('\t');
            this.out.print((Object)level);
            this.out.print('\t');
            this.out.print(loggerName);
            this.out.print('\t');
            this.out.print(line);
            if (cause != null) {
                this.out.print(" \u2013 Caused by: ");
                cause.printStackTrace(this.out);
            } else {
                this.out.println();
            }
            this.flush();
        }
    }

    static class Fs {
        Fs() {
        }

        void createDirectories(Path path) throws IOException {
            Files.createDirectories(path, new FileAttribute[0]);
        }

        BufferedWriter newBufferedWriter(Path path, Charset charset) throws IOException {
            return Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
        }

        boolean isDirectory(Path path) {
            return Files.isDirectory(path, new LinkOption[0]);
        }

        boolean exists(Path path) {
            return Files.exists(path, new LinkOption[0]);
        }
    }
}

