/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.internal.SystemSettingsCredentialsProvider;
import software.amazon.awssdk.utils.SystemSetting;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public final class EnvironmentVariableCredentialsProvider
extends SystemSettingsCredentialsProvider {
    private static final String PROVIDER_NAME = "EnvironmentVariableCredentialsProvider";

    private EnvironmentVariableCredentialsProvider() {
    }

    public static EnvironmentVariableCredentialsProvider create() {
        return new EnvironmentVariableCredentialsProvider();
    }

    @Override
    protected Optional<String> loadSetting(SystemSetting setting) {
        return SystemSetting.getStringValueFromEnvironmentVariable(setting.environmentVariable());
    }

    @Override
    protected String provider() {
        return PROVIDER_NAME;
    }

    public String toString() {
        return ToString.create(PROVIDER_NAME);
    }
}

