/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials.internal;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkInternalApi
public final class Ec2MetadataConfigProvider {
    private static final String EC2_METADATA_SERVICE_URL_IPV4 = "http://169.254.169.254";
    private static final String EC2_METADATA_SERVICE_URL_IPV6 = "http://[fd00:ec2::254]";
    private final Supplier<ProfileFile> profileFile;
    private final String profileName;
    private final Lazy<Boolean> metadataV1Disabled;
    private final Lazy<Long> serviceTimeout;

    private Ec2MetadataConfigProvider(Builder builder) {
        this.profileFile = builder.profileFile;
        this.profileName = builder.profileName;
        this.metadataV1Disabled = new Lazy<Boolean>(this::resolveMetadataV1Disabled);
        this.serviceTimeout = new Lazy<Long>(this::resolveServiceTimeout);
    }

    public String getEndpoint() {
        String endpointOverride = this.getEndpointOverride();
        if (endpointOverride != null) {
            return endpointOverride;
        }
        EndpointMode endpointMode = this.getEndpointMode();
        switch (endpointMode) {
            case IPV4: {
                return EC2_METADATA_SERVICE_URL_IPV4;
            }
            case IPV6: {
                return EC2_METADATA_SERVICE_URL_IPV6;
            }
        }
        throw SdkClientException.create("Unknown endpoint mode: " + (Object)((Object)endpointMode));
    }

    public EndpointMode getEndpointMode() {
        Optional<String> endpointMode = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE.getNonDefaultStringValue();
        if (endpointMode.isPresent()) {
            return EndpointMode.fromValue(endpointMode.get());
        }
        return this.configFileEndpointMode().orElseGet(() -> EndpointMode.fromValue(SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE.defaultValue()));
    }

    public String getEndpointOverride() {
        Optional<String> endpointOverride = SdkSystemSetting.AWS_EC2_METADATA_SERVICE_ENDPOINT.getNonDefaultStringValue();
        if (endpointOverride.isPresent()) {
            return endpointOverride.get();
        }
        Optional<String> configFileValue = this.configFileEndpointOverride();
        return configFileValue.orElse(null);
    }

    public boolean isMetadataV1Disabled() {
        return this.metadataV1Disabled.getValue();
    }

    public long serviceTimeout() {
        return this.serviceTimeout.getValue();
    }

    private boolean resolveMetadataV1Disabled() {
        return OptionalUtils.firstPresent(Ec2MetadataConfigProvider.fromSystemSettingsMetadataV1Disabled(), new Supplier[]{() -> Ec2MetadataConfigProvider.fromProfileFileMetadataV1Disabled(this.profileFile, this.profileName)}).orElse(false);
    }

    private long resolveServiceTimeout() {
        return OptionalUtils.firstPresent(Ec2MetadataConfigProvider.fromSystemSettingsServiceTimeout(), new Supplier[]{() -> Ec2MetadataConfigProvider.fromProfileFileServiceTimeout(this.profileFile, this.profileName)}).orElseGet(() -> Ec2MetadataConfigProvider.parseTimeoutValue(SdkSystemSetting.AWS_METADATA_SERVICE_TIMEOUT.defaultValue()));
    }

    private static Optional<Boolean> fromSystemSettingsMetadataV1Disabled() {
        return SdkSystemSetting.AWS_EC2_METADATA_V1_DISABLED.getBooleanValue();
    }

    private static Optional<Boolean> fromProfileFileMetadataV1Disabled(Supplier<ProfileFile> profileFile, String profileName) {
        return profileFile.get().profile(profileName).flatMap(p -> p.booleanProperty("ec2_metadata_v1_disabled"));
    }

    private static Optional<Long> fromSystemSettingsServiceTimeout() {
        return SdkSystemSetting.AWS_METADATA_SERVICE_TIMEOUT.getNonDefaultStringValue().map(Ec2MetadataConfigProvider::parseTimeoutValue);
    }

    private static Optional<Long> fromProfileFileServiceTimeout(Supplier<ProfileFile> profileFile, String profileName) {
        return profileFile.get().profile(profileName).flatMap(p -> p.property("metadata_service_timeout")).map(Ec2MetadataConfigProvider::parseTimeoutValue);
    }

    private static long parseTimeoutValue(String timeoutValue) {
        try {
            int timeoutSeconds = Integer.parseInt(timeoutValue);
            return Duration.ofSeconds(timeoutSeconds).toMillis();
        }
        catch (NumberFormatException e) {
            try {
                double timeoutSeconds = Double.parseDouble(timeoutValue);
                return Math.round(timeoutSeconds * 1000.0);
            }
            catch (NumberFormatException ignored) {
                throw new IllegalStateException(String.format("Timeout value '%s' is not a valid integer or double.", timeoutValue));
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private Optional<EndpointMode> configFileEndpointMode() {
        return this.resolveProfile().flatMap(p -> p.property("ec2_metadata_service_endpoint_mode")).map(EndpointMode::fromValue);
    }

    private Optional<String> configFileEndpointOverride() {
        return this.resolveProfile().flatMap(p -> p.property("ec2_metadata_service_endpoint"));
    }

    private Optional<Profile> resolveProfile() {
        ProfileFile profileFileToUse = this.resolveProfileFile();
        String profileNameToUse = this.resolveProfileName();
        return profileFileToUse.profile(profileNameToUse);
    }

    private ProfileFile resolveProfileFile() {
        if (this.profileFile != null) {
            return this.profileFile.get();
        }
        return ProfileFile.defaultProfileFile();
    }

    private String resolveProfileName() {
        if (this.profileName != null) {
            return this.profileName;
        }
        return ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
    }

    public static class Builder {
        private Supplier<ProfileFile> profileFile;
        private String profileName;

        public Builder profileFile(Supplier<ProfileFile> profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Ec2MetadataConfigProvider build() {
            return new Ec2MetadataConfigProvider(this);
        }
    }

    public static enum EndpointMode {
        IPV4,
        IPV6;


        public static EndpointMode fromValue(String s) {
            if (s == null) {
                return null;
            }
            for (EndpointMode value : EndpointMode.values()) {
                if (!value.name().equalsIgnoreCase(s)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unrecognized value for endpoint mode: " + s);
        }
    }
}

