/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials.internal;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import software.amazon.awssdk.regions.util.ResourcesEndpointRetryPolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class StaticResourcesEndpointProvider
implements ResourcesEndpointProvider {
    private final URI endpoint;
    private final Map<String, String> headers;
    private final Duration connectionTimeout;
    private final ResourcesEndpointRetryPolicy retryPolicy;

    private StaticResourcesEndpointProvider(URI endpoint, Map<String, String> additionalHeaders, Duration customTimeout, ResourcesEndpointRetryPolicy retryPolicy) {
        this.endpoint = Validate.paramNotNull(endpoint, "endpoint");
        this.headers = ResourcesEndpointProvider.super.headers();
        if (additionalHeaders != null) {
            this.headers.putAll(additionalHeaders);
        }
        this.connectionTimeout = customTimeout;
        this.retryPolicy = Validate.getOrDefault(retryPolicy, () -> ResourcesEndpointRetryPolicy.NO_RETRY);
    }

    @Override
    public Optional<Duration> connectionTimeout() {
        return Optional.ofNullable(this.connectionTimeout);
    }

    @Override
    public URI endpoint() throws IOException {
        return this.endpoint;
    }

    @Override
    public Map<String, String> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public ResourcesEndpointRetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private URI endpoint;
        private Map<String, String> additionalHeaders = new HashMap<String, String>();
        private Duration customTimeout;
        private ResourcesEndpointRetryPolicy retryPolicy;

        public Builder endpoint(URI endpoint) {
            this.endpoint = Validate.paramNotNull(endpoint, "endpoint");
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            if (headers != null) {
                this.additionalHeaders.putAll(headers);
            }
            return this;
        }

        public Builder connectionTimeout(Duration timeout) {
            this.customTimeout = timeout;
            return this;
        }

        public Builder retryPolicy(ResourcesEndpointRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public StaticResourcesEndpointProvider build() {
            return new StaticResourcesEndpointProvider(this.endpoint, this.additionalHeaders, this.customTimeout, this.retryPolicy);
        }
    }
}

