/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.builder;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.defaultsmode.DefaultsMode;
import software.amazon.awssdk.awscore.endpoint.AwsClientEndpointProvider;
import software.amazon.awssdk.awscore.endpoint.DualstackEnabledProvider;
import software.amazon.awssdk.awscore.endpoint.FipsEnabledProvider;
import software.amazon.awssdk.awscore.eventstream.EventStreamInitialRequestInterceptor;
import software.amazon.awssdk.awscore.interceptor.HelpfulUnknownHostExceptionInterceptor;
import software.amazon.awssdk.awscore.interceptor.TraceIdExecutionInterceptor;
import software.amazon.awssdk.awscore.internal.auth.Sigv4aSigningRegionSetProvider;
import software.amazon.awssdk.awscore.internal.defaultsmode.AutoDefaultsModeDiscovery;
import software.amazon.awssdk.awscore.internal.defaultsmode.DefaultsModeConfiguration;
import software.amazon.awssdk.awscore.internal.defaultsmode.DefaultsModeResolver;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.client.builder.SdkDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.internal.SdkInternalTestAdvancedClientOption;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetryStrategy;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServiceMetadataAdvancedOption;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.retries.internal.DefaultAwareRetryStrategy;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

@SdkProtectedApi
public abstract class AwsDefaultClientBuilder<BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT>
extends SdkDefaultClientBuilder<BuilderT, ClientT>
implements AwsClientBuilder<BuilderT, ClientT> {
    private static final Logger log = Logger.loggerFor(AwsClientBuilder.class);
    private static final String DEFAULT_ENDPOINT_PROTOCOL = "https";
    private static final String[] FIPS_SEARCH = new String[]{"fips-", "-fips"};
    private static final String[] FIPS_REPLACE = new String[]{"", ""};
    private final AutoDefaultsModeDiscovery autoDefaultsModeDiscovery;

    protected AwsDefaultClientBuilder() {
        this.autoDefaultsModeDiscovery = new AutoDefaultsModeDiscovery();
    }

    @SdkTestInternalApi
    AwsDefaultClientBuilder(SdkHttpClient.Builder defaultHttpClientBuilder, SdkAsyncHttpClient.Builder defaultAsyncHttpClientFactory, AutoDefaultsModeDiscovery autoDefaultsModeDiscovery) {
        super(defaultHttpClientBuilder, defaultAsyncHttpClientFactory);
        this.autoDefaultsModeDiscovery = autoDefaultsModeDiscovery;
    }

    protected abstract String serviceEndpointPrefix();

    protected abstract String signingName();

    protected abstract String serviceName();

    @Override
    protected final SdkClientConfiguration mergeChildDefaults(SdkClientConfiguration configuration) {
        SdkClientConfiguration config = this.mergeServiceDefaults(configuration);
        config = config.merge(c -> c.option(AwsAdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION, true).option(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION, false).option(AwsClientOption.SERVICE_SIGNING_NAME, this.signingName()).option(SdkClientOption.SERVICE_NAME, this.serviceName()).option(AwsClientOption.ENDPOINT_PREFIX, this.serviceEndpointPrefix()));
        return this.mergeInternalDefaults(config);
    }

    protected SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration configuration) {
        return configuration;
    }

    protected SdkClientConfiguration mergeInternalDefaults(SdkClientConfiguration configuration) {
        return configuration;
    }

    @Override
    protected final SdkClientConfiguration finalizeChildConfiguration(SdkClientConfiguration configuration) {
        configuration = this.finalizeServiceConfiguration(configuration);
        configuration = this.finalizeAwsConfiguration(configuration);
        return configuration;
    }

    private SdkClientConfiguration finalizeAwsConfiguration(SdkClientConfiguration configuration) {
        return configuration.toBuilder().option(SdkClientOption.EXECUTION_INTERCEPTORS, this.addAwsInterceptors(configuration)).lazyOptionIfAbsent(AwsClientOption.AWS_REGION, this::resolveRegion).lazyOptionIfAbsent(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED, this::resolveDualstackEndpointEnabled).lazyOptionIfAbsent(AwsClientOption.FIPS_ENDPOINT_ENABLED, this::resolveFipsEndpointEnabled).lazyOption(AwsClientOption.DEFAULTS_MODE, this::resolveDefaultsMode).lazyOptionIfAbsent(SdkClientOption.DEFAULT_RETRY_MODE, this::resolveDefaultRetryMode).lazyOption(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, this::resolveDefaultS3UsEast1RegionalEndpoint).lazyOptionIfAbsent(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, this::resolveCredentialsIdentityProvider).lazyOptionIfAbsent(AwsClientOption.CREDENTIALS_PROVIDER, this::resolveCredentialsProvider).lazyOptionIfAbsent(SdkClientOption.CLIENT_ENDPOINT_PROVIDER, this::resolveClientEndpointProvider).lazyOptionIfAbsent(SdkClientOption.ENDPOINT, this::resolveEndpoint).lazyOptionIfAbsent(SdkClientOption.ENDPOINT_OVERRIDDEN, this::resolveEndpointOverridden).lazyOption(AwsClientOption.SIGNING_REGION, this::resolveSigningRegion).lazyOption(SdkClientOption.HTTP_CLIENT_CONFIG, this::resolveHttpClientConfig).applyMutation(this::configureRetryPolicy).applyMutation(this::configureRetryStrategy).lazyOptionIfAbsent(SdkClientOption.IDENTITY_PROVIDERS, this::resolveIdentityProviders).lazyOptionIfAbsent(AwsClientOption.AWS_SIGV4A_SIGNING_REGION_SET, this::resolveSigv4aSigningRegionSet).build();
    }

    @Override
    protected final SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        if (this.overrideConfig == null) {
            return configuration;
        }
        SdkClientConfiguration.Builder builder = configuration.toBuilder();
        this.overrideConfig.retryStrategy().ifPresent(retryStrategy -> builder.option(SdkClientOption.RETRY_STRATEGY, retryStrategy));
        this.overrideConfig.retryMode().ifPresent(retryMode -> builder.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode)));
        this.overrideConfig.retryStrategyConfigurator().ifPresent(configurator -> {
            RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
            configurator.accept(defaultBuilder);
            builder.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
        });
        builder.putAll(this.overrideConfig);
        this.checkEndpointOverriddenOverride(configuration, builder);
        builder.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        builder.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        builder.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
        return builder.build();
    }

    private void checkEndpointOverriddenOverride(SdkClientConfiguration configuration, SdkClientConfiguration.Builder builder) {
        Optional<Boolean> endpointOverriddenOverride = this.overrideConfig.advancedOption(SdkInternalTestAdvancedClientOption.ENDPOINT_OVERRIDDEN_OVERRIDE);
        endpointOverriddenOverride.ifPresent(override -> {
            ClientEndpointProvider clientEndpoint = configuration.option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER);
            builder.option(SdkClientOption.CLIENT_ENDPOINT_PROVIDER, ClientEndpointProvider.create(clientEndpoint.clientEndpoint(), override));
        });
    }

    private AttributeMap resolveHttpClientConfig(AttributeMap.LazyValueSource config) {
        AttributeMap attributeMap = this.serviceHttpConfig();
        return this.mergeSmartHttpDefaults(config, attributeMap);
    }

    protected AttributeMap serviceHttpConfig() {
        return AttributeMap.empty();
    }

    private IdentityProviders resolveIdentityProviders(AttributeMap.LazyValueSource config) {
        return (IdentityProviders)IdentityProviders.builder().putIdentityProvider(config.get(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).build();
    }

    private DefaultsMode resolveDefaultsMode(AttributeMap.LazyValueSource config) {
        DefaultsMode configuredMode = config.get(AwsClientOption.CONFIGURED_DEFAULTS_MODE);
        if (configuredMode == null) {
            configuredMode = DefaultsModeResolver.create().profileFile(config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(config.get(SdkClientOption.PROFILE_NAME)).resolve();
        }
        if (configuredMode != DefaultsMode.AUTO) {
            return configuredMode;
        }
        return this.autoDefaultsModeDiscovery.discover(config.get(AwsClientOption.AWS_REGION));
    }

    private RetryMode resolveDefaultRetryMode(AttributeMap.LazyValueSource config) {
        return DefaultsModeConfiguration.defaultConfig(config.get(AwsClientOption.DEFAULTS_MODE)).get(SdkClientOption.DEFAULT_RETRY_MODE);
    }

    private String resolveDefaultS3UsEast1RegionalEndpoint(AttributeMap.LazyValueSource config) {
        return DefaultsModeConfiguration.defaultConfig(config.get(AwsClientOption.DEFAULTS_MODE)).get(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT);
    }

    protected SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration configuration) {
        return configuration;
    }

    private AttributeMap mergeSmartHttpDefaults(AttributeMap.LazyValueSource config, AttributeMap attributeMap) {
        DefaultsMode defaultsMode = config.get(AwsClientOption.DEFAULTS_MODE);
        return attributeMap.merge(DefaultsModeConfiguration.defaultHttpConfig(defaultsMode));
    }

    private Region resolveSigningRegion(AttributeMap.LazyValueSource config) {
        return ServiceMetadata.of(this.serviceEndpointPrefix()).signingRegion(config.get(AwsClientOption.AWS_REGION));
    }

    private ClientEndpointProvider resolveClientEndpointProvider(AttributeMap.LazyValueSource config) {
        ServiceMetadataAdvancedOption<String> useGlobalS3EndpointProperty = ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT;
        return AwsClientEndpointProvider.builder().serviceEndpointPrefix(this.serviceEndpointPrefix()).defaultProtocol(DEFAULT_ENDPOINT_PROTOCOL).region(config.get(AwsClientOption.AWS_REGION)).profileFile(config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(config.get(SdkClientOption.PROFILE_NAME)).putAdvancedOption(useGlobalS3EndpointProperty, config.get(useGlobalS3EndpointProperty)).dualstackEnabled(config.get(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED)).fipsEnabled(config.get(AwsClientOption.FIPS_ENDPOINT_ENABLED)).build();
    }

    private URI resolveEndpoint(AttributeMap.LazyValueSource config) {
        return config.get(SdkClientOption.CLIENT_ENDPOINT_PROVIDER).clientEndpoint();
    }

    private boolean resolveEndpointOverridden(AttributeMap.LazyValueSource config) {
        return config.get(SdkClientOption.CLIENT_ENDPOINT_PROVIDER).isEndpointOverridden();
    }

    private Region resolveRegion(AttributeMap.LazyValueSource config) {
        Boolean defaultRegionDetectionEnabled = config.get(AwsAdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION);
        if (defaultRegionDetectionEnabled != null && !defaultRegionDetectionEnabled.booleanValue()) {
            throw new IllegalStateException("No region was configured, and use-region-provider-chain was disabled.");
        }
        Supplier<ProfileFile> profileFile = config.get(SdkClientOption.PROFILE_FILE_SUPPLIER);
        String profileName = config.get(SdkClientOption.PROFILE_NAME);
        return DefaultAwsRegionProviderChain.builder().profileFile(profileFile).profileName(profileName).build().getRegion();
    }

    private Boolean resolveDualstackEndpointEnabled(AttributeMap.LazyValueSource config) {
        Supplier<ProfileFile> profileFile = config.get(SdkClientOption.PROFILE_FILE_SUPPLIER);
        String profileName = config.get(SdkClientOption.PROFILE_NAME);
        return DualstackEnabledProvider.builder().profileFile(profileFile).profileName(profileName).build().isDualstackEnabled().orElse(null);
    }

    private Set<String> resolveSigv4aSigningRegionSet(AttributeMap.LazyValueSource config) {
        Supplier<ProfileFile> profileFile = config.get(SdkClientOption.PROFILE_FILE_SUPPLIER);
        String profileName = config.get(SdkClientOption.PROFILE_NAME);
        return Sigv4aSigningRegionSetProvider.builder().profileFile(profileFile).profileName(profileName).build().resolveRegionSet();
    }

    private Boolean resolveFipsEndpointEnabled(AttributeMap.LazyValueSource config) {
        Supplier<ProfileFile> profileFile = config.get(SdkClientOption.PROFILE_FILE_SUPPLIER);
        String profileName = config.get(SdkClientOption.PROFILE_NAME);
        return FipsEnabledProvider.builder().profileFile(profileFile).profileName(profileName).build().isFipsEnabled().orElse(null);
    }

    private IdentityProvider<? extends AwsCredentialsIdentity> resolveCredentialsIdentityProvider(AttributeMap.LazyValueSource config) {
        return DefaultCredentialsProvider.builder().profileFile(config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(config.get(SdkClientOption.PROFILE_NAME)).build();
    }

    private AwsCredentialsProvider resolveCredentialsProvider(AttributeMap.LazyValueSource config) {
        return CredentialUtils.toCredentialsProvider(config.get(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER));
    }

    private void configureRetryPolicy(SdkClientConfiguration.Builder config) {
        RetryPolicy policy = config.option(SdkClientOption.RETRY_POLICY);
        if (policy != null && policy.additionalRetryConditionsAllowed()) {
            config.option(SdkClientOption.RETRY_POLICY, AwsRetryPolicy.addRetryConditions(policy));
        }
    }

    private void configureRetryStrategy(SdkClientConfiguration.Builder config) {
        RetryStrategy strategy = config.option(SdkClientOption.RETRY_STRATEGY);
        if (strategy == null) {
            config.lazyOption(SdkClientOption.RETRY_STRATEGY, this::resolveAwsRetryStrategy);
            return;
        }
        if (!strategy.useClientDefaults()) {
            return;
        }
        if (!(strategy instanceof DefaultAwareRetryStrategy)) {
            return;
        }
        DefaultAwareRetryStrategy defaultAwareRetryStrategy = (DefaultAwareRetryStrategy)strategy;
        defaultAwareRetryStrategy = defaultAwareRetryStrategy.addDefaults(AwsRetryStrategy.retryStrategyDefaults());
        defaultAwareRetryStrategy = defaultAwareRetryStrategy.addDefaults(SdkDefaultRetryStrategy.retryStrategyDefaults());
        RetryStrategy.Builder<?, ?> strategyBuilder = defaultAwareRetryStrategy.toBuilder();
        config.option(SdkClientOption.RETRY_STRATEGY, strategyBuilder.build());
    }

    private RetryStrategy resolveAwsRetryStrategy(AttributeMap.LazyValueSource config) {
        RetryMode retryMode = RetryMode.resolver().profileFile(config.get(SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName(config.get(SdkClientOption.PROFILE_NAME)).defaultRetryMode(config.get(SdkClientOption.DEFAULT_RETRY_MODE)).resolve();
        return AwsRetryStrategy.forRetryMode(retryMode);
    }

    @Override
    public final BuilderT region(Region region) {
        Region regionToSet = region;
        Boolean fipsEnabled = null;
        if (region != null) {
            Pair<Region, Optional<Boolean>> transformedRegion = AwsDefaultClientBuilder.transformFipsPseudoRegionIfNecessary(region);
            regionToSet = transformedRegion.left();
            fipsEnabled = transformedRegion.right().orElse(null);
        }
        this.clientConfiguration.option(AwsClientOption.AWS_REGION, regionToSet);
        if (fipsEnabled != null) {
            this.clientConfiguration.option(AwsClientOption.FIPS_ENDPOINT_ENABLED, fipsEnabled);
        }
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setRegion(Region region) {
        this.region(region);
    }

    @Override
    public BuilderT dualstackEnabled(Boolean dualstackEndpointEnabled) {
        this.clientConfiguration.option(AwsClientOption.DUALSTACK_ENDPOINT_ENABLED, dualstackEndpointEnabled);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setDualstackEnabled(Boolean dualstackEndpointEnabled) {
        this.dualstackEnabled(dualstackEndpointEnabled);
    }

    @Override
    public BuilderT fipsEnabled(Boolean dualstackEndpointEnabled) {
        this.clientConfiguration.option(AwsClientOption.FIPS_ENDPOINT_ENABLED, dualstackEndpointEnabled);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setFipsEnabled(Boolean fipsEndpointEnabled) {
        this.fipsEnabled(fipsEndpointEnabled);
    }

    public final void setCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider(credentialsProvider);
    }

    @Override
    public final BuilderT credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> identityProvider) {
        this.clientConfiguration.option(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, identityProvider);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setCredentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> identityProvider) {
        this.credentialsProvider(identityProvider);
    }

    private List<ExecutionInterceptor> addAwsInterceptors(SdkClientConfiguration config) {
        List<ExecutionInterceptor> interceptors = this.awsInterceptors();
        interceptors = CollectionUtils.mergeLists(interceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        return interceptors;
    }

    private List<ExecutionInterceptor> awsInterceptors() {
        return Arrays.asList(new HelpfulUnknownHostExceptionInterceptor(), new EventStreamInitialRequestInterceptor(), new TraceIdExecutionInterceptor());
    }

    @Override
    public final BuilderT defaultsMode(DefaultsMode defaultsMode) {
        this.clientConfiguration.option(AwsClientOption.CONFIGURED_DEFAULTS_MODE, defaultsMode);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setDefaultsMode(DefaultsMode defaultsMode) {
        this.defaultsMode(defaultsMode);
    }

    private static Pair<Region, Optional<Boolean>> transformFipsPseudoRegionIfNecessary(Region region) {
        String id = region.id();
        String newId = StringUtils.replaceEach(id, FIPS_SEARCH, FIPS_REPLACE);
        if (!newId.equals(id)) {
            log.info(() -> String.format("Replacing input region %s with %s and setting fipsEnabled to true", id, newId));
            return Pair.of(Region.of(newId), Optional.of(true));
        }
        return Pair.of(region, Optional.empty());
    }
}

