/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.checksums;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkProtectedApi
public class ChecksumSpecs
implements ToCopyableBuilder<Builder, ChecksumSpecs> {
    private final ChecksumAlgorithm algorithm;
    private final String headerName;
    private final List<ChecksumAlgorithm> responseValidationAlgorithms;
    private final boolean isValidationEnabled;
    private final boolean isRequestChecksumRequired;
    private final boolean isRequestStreaming;
    private final String requestAlgorithmHeader;

    private ChecksumSpecs(Builder builder) {
        this.algorithm = builder.algorithm;
        this.headerName = builder.headerName;
        this.responseValidationAlgorithms = builder.responseValidationAlgorithms;
        this.isValidationEnabled = builder.isValidationEnabled;
        this.isRequestChecksumRequired = builder.isRequestChecksumRequired;
        this.isRequestStreaming = builder.isRequestStreaming;
        this.requestAlgorithmHeader = builder.requestAlgorithmHeader;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public Algorithm algorithm() {
        return HttpChecksumUtils.toLegacyChecksumAlgorithm(this.algorithm);
    }

    public ChecksumAlgorithm algorithmV2() {
        return this.algorithm;
    }

    public String headerName() {
        return this.headerName;
    }

    public boolean isRequestStreaming() {
        return this.isRequestStreaming;
    }

    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    public boolean isRequestChecksumRequired() {
        return this.isRequestChecksumRequired;
    }

    public String requestAlgorithmHeader() {
        return this.requestAlgorithmHeader;
    }

    @Deprecated
    public List<Algorithm> responseValidationAlgorithms() {
        return this.responseValidationAlgorithms == null ? null : this.responseValidationAlgorithms.stream().map(algo -> HttpChecksumUtils.toLegacyChecksumAlgorithm(algo)).collect(Collectors.toList());
    }

    public List<ChecksumAlgorithm> responseValidationAlgorithmsV2() {
        return this.responseValidationAlgorithms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChecksumSpecs)) {
            return false;
        }
        ChecksumSpecs checksum = (ChecksumSpecs)o;
        return this.algorithm() == checksum.algorithm() && this.isRequestStreaming() == checksum.isRequestStreaming() && Objects.equals(this.headerName(), checksum.headerName()) && Objects.equals(this.responseValidationAlgorithms(), checksum.responseValidationAlgorithms()) && Objects.equals(this.isValidationEnabled(), checksum.isValidationEnabled()) && Objects.equals(this.requestAlgorithmHeader(), checksum.requestAlgorithmHeader()) && Objects.equals(this.isRequestChecksumRequired(), checksum.isRequestChecksumRequired());
    }

    public int hashCode() {
        int result = this.algorithm != null ? this.algorithm.hashCode() : 0;
        result = 31 * result + (this.headerName != null ? this.headerName.hashCode() : 0);
        result = 31 * result + (this.responseValidationAlgorithms != null ? this.responseValidationAlgorithms.hashCode() : 0);
        result = 31 * result + (this.isValidationEnabled ? 1 : 0);
        result = 31 * result + (this.isRequestChecksumRequired ? 1 : 0);
        result = 31 * result + (this.isRequestStreaming ? 1 : 0);
        result = 31 * result + (this.requestAlgorithmHeader != null ? this.requestAlgorithmHeader.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ChecksumSpecs{algorithm=" + this.algorithm + ", headerName='" + this.headerName + '\'' + ", responseValidationAlgorithms=" + this.responseValidationAlgorithms + ", isValidationEnabled=" + this.isValidationEnabled + ", isRequestChecksumRequired=" + this.isRequestChecksumRequired + ", isStreamingData=" + this.isRequestStreaming + ", requestAlgorithmHeader='" + this.requestAlgorithmHeader + '\'' + '}';
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    implements CopyableBuilder<Builder, ChecksumSpecs> {
        private String requestAlgorithmHeader;
        private ChecksumAlgorithm algorithm;
        private String headerName;
        private List<ChecksumAlgorithm> responseValidationAlgorithms;
        private boolean isValidationEnabled;
        private boolean isRequestChecksumRequired;
        private boolean isRequestStreaming;

        private Builder() {
        }

        private Builder(ChecksumSpecs checksumSpecs) {
            this.algorithm = checksumSpecs.algorithm;
            this.headerName = checksumSpecs.headerName;
            this.responseValidationAlgorithms = checksumSpecs.responseValidationAlgorithms;
            this.isValidationEnabled = checksumSpecs.isValidationEnabled;
            this.isRequestChecksumRequired = checksumSpecs.isRequestChecksumRequired;
            this.isRequestStreaming = checksumSpecs.isRequestStreaming;
            this.requestAlgorithmHeader = checksumSpecs.requestAlgorithmHeader;
        }

        @Deprecated
        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = HttpChecksumUtils.toNewChecksumAlgorithm(algorithm);
            return this;
        }

        public Builder algorithmV2(ChecksumAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        @Deprecated
        public Builder responseValidationAlgorithms(List<Algorithm> responseValidationAlgorithms) {
            this.responseValidationAlgorithms = responseValidationAlgorithms == null ? null : Collections.unmodifiableList(responseValidationAlgorithms.stream().map(algorithm -> HttpChecksumUtils.toNewChecksumAlgorithm(algorithm)).collect(Collectors.toList()));
            return this;
        }

        public Builder responseValidationAlgorithmsV2(List<ChecksumAlgorithm> responseValidationAlgorithms) {
            this.responseValidationAlgorithms = responseValidationAlgorithms != null ? Collections.unmodifiableList(responseValidationAlgorithms) : null;
            return this;
        }

        public Builder isValidationEnabled(boolean isValidationEnabled) {
            this.isValidationEnabled = isValidationEnabled;
            return this;
        }

        public Builder isRequestChecksumRequired(boolean isRequestChecksumRequired) {
            this.isRequestChecksumRequired = isRequestChecksumRequired;
            return this;
        }

        public Builder isRequestStreaming(boolean isRequestStreaming) {
            this.isRequestStreaming = isRequestStreaming;
            return this;
        }

        public Builder requestAlgorithmHeader(String requestAlgorithmHeader) {
            this.requestAlgorithmHeader = requestAlgorithmHeader;
            return this;
        }

        @Override
        public ChecksumSpecs build() {
            return new ChecksumSpecs(this);
        }
    }
}

