/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.interceptor.trait;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;

@SdkProtectedApi
public class HttpChecksum {
    private final boolean requestChecksumRequired;
    private final String requestAlgorithm;
    private final String requestAlgorithmHeader;
    private final String requestValidationMode;
    private final boolean isRequestStreaming;
    private final List<ChecksumAlgorithm> responseAlgorithms;

    private HttpChecksum(Builder builder) {
        this.requestChecksumRequired = builder.requestChecksumRequired;
        this.requestAlgorithm = builder.requestAlgorithm;
        this.requestValidationMode = builder.requestValidationMode;
        this.responseAlgorithms = builder.responseAlgorithms;
        this.isRequestStreaming = builder.isRequestStreaming;
        this.requestAlgorithmHeader = builder.requestAlgorithmHeader;
    }

    public boolean isRequestChecksumRequired() {
        return this.requestChecksumRequired;
    }

    public String requestAlgorithm() {
        return this.requestAlgorithm;
    }

    public String requestAlgorithmHeader() {
        return this.requestAlgorithmHeader;
    }

    @Deprecated
    public List<String> responseAlgorithms() {
        if (this.responseAlgorithms == null) {
            return null;
        }
        return this.responseAlgorithms.stream().map(ChecksumAlgorithm::algorithmId).collect(Collectors.toList());
    }

    public List<ChecksumAlgorithm> responseAlgorithmsV2() {
        return this.responseAlgorithms;
    }

    public String requestValidationMode() {
        return this.requestValidationMode;
    }

    public boolean isRequestStreaming() {
        return this.isRequestStreaming;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpChecksum that = (HttpChecksum)o;
        return this.requestChecksumRequired == that.requestChecksumRequired && this.isRequestStreaming == that.isRequestStreaming && Objects.equals(this.requestAlgorithm, that.requestAlgorithm) && Objects.equals(this.requestValidationMode, that.requestValidationMode) && Objects.equals(this.responseAlgorithms, that.responseAlgorithms);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.requestChecksumRequired ? 1 : 0);
        hashCode = 31 * hashCode + (this.isRequestStreaming ? 1 : 0);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestAlgorithm);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestValidationMode);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseAlgorithms);
        return hashCode;
    }

    public static final class Builder {
        private boolean requestChecksumRequired;
        private String requestAlgorithm;
        private String requestValidationMode;
        private List<ChecksumAlgorithm> responseAlgorithms;
        private boolean isRequestStreaming;
        private String requestAlgorithmHeader;

        public Builder requestChecksumRequired(boolean requestChecksumRequired) {
            this.requestChecksumRequired = requestChecksumRequired;
            return this;
        }

        public Builder requestAlgorithm(String requestAlgorithm) {
            this.requestAlgorithm = requestAlgorithm;
            return this;
        }

        public Builder requestAlgorithmHeader(String requestAlgorithmHeader) {
            this.requestAlgorithmHeader = requestAlgorithmHeader;
            return this;
        }

        public Builder requestValidationMode(String requestValidationMode) {
            this.requestValidationMode = requestValidationMode;
            return this;
        }

        @Deprecated
        public Builder responseAlgorithms(List<String> responseAlgorithms) {
            this.responseAlgorithms = responseAlgorithms.stream().map(algo -> DefaultChecksumAlgorithm.fromValue(algo)).collect(Collectors.toList());
            return this;
        }

        @Deprecated
        public Builder responseAlgorithms(String ... responseAlgorithms) {
            if (responseAlgorithms != null) {
                return this.responseAlgorithms(Arrays.asList(responseAlgorithms));
            }
            return this;
        }

        public Builder responseAlgorithmsV2(ChecksumAlgorithm ... responseAlgorithms) {
            if (responseAlgorithms != null) {
                this.responseAlgorithms = Arrays.asList(responseAlgorithms);
            }
            return this;
        }

        public Builder isRequestStreaming(boolean isRequestStreaming) {
            this.isRequestStreaming = isRequestStreaming;
            return this;
        }

        public HttpChecksum build() {
            return new HttpChecksum(this);
        }
    }
}

