/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class SubAsyncRequestBodyConfiguration {
    private final boolean contentLengthKnown;
    private final long maxLength;
    private final int partNumber;
    private final Consumer<Long> onNumBytesReceived;
    private final Consumer<Long> onNumBytesConsumed;
    private final String sourceBodyName;

    private SubAsyncRequestBodyConfiguration(Builder builder) {
        this.contentLengthKnown = Validate.paramNotNull(builder.contentLengthKnown, "contentLengthKnown");
        this.maxLength = Validate.paramNotNull(builder.maxLength, "maxLength");
        this.partNumber = Validate.paramNotNull(builder.partNumber, "partNumber");
        this.onNumBytesReceived = Validate.paramNotNull(builder.onNumBytesReceived, "onNumBytesReceived");
        this.onNumBytesConsumed = Validate.paramNotNull(builder.onNumBytesConsumed, "onNumBytesConsumed");
        this.sourceBodyName = Validate.paramNotNull(builder.sourceBodyName, "sourceBodyName");
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contentLengthKnown() {
        return this.contentLengthKnown;
    }

    public long maxLength() {
        return this.maxLength;
    }

    public int partNumber() {
        return this.partNumber;
    }

    public Consumer<Long> onNumBytesReceived() {
        return this.onNumBytesReceived;
    }

    public Consumer<Long> onNumBytesConsumed() {
        return this.onNumBytesConsumed;
    }

    public String sourceBodyName() {
        return this.sourceBodyName;
    }

    public static final class Builder {
        private Boolean contentLengthKnown;
        private Long maxLength;
        private Integer partNumber;
        private Consumer<Long> onNumBytesReceived;
        private Consumer<Long> onNumBytesConsumed;
        private String sourceBodyName;

        private Builder() {
        }

        public Builder contentLengthKnown(Boolean contentLengthKnown) {
            this.contentLengthKnown = contentLengthKnown;
            return this;
        }

        public Builder maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public Builder onNumBytesReceived(Consumer<Long> onNumBytesReceived) {
            this.onNumBytesReceived = onNumBytesReceived;
            return this;
        }

        public Builder onNumBytesConsumed(Consumer<Long> onNumBytesConsumed) {
            this.onNumBytesConsumed = onNumBytesConsumed;
            return this;
        }

        public Builder sourceBodyName(String sourceBodyName) {
            this.sourceBodyName = sourceBodyName;
            return this;
        }

        public SubAsyncRequestBodyConfiguration build() {
            return new SubAsyncRequestBodyConfiguration(this);
        }
    }
}

