/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.internal.signer.Checksummer;
import software.amazon.awssdk.http.auth.aws.internal.signer.checksums.ConstantChecksum;
import software.amazon.awssdk.http.auth.aws.internal.signer.util.CredentialUtils;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.BaseSignRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class ChecksumUtil {
    private static final Logger log = Logger.loggerFor(ChecksumUtil.class);
    private static final String CONSTANT_CHECKSUM = "CONSTANT";

    private ChecksumUtil() {
    }

    public static String checksumHeaderName(ChecksumAlgorithm checksumAlgorithm) {
        return "x-amz-checksum-" + checksumAlgorithm.algorithmId().toLowerCase(Locale.US);
    }

    public static SdkChecksum fromChecksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
        String algorithmId = checksumAlgorithm.algorithmId();
        if (CONSTANT_CHECKSUM.equals(algorithmId)) {
            return new ConstantChecksum(((ConstantChecksumAlgorithm)checksumAlgorithm).value);
        }
        SdkChecksum checksum = SdkChecksum.forAlgorithm(checksumAlgorithm);
        if (checksum != null) {
            return checksum;
        }
        throw new UnsupportedOperationException("Checksum not supported for " + algorithmId);
    }

    public static void readAll(InputStream inputStream) {
        FunctionalUtils.invokeSafely(() -> {
            byte[] buffer = new byte[4096];
            while (inputStream.read(buffer) > -1) {
            }
        });
    }

    public static byte[] longToByte(Long input) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(input);
        return buffer.array();
    }

    public static boolean hasChecksumHeader(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request) {
        ChecksumAlgorithm checksumAlgorithm = request.property(AwsV4FamilyHttpSigner.CHECKSUM_ALGORITHM);
        if (checksumAlgorithm != null) {
            String checksumHeaderName = ChecksumUtil.checksumHeaderName(checksumAlgorithm);
            return request.request().firstMatchingHeader(checksumHeaderName).isPresent();
        }
        return false;
    }

    public static boolean useChunkEncoding(boolean payloadSigningEnabled, boolean chunkEncodingEnabled, boolean isTrailingOrFlexible) {
        return payloadSigningEnabled && chunkEncodingEnabled || chunkEncodingEnabled && isTrailingOrFlexible;
    }

    public static boolean isPayloadSigning(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request) {
        boolean isAnonymous = CredentialUtils.isAnonymous(request.identity());
        boolean isPayloadSigningEnabled = request.requireProperty(AwsV4FamilyHttpSigner.PAYLOAD_SIGNING_ENABLED, true);
        boolean isEncrypted = "https".equals(request.request().protocol());
        if (isAnonymous) {
            return false;
        }
        if (!isEncrypted && request.payload().isPresent()) {
            if (!isPayloadSigningEnabled) {
                log.debug(() -> "Payload signing was disabled for an HTTP request with a payload. Signing will be enabled. Use HTTPS for unsigned payloads.");
            }
            return true;
        }
        return isPayloadSigningEnabled;
    }

    public static boolean isEventStreaming(SdkHttpRequest request) {
        return "application/vnd.amazon.eventstream".equals(request.firstMatchingHeader("Content-Type").orElse(""));
    }

    public static Checksummer checksummer(BaseSignRequest<?, ? extends AwsCredentialsIdentity> request, Boolean isPayloadSigningOverride) {
        boolean isPayloadSigning = isPayloadSigningOverride != null ? isPayloadSigningOverride : ChecksumUtil.isPayloadSigning(request);
        boolean isEventStreaming = ChecksumUtil.isEventStreaming(request.request());
        boolean hasChecksumHeader = ChecksumUtil.hasChecksumHeader(request);
        boolean isChunkEncoding = request.requireProperty(AwsV4FamilyHttpSigner.CHUNK_ENCODING_ENABLED, false);
        boolean isTrailing = request.request().firstMatchingHeader("x-amz-trailer").isPresent();
        boolean isFlexible = request.hasProperty(AwsV4FamilyHttpSigner.CHECKSUM_ALGORITHM) && !hasChecksumHeader;
        boolean isAnonymous = CredentialUtils.isAnonymous(request.identity());
        if (isEventStreaming) {
            return Checksummer.forPrecomputed256Checksum("STREAMING-AWS4-HMAC-SHA256-EVENTS");
        }
        if (isPayloadSigning) {
            if (isChunkEncoding) {
                if (isFlexible || isTrailing) {
                    return Checksummer.forPrecomputed256Checksum("STREAMING-AWS4-HMAC-SHA256-PAYLOAD-TRAILER");
                }
                return Checksummer.forPrecomputed256Checksum("STREAMING-AWS4-HMAC-SHA256-PAYLOAD");
            }
            if (isFlexible) {
                return Checksummer.forFlexibleChecksum(request.property(AwsV4FamilyHttpSigner.CHECKSUM_ALGORITHM));
            }
            return Checksummer.create();
        }
        if ((isFlexible || isTrailing) && isChunkEncoding) {
            return Checksummer.forPrecomputed256Checksum("STREAMING-UNSIGNED-PAYLOAD-TRAILER");
        }
        if (isFlexible) {
            return Checksummer.forFlexibleChecksum("UNSIGNED-PAYLOAD", request.property(AwsV4FamilyHttpSigner.CHECKSUM_ALGORITHM));
        }
        if (isAnonymous) {
            return Checksummer.forNoOp();
        }
        return Checksummer.forPrecomputed256Checksum("UNSIGNED-PAYLOAD");
    }

    public static class ConstantChecksumAlgorithm
    implements ChecksumAlgorithm {
        private final String value;

        public ConstantChecksumAlgorithm(String value) {
            this.value = value;
        }

        @Override
        public String algorithmId() {
            return ChecksumUtil.CONSTANT_CHECKSUM;
        }
    }
}

