/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.unmarshall;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.TraitType;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.protocols.core.StringToInstant;
import software.amazon.awssdk.protocols.core.StringToValueConverter;
import software.amazon.awssdk.protocols.json.internal.AwsStructuredPlainJsonFactory;
import software.amazon.awssdk.protocols.json.internal.MarshallerUtil;
import software.amazon.awssdk.protocols.json.internal.unmarshall.DefaultJsonUnmarshallerRegistry;
import software.amazon.awssdk.protocols.json.internal.unmarshall.DefaultProtocolUnmarshallDependencies;
import software.amazon.awssdk.protocols.json.internal.unmarshall.HeaderUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerContext;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerRegistry;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallingParser;
import software.amazon.awssdk.protocols.json.internal.unmarshall.ProtocolUnmarshallDependencies;
import software.amazon.awssdk.protocols.json.internal.unmarshall.document.DocumentUnmarshaller;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonValueNodeFactory;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.builder.Buildable;

@SdkInternalApi
@ThreadSafe
public class JsonProtocolUnmarshaller {
    private static final Lazy<DefaultProtocolUnmarshallDependencies> DEFAULT_DEPENDENCIES = new Lazy<DefaultProtocolUnmarshallDependencies>(JsonProtocolUnmarshaller::newProtocolUnmarshallDependencies);
    private final JsonUnmarshallerRegistry registry;
    private final JsonUnmarshallingParser unmarshallingParser;
    private final JsonNodeParser parser;

    private JsonProtocolUnmarshaller(Builder builder) {
        ProtocolUnmarshallDependencies dependencies = builder.protocolUnmarshallDependencies;
        this.registry = dependencies.jsonUnmarshallerRegistry();
        if (builder.enableFastUnmarshalling) {
            this.unmarshallingParser = JsonUnmarshallingParser.builder().jsonValueNodeFactory(dependencies.nodeValueFactory()).jsonFactory(dependencies.jsonFactory()).unmarshallerRegistry(dependencies.jsonUnmarshallerRegistry()).defaultTimestampFormat(dependencies.timestampFormats().get((Object)MarshallLocation.PAYLOAD)).build();
            this.parser = null;
        } else {
            this.unmarshallingParser = null;
            this.parser = this.createParser(builder, dependencies);
        }
    }

    private JsonNodeParser createParser(Builder builder, ProtocolUnmarshallDependencies dependencies) {
        if (builder.parser != null) {
            return builder.parser;
        }
        return JsonNodeParser.builder().jsonFactory(dependencies.jsonFactory()).jsonValueNodeFactory(dependencies.nodeValueFactory()).build();
    }

    public static DefaultProtocolUnmarshallDependencies defaultProtocolUnmarshallDependencies() {
        return DEFAULT_DEPENDENCIES.getValue();
    }

    public static DefaultProtocolUnmarshallDependencies newProtocolUnmarshallDependencies() {
        return DefaultProtocolUnmarshallDependencies.builder().jsonUnmarshallerRegistry(JsonProtocolUnmarshaller.defaultJsonUnmarshallerRegistry()).nodeValueFactory(JsonValueNodeFactory.DEFAULT).timestampFormats(JsonProtocolUnmarshaller.defaultFormats()).jsonFactory(AwsStructuredPlainJsonFactory.SDK_JSON_FACTORY.getJsonFactory()).build();
    }

    private static Map<MarshallLocation, TimestampFormatTrait.Format> defaultFormats() {
        EnumMap<MarshallLocation, TimestampFormatTrait.Format> formats = new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class);
        formats.put(MarshallLocation.HEADER, TimestampFormatTrait.Format.RFC_822);
        formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.UNIX_TIMESTAMP);
        return Collections.unmodifiableMap(formats);
    }

    private static JsonUnmarshallerRegistry defaultJsonUnmarshallerRegistry() {
        return JsonProtocolUnmarshaller.timestampFormatRegistryFactory(JsonProtocolUnmarshaller.defaultFormats());
    }

    public static DefaultJsonUnmarshallerRegistry createSharedRegistry() {
        return DefaultJsonUnmarshallerRegistry.builder().statusCodeUnmarshaller(MarshallingType.INTEGER, (context, json, f) -> context.response().statusCode()).headerUnmarshaller(MarshallingType.STRING, HeaderUnmarshaller.STRING).headerUnmarshaller(MarshallingType.INTEGER, HeaderUnmarshaller.INTEGER).headerUnmarshaller(MarshallingType.LONG, HeaderUnmarshaller.LONG).headerUnmarshaller(MarshallingType.SHORT, HeaderUnmarshaller.SHORT).headerUnmarshaller(MarshallingType.DOUBLE, HeaderUnmarshaller.DOUBLE).headerUnmarshaller(MarshallingType.BOOLEAN, HeaderUnmarshaller.BOOLEAN).headerUnmarshaller(MarshallingType.FLOAT, HeaderUnmarshaller.FLOAT).headerUnmarshaller(MarshallingType.LIST, HeaderUnmarshaller.LIST).payloadUnmarshaller(MarshallingType.STRING, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_STRING)).payloadUnmarshaller(MarshallingType.INTEGER, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_INTEGER)).payloadUnmarshaller(MarshallingType.LONG, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_LONG)).payloadUnmarshaller(MarshallingType.BYTE, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_BYTE)).payloadUnmarshaller(MarshallingType.SHORT, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_SHORT)).payloadUnmarshaller(MarshallingType.FLOAT, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_FLOAT)).payloadUnmarshaller(MarshallingType.DOUBLE, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_DOUBLE)).payloadUnmarshaller(MarshallingType.BIG_DECIMAL, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_BIG_DECIMAL)).payloadUnmarshaller(MarshallingType.BOOLEAN, new SimpleTypeJsonUnmarshaller(StringToValueConverter.TO_BOOLEAN)).payloadUnmarshaller(MarshallingType.SDK_BYTES, JsonProtocolUnmarshaller::unmarshallSdkBytes).payloadUnmarshaller(MarshallingType.SDK_POJO, JsonProtocolUnmarshaller::unmarshallStructured).payloadUnmarshaller(MarshallingType.LIST, JsonProtocolUnmarshaller::unmarshallList).payloadUnmarshaller(MarshallingType.MAP, JsonProtocolUnmarshaller::unmarshallMap).payloadUnmarshaller(MarshallingType.DOCUMENT, JsonProtocolUnmarshaller::unmarshallDocument).build();
    }

    private static SdkBytes unmarshallSdkBytes(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<SdkBytes> field) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        if (jsonContent.isEmbeddedObject()) {
            return SdkBytes.fromByteArray((byte[])jsonContent.asEmbeddedObject());
        }
        return StringToValueConverter.TO_SDK_BYTES.convert(jsonContent.text(), field);
    }

    private static SdkPojo unmarshallStructured(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<SdkPojo> f) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        return JsonProtocolUnmarshaller.unmarshallStructured(f.constructor().get(), jsonContent, context);
    }

    private static Document unmarshallDocument(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<Document> field) {
        if (jsonContent == null) {
            return null;
        }
        return jsonContent.isNull() ? Document.fromNull() : JsonProtocolUnmarshaller.getDocumentFromJsonContent(jsonContent);
    }

    private static Document getDocumentFromJsonContent(JsonNode jsonContent) {
        return jsonContent.visit(new DocumentUnmarshaller());
    }

    private static Map<String, ?> unmarshallMap(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<Map<String, ?>> field) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        SdkField valueInfo = field.getTrait(MapTrait.class, TraitType.MAP_TRAIT).valueFieldInfo();
        JsonUnmarshaller<Object> unmarshaller = context.getUnmarshaller(valueInfo.location(), valueInfo.marshallingType());
        Map<String, JsonNode> asObject = jsonContent.asObject();
        HashMap<String, Object> map = new HashMap<String, Object>(asObject.size());
        for (Map.Entry<String, JsonNode> kvp : asObject.entrySet()) {
            map.put(kvp.getKey(), unmarshaller.unmarshall(context, kvp.getValue(), valueInfo));
        }
        return map;
    }

    private static List<?> unmarshallList(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<List<?>> field) {
        if (jsonContent == null || jsonContent.isNull()) {
            return null;
        }
        SdkField memberInfo = field.getTrait(ListTrait.class, TraitType.LIST_TRAIT).memberFieldInfo();
        List<JsonNode> asArray = jsonContent.asArray();
        ArrayList<Object> result = new ArrayList<Object>(asArray.size());
        for (JsonNode node : asArray) {
            JsonUnmarshaller<Object> unmarshaller = context.getUnmarshaller(memberInfo.location(), memberInfo.marshallingType());
            result.add(unmarshaller.unmarshall(context, node, memberInfo));
        }
        return result;
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response) throws IOException {
        if (this.unmarshallingParser != null) {
            return this.fastUnmarshall(sdkPojo, response);
        }
        JsonNode jsonNode = this.hasJsonPayload(sdkPojo, response) ? this.parser.parse(response.content().get()) : null;
        return this.unmarshall(sdkPojo, response, jsonNode);
    }

    private <TypeT extends SdkPojo> TypeT fastUnmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response) throws IOException {
        if (!this.hasJsonPayload(sdkPojo, response)) {
            return this.unmarshallResponse(sdkPojo, response);
        }
        if (this.hasExplicitJsonPayloadMember(sdkPojo)) {
            return this.unmarshallResponse(sdkPojo, response);
        }
        if (this.hasMixedLocations(sdkPojo)) {
            this.unmarshallFromJson(sdkPojo, response.content().get());
            return this.unmarshallResponse(sdkPojo, response);
        }
        return (TypeT)this.unmarshallFromJson(sdkPojo, response.content().get());
    }

    private <T extends SdkPojo> T unmarshallFromJson(SdkPojo sdkPojo, InputStream inputStream) {
        return (T)this.unmarshallingParser.parse(sdkPojo, inputStream);
    }

    private <T extends SdkPojo> T unmarshallMemberFromJson(Supplier<SdkPojo> constructor, InputStream inputStream) {
        return (T)this.unmarshallingParser.parseMember(constructor, inputStream);
    }

    private <TypeT extends SdkPojo> TypeT unmarshallResponse(SdkPojo sdkPojo, SdkHttpFullResponse response) throws IOException {
        JsonUnmarshallerContext context = JsonUnmarshallerContext.builder().unmarshallerRegistry(this.registry).response(response).build();
        for (SdkField<?> field : sdkPojo.sdkFields()) {
            Optional<AbortableInputStream> responseContent;
            if (JsonProtocolUnmarshaller.isExplicitPayloadMember(field) && field.marshallingType() == MarshallingType.SDK_BYTES) {
                responseContent = context.response().content();
                if (responseContent.isPresent()) {
                    field.set(sdkPojo, SdkBytes.fromInputStream(responseContent.get()));
                    continue;
                }
                field.set(sdkPojo, SdkBytes.fromByteArrayUnsafe(new byte[0]));
                continue;
            }
            if (JsonProtocolUnmarshaller.isExplicitPayloadMember(field) && field.marshallingType() == MarshallingType.STRING) {
                responseContent = context.response().content();
                if (responseContent.isPresent()) {
                    field.set(sdkPojo, SdkBytes.fromInputStream(responseContent.get()).asUtf8String());
                    continue;
                }
                field.set(sdkPojo, "");
                continue;
            }
            if (JsonProtocolUnmarshaller.isExplicitPayloadMember(field) && field.marshallingType() == MarshallingType.SDK_POJO) {
                responseContent = context.response().content();
                if (responseContent.isPresent()) {
                    field.set(sdkPojo, this.unmarshallMemberFromJson(field.constructor(), responseContent.get()));
                    continue;
                }
                field.set(sdkPojo, null);
                continue;
            }
            if (this.isPayloadUnmarshalling(field.location())) continue;
            JsonUnmarshaller<Object> unmarshaller = context.getUnmarshaller(field.location(), field.marshallingType());
            field.set(sdkPojo, unmarshaller.unmarshall(context, null, field));
        }
        return (TypeT)((SdkPojo)((Buildable)((Object)sdkPojo)).build());
    }

    private boolean hasJsonPayload(SdkPojo sdkPojo, SdkHttpFullResponse response) {
        if (!response.content().isPresent()) {
            return false;
        }
        for (SdkField<?> field : sdkPojo.sdkFields()) {
            if (!this.isPayloadMemberOnUnmarshall(field) || this.isExplicitBlobPayloadMember(field) || this.isExplicitStringPayloadMember(field)) continue;
            return true;
        }
        return false;
    }

    private boolean hasExplicitJsonPayloadMember(SdkPojo sdkPojo) {
        for (SdkField<?> field : sdkPojo.sdkFields()) {
            if (!this.isExplicitSdkPojoPayloadMember(field)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMixedLocations(SdkPojo sdkPojo) {
        int payload = 0;
        int header = 0;
        int statusCode = 0;
        for (SdkField<?> field : sdkPojo.sdkFields()) {
            MarshallLocation location = field.location();
            if (this.isPayloadUnmarshalling(location)) {
                payload = 1;
                continue;
            }
            if (location == MarshallLocation.HEADER) {
                header = 1;
                continue;
            }
            if (location != MarshallLocation.STATUS_CODE) continue;
            statusCode = 1;
        }
        return payload + header + statusCode > 1;
    }

    private boolean isPayloadUnmarshalling(MarshallLocation location) {
        switch (location) {
            case PAYLOAD: 
            case PATH: 
            case QUERY_PARAM: 
            case GREEDY_PATH: {
                return true;
            }
        }
        return false;
    }

    private boolean isExplicitBlobPayloadMember(SdkField<?> f) {
        return JsonProtocolUnmarshaller.isExplicitPayloadMember(f) && f.marshallingType() == MarshallingType.SDK_BYTES;
    }

    private boolean isExplicitStringPayloadMember(SdkField<?> f) {
        return JsonProtocolUnmarshaller.isExplicitPayloadMember(f) && f.marshallingType() == MarshallingType.STRING;
    }

    private boolean isExplicitSdkPojoPayloadMember(SdkField<?> f) {
        return JsonProtocolUnmarshaller.isExplicitPayloadMember(f) && f.marshallingType() == MarshallingType.SDK_POJO;
    }

    private static boolean isExplicitPayloadMember(SdkField<?> f) {
        return f.containsTrait(PayloadTrait.class, TraitType.PAYLOAD_TRAIT);
    }

    private boolean isPayloadMemberOnUnmarshall(SdkField<?> f) {
        return f.location() == MarshallLocation.PAYLOAD || MarshallerUtil.isInUri(f.location());
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response, JsonNode jsonContent) {
        JsonUnmarshallerContext context = JsonUnmarshallerContext.builder().unmarshallerRegistry(this.registry).response(response).build();
        return JsonProtocolUnmarshaller.unmarshallStructured(sdkPojo, jsonContent, context);
    }

    private static <TypeT extends SdkPojo> TypeT unmarshallStructured(SdkPojo sdkPojo, JsonNode jsonContent, JsonUnmarshallerContext context) {
        for (SdkField<?> field : sdkPojo.sdkFields()) {
            Optional<AbortableInputStream> responseContent;
            if (JsonProtocolUnmarshaller.isExplicitPayloadMember(field) && field.marshallingType() == MarshallingType.SDK_BYTES) {
                responseContent = context.response().content();
                if (responseContent.isPresent()) {
                    field.set(sdkPojo, SdkBytes.fromInputStream(responseContent.get()));
                    continue;
                }
                field.set(sdkPojo, SdkBytes.fromByteArrayUnsafe(new byte[0]));
                continue;
            }
            if (JsonProtocolUnmarshaller.isExplicitPayloadMember(field) && field.marshallingType() == MarshallingType.STRING) {
                responseContent = context.response().content();
                if (responseContent.isPresent()) {
                    field.set(sdkPojo, SdkBytes.fromInputStream(responseContent.get()).asUtf8String());
                    continue;
                }
                field.set(sdkPojo, "");
                continue;
            }
            JsonNode jsonFieldContent = JsonProtocolUnmarshaller.getJsonNode(jsonContent, field);
            JsonUnmarshaller<Object> unmarshaller = context.getUnmarshaller(field.location(), field.marshallingType());
            field.set(sdkPojo, unmarshaller.unmarshall(context, jsonFieldContent, field));
        }
        return (TypeT)((SdkPojo)((Buildable)((Object)sdkPojo)).build());
    }

    private static JsonNode getJsonNode(JsonNode jsonContent, SdkField<?> field) {
        if (jsonContent == null) {
            return null;
        }
        return JsonProtocolUnmarshaller.isFieldExplicitlyTransferredAsJson(field) ? jsonContent : (JsonNode)jsonContent.field(field.locationName()).orElse(null);
    }

    private static boolean isFieldExplicitlyTransferredAsJson(SdkField<?> field) {
        return JsonProtocolUnmarshaller.isExplicitPayloadMember(field) && !MarshallingType.DOCUMENT.equals(field.marshallingType());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JsonUnmarshallerRegistry timestampFormatRegistryFactory(Map<MarshallLocation, TimestampFormatTrait.Format> formats) {
        StringToInstant instantStringToValue = StringToInstant.create(formats.isEmpty() ? new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class) : new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(formats));
        return JsonProtocolUnmarshaller.createSharedRegistry().toBuilder().headerUnmarshaller(MarshallingType.INSTANT, HeaderUnmarshaller.createInstantHeaderUnmarshaller(instantStringToValue)).payloadUnmarshaller(MarshallingType.INSTANT, new SimpleTypeJsonUnmarshaller(instantStringToValue)).build();
    }

    public static final class Builder {
        private JsonNodeParser parser;
        private ProtocolUnmarshallDependencies protocolUnmarshallDependencies;
        private boolean enableFastUnmarshalling = false;

        private Builder() {
        }

        public Builder parser(JsonNodeParser parser) {
            this.parser = parser;
            return this;
        }

        @Deprecated
        public Builder defaultTimestampFormats(Map<MarshallLocation, TimestampFormatTrait.Format> formats) {
            return this;
        }

        public Builder protocolUnmarshallDependencies(ProtocolUnmarshallDependencies protocolUnmarshallDependencies) {
            this.protocolUnmarshallDependencies = protocolUnmarshallDependencies;
            return this;
        }

        public Builder enableFastUnmarshalling(boolean enableFastUnmarshalling) {
            this.enableFastUnmarshalling = enableFastUnmarshalling;
            return this;
        }

        public JsonProtocolUnmarshaller build() {
            return new JsonProtocolUnmarshaller(this);
        }
    }

    private static class SimpleTypeJsonUnmarshaller<T>
    implements JsonUnmarshaller<T> {
        private final StringToValueConverter.StringToValue<T> stringToValue;

        private SimpleTypeJsonUnmarshaller(StringToValueConverter.StringToValue<T> stringToValue) {
            this.stringToValue = stringToValue;
        }

        @Override
        public T unmarshall(JsonUnmarshallerContext context, JsonNode jsonContent, SdkField<T> field) {
            return jsonContent != null && !jsonContent.isNull() ? (T)this.stringToValue.convert(jsonContent.text(), field) : null;
        }
    }
}

