/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api.internal.backoff;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.internal.backoff.BackoffStrategiesConstants;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ExponentialDelayWithoutJitter
implements BackoffStrategy {
    private final Duration baseDelay;
    private final Duration maxDelay;

    public ExponentialDelayWithoutJitter(Duration baseDelay, Duration maxDelay) {
        this.baseDelay = NumericUtils.min(Validate.isPositive(baseDelay, "baseDelay"), BackoffStrategiesConstants.BASE_DELAY_CEILING);
        this.maxDelay = NumericUtils.min(Validate.isPositive(maxDelay, "maxDelay"), BackoffStrategiesConstants.MAX_BACKOFF_CEILING);
    }

    @Override
    public Duration computeDelay(int attempt) {
        Validate.isPositive(attempt, "attempt");
        if (attempt == 1) {
            return Duration.ZERO;
        }
        int delay = BackoffStrategiesConstants.calculateExponentialDelay(attempt, this.baseDelay, this.maxDelay);
        return Duration.ofMillis(delay);
    }

    public String toString() {
        return ToString.builder("ExponentialDelayWithoutJitter").add("baseDelay", this.baseDelay).add("maxDelay", this.maxDelay).build();
    }
}

