/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal.ratelimiter;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ToBuilderIgnoreField;
import software.amazon.awssdk.retries.internal.ratelimiter.RateLimiterClock;
import software.amazon.awssdk.retries.internal.ratelimiter.RateLimiterTokenBucket;
import software.amazon.awssdk.retries.internal.ratelimiter.SystemClock;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.awssdk.utils.cache.lru.LruCache;

@SdkInternalApi
public final class RateLimiterTokenBucketStore
implements ToCopyableBuilder<Builder, RateLimiterTokenBucketStore> {
    private static final int MAX_ENTRIES = 128;
    private static final RateLimiterClock DEFAULT_CLOCK = new SystemClock();
    private final LruCache<String, RateLimiterTokenBucket> scopeToTokenBucket;
    private final RateLimiterClock clock;

    private RateLimiterTokenBucketStore(Builder builder) {
        this.clock = Validate.paramNotNull(builder.clock, "clock");
        this.scopeToTokenBucket = LruCache.builder(x -> new RateLimiterTokenBucket(this.clock)).maxSize(128).build();
    }

    public RateLimiterTokenBucket tokenBucketForScope(String scope) {
        return this.scopeToTokenBucket.get(scope);
    }

    @Override
    @ToBuilderIgnoreField(value={"scopeToTokenBucket"})
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CopyableBuilder<Builder, RateLimiterTokenBucketStore> {
        private RateLimiterClock clock;

        Builder() {
            this.clock = DEFAULT_CLOCK;
        }

        Builder(RateLimiterTokenBucketStore store) {
            this.clock = store.clock;
        }

        public Builder clock(RateLimiterClock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public RateLimiterTokenBucketStore build() {
            return new RateLimiterTokenBucketStore(this);
        }
    }
}

