/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.AthenaServiceClientConfiguration;
import software.amazon.awssdk.services.athena.internal.AthenaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.athena.model.AthenaException;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.CreateNotebookRequest;
import software.amazon.awssdk.services.athena.model.CreateNotebookResponse;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteNotebookRequest;
import software.amazon.awssdk.services.athena.model.DeleteNotebookResponse;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ExportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ExportNotebookResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.GetDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.GetDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.GetDatabaseRequest;
import software.amazon.awssdk.services.athena.model.GetDatabaseResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse;
import software.amazon.awssdk.services.athena.model.GetSessionRequest;
import software.amazon.awssdk.services.athena.model.GetSessionResponse;
import software.amazon.awssdk.services.athena.model.GetSessionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetSessionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.GetWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ImportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ImportNotebookResponse;
import software.amazon.awssdk.services.athena.model.InternalServerException;
import software.amazon.awssdk.services.athena.model.InvalidRequestException;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;
import software.amazon.awssdk.services.athena.model.MetadataException;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.ResourceNotFoundException;
import software.amazon.awssdk.services.athena.model.SessionAlreadyExistsException;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartSessionRequest;
import software.amazon.awssdk.services.athena.model.StartSessionResponse;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TagResourceRequest;
import software.amazon.awssdk.services.athena.model.TagResourceResponse;
import software.amazon.awssdk.services.athena.model.TerminateSessionRequest;
import software.amazon.awssdk.services.athena.model.TerminateSessionResponse;
import software.amazon.awssdk.services.athena.model.TooManyRequestsException;
import software.amazon.awssdk.services.athena.model.UntagResourceRequest;
import software.amazon.awssdk.services.athena.model.UntagResourceResponse;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookResponse;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupResponse;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CancelCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePresignedNotebookUrlRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeletePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ExportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionCodeRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryRuntimeStatisticsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ImportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListApplicationDpuSizesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCalculationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCapacityReservationsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDataCatalogsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListExecutorsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListPreparedStatementsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListWorkGroupsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.PutCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateWorkGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultAthenaAsyncClient
implements AthenaAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAthenaAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAthenaAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "Athena#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchGetNamedQueryResponse> batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGetNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetNamedQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<BatchGetNamedQueryResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetNamedQuery").withProtocolMetadata(protocolMetadata).withMarshaller(new BatchGetNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(batchGetNamedQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<BatchGetPreparedStatementResponse> batchGetPreparedStatement(BatchGetPreparedStatementRequest batchGetPreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGetPreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetPreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetPreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetPreparedStatementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<BatchGetPreparedStatementResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetPreparedStatement").withProtocolMetadata(protocolMetadata).withMarshaller(new BatchGetPreparedStatementRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(batchGetPreparedStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<BatchGetQueryExecutionResponse> batchGetQueryExecution(BatchGetQueryExecutionRequest batchGetQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGetQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetQueryExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<BatchGetQueryExecutionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetQueryExecution").withProtocolMetadata(protocolMetadata).withMarshaller(new BatchGetQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(batchGetQueryExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CancelCapacityReservationResponse> cancelCapacityReservation(CancelCapacityReservationRequest cancelCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(cancelCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, cancelCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelCapacityReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CancelCapacityReservationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelCapacityReservation").withProtocolMetadata(protocolMetadata).withMarshaller(new CancelCapacityReservationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(cancelCapacityReservationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateCapacityReservationResponse> createCapacityReservation(CreateCapacityReservationRequest createCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, createCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCapacityReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateCapacityReservationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCapacityReservation").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateCapacityReservationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createCapacityReservationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateDataCatalogResponse> createDataCatalog(CreateDataCatalogRequest createDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, createDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCatalogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateDataCatalogResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCatalog").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateDataCatalogRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createDataCatalogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateNamedQueryResponse> createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, createNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNamedQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateNamedQueryResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNamedQuery").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createNamedQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateNotebookResponse> createNotebook(CreateNotebookRequest createNotebookRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, createNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNotebookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateNotebookResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNotebook").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateNotebookRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createNotebookRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreatePreparedStatementResponse> createPreparedStatement(CreatePreparedStatementRequest createPreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createPreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, createPreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePreparedStatementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreatePreparedStatementResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePreparedStatement").withProtocolMetadata(protocolMetadata).withMarshaller(new CreatePreparedStatementRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createPreparedStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreatePresignedNotebookUrlResponse> createPresignedNotebookUrl(CreatePresignedNotebookUrlRequest createPresignedNotebookUrlRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createPresignedNotebookUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, createPresignedNotebookUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedNotebookUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePresignedNotebookUrlResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreatePresignedNotebookUrlResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePresignedNotebookUrl").withProtocolMetadata(protocolMetadata).withMarshaller(new CreatePresignedNotebookUrlRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createPresignedNotebookUrlRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateWorkGroupResponse> createWorkGroup(CreateWorkGroupRequest createWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, createWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateWorkGroupResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkGroup").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateWorkGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createWorkGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteCapacityReservationResponse> deleteCapacityReservation(DeleteCapacityReservationRequest deleteCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCapacityReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteCapacityReservationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCapacityReservation").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteCapacityReservationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteCapacityReservationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataCatalogResponse> deleteDataCatalog(DeleteDataCatalogRequest deleteDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCatalogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteDataCatalogResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCatalog").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteDataCatalogRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteDataCatalogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteNamedQueryResponse> deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, deleteNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamedQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteNamedQueryResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamedQuery").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteNamedQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteNotebookResponse> deleteNotebook(DeleteNotebookRequest deleteNotebookRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, deleteNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNotebookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteNotebookResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotebook").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteNotebookRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteNotebookRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeletePreparedStatementResponse> deletePreparedStatement(DeletePreparedStatementRequest deletePreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deletePreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, deletePreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePreparedStatementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeletePreparedStatementResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePreparedStatement").withProtocolMetadata(protocolMetadata).withMarshaller(new DeletePreparedStatementRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deletePreparedStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteWorkGroupResponse> deleteWorkGroup(DeleteWorkGroupRequest deleteWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, deleteWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteWorkGroupResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkGroup").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteWorkGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteWorkGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ExportNotebookResponse> exportNotebook(ExportNotebookRequest exportNotebookRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(exportNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, exportNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportNotebookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ExportNotebookResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportNotebook").withProtocolMetadata(protocolMetadata).withMarshaller(new ExportNotebookRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(exportNotebookRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetCalculationExecutionResponse> getCalculationExecution(GetCalculationExecutionRequest getCalculationExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCalculationExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getCalculationExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetCalculationExecutionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecution").withProtocolMetadata(protocolMetadata).withMarshaller(new GetCalculationExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getCalculationExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetCalculationExecutionCodeResponse> getCalculationExecutionCode(GetCalculationExecutionCodeRequest getCalculationExecutionCodeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCalculationExecutionCodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getCalculationExecutionCodeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionCode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionCodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetCalculationExecutionCodeResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecutionCode").withProtocolMetadata(protocolMetadata).withMarshaller(new GetCalculationExecutionCodeRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getCalculationExecutionCodeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetCalculationExecutionStatusResponse> getCalculationExecutionStatus(GetCalculationExecutionStatusRequest getCalculationExecutionStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCalculationExecutionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getCalculationExecutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetCalculationExecutionStatusResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecutionStatus").withProtocolMetadata(protocolMetadata).withMarshaller(new GetCalculationExecutionStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getCalculationExecutionStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetCapacityAssignmentConfigurationResponse> getCapacityAssignmentConfiguration(GetCapacityAssignmentConfigurationRequest getCapacityAssignmentConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCapacityAssignmentConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityAssignmentConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCapacityAssignmentConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetCapacityAssignmentConfigurationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata).withMarshaller(new GetCapacityAssignmentConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getCapacityAssignmentConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetCapacityReservationResponse> getCapacityReservation(GetCapacityReservationRequest getCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCapacityReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetCapacityReservationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCapacityReservation").withProtocolMetadata(protocolMetadata).withMarshaller(new GetCapacityReservationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getCapacityReservationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetDataCatalogResponse> getDataCatalog(GetDataCatalogRequest getDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCatalogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetDataCatalogResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCatalog").withProtocolMetadata(protocolMetadata).withMarshaller(new GetDataCatalogRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getDataCatalogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetDatabaseResponse> getDatabase(GetDatabaseRequest getDatabaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getDatabaseRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatabaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetDatabaseResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatabase").withProtocolMetadata(protocolMetadata).withMarshaller(new GetDatabaseRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetNamedQueryResponse> getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamedQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetNamedQueryResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamedQuery").withProtocolMetadata(protocolMetadata).withMarshaller(new GetNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getNamedQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetNotebookMetadataResponse> getNotebookMetadata(GetNotebookMetadataRequest getNotebookMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getNotebookMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getNotebookMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNotebookMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNotebookMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetNotebookMetadataResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNotebookMetadata").withProtocolMetadata(protocolMetadata).withMarshaller(new GetNotebookMetadataRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getNotebookMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetPreparedStatementResponse> getPreparedStatement(GetPreparedStatementRequest getPreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getPreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getPreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPreparedStatementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetPreparedStatementResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPreparedStatement").withProtocolMetadata(protocolMetadata).withMarshaller(new GetPreparedStatementRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getPreparedStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetQueryExecutionResponse> getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetQueryExecutionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryExecution").withProtocolMetadata(protocolMetadata).withMarshaller(new GetQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getQueryExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetQueryResultsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withProtocolMetadata(protocolMetadata).withMarshaller(new GetQueryResultsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getQueryResultsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetQueryRuntimeStatisticsResponse> getQueryRuntimeStatistics(GetQueryRuntimeStatisticsRequest getQueryRuntimeStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryRuntimeStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryRuntimeStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryRuntimeStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryRuntimeStatisticsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetQueryRuntimeStatisticsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryRuntimeStatistics").withProtocolMetadata(protocolMetadata).withMarshaller(new GetQueryRuntimeStatisticsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getQueryRuntimeStatisticsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetSessionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSession").withProtocolMetadata(protocolMetadata).withMarshaller(new GetSessionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetSessionStatusResponse> getSessionStatus(GetSessionStatusRequest getSessionStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getSessionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getSessionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetSessionStatusResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSessionStatus").withProtocolMetadata(protocolMetadata).withMarshaller(new GetSessionStatusRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getSessionStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetTableMetadataResponse> getTableMetadata(GetTableMetadataRequest getTableMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTableMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getTableMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetTableMetadataResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableMetadata").withProtocolMetadata(protocolMetadata).withMarshaller(new GetTableMetadataRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getTableMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetWorkGroupResponse> getWorkGroup(GetWorkGroupRequest getWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetWorkGroupResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkGroup").withProtocolMetadata(protocolMetadata).withMarshaller(new GetWorkGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getWorkGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ImportNotebookResponse> importNotebook(ImportNotebookRequest importNotebookRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(importNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, importNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportNotebookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ImportNotebookResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportNotebook").withProtocolMetadata(protocolMetadata).withMarshaller(new ImportNotebookRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(importNotebookRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListApplicationDpuSizesResponse> listApplicationDPUSizes(ListApplicationDpuSizesRequest listApplicationDpuSizesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationDpuSizesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listApplicationDpuSizesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationDPUSizes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationDpuSizesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListApplicationDpuSizesResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationDPUSizes").withProtocolMetadata(protocolMetadata).withMarshaller(new ListApplicationDpuSizesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listApplicationDpuSizesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListCalculationExecutionsResponse> listCalculationExecutions(ListCalculationExecutionsRequest listCalculationExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listCalculationExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listCalculationExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCalculationExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCalculationExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListCalculationExecutionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCalculationExecutions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListCalculationExecutionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listCalculationExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListCapacityReservationsResponse> listCapacityReservations(ListCapacityReservationsRequest listCapacityReservationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listCapacityReservationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listCapacityReservationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCapacityReservations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCapacityReservationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListCapacityReservationsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCapacityReservations").withProtocolMetadata(protocolMetadata).withMarshaller(new ListCapacityReservationsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listCapacityReservationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListDataCatalogsResponse> listDataCatalogs(ListDataCatalogsRequest listDataCatalogsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listDataCatalogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listDataCatalogsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataCatalogs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCatalogsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListDataCatalogsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCatalogs").withProtocolMetadata(protocolMetadata).withMarshaller(new ListDataCatalogsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listDataCatalogsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListDatabasesResponse> listDatabases(ListDatabasesRequest listDatabasesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListDatabasesResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withProtocolMetadata(protocolMetadata).withMarshaller(new ListDatabasesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listDatabasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListEngineVersionsResponse> listEngineVersions(ListEngineVersionsRequest listEngineVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listEngineVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listEngineVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngineVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEngineVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListEngineVersionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEngineVersions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListEngineVersionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listEngineVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListExecutorsResponse> listExecutors(ListExecutorsRequest listExecutorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listExecutorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listExecutorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExecutors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExecutorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListExecutorsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExecutors").withProtocolMetadata(protocolMetadata).withMarshaller(new ListExecutorsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listExecutorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListNamedQueriesResponse> listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listNamedQueriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listNamedQueriesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamedQueries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNamedQueriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListNamedQueriesResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNamedQueries").withProtocolMetadata(protocolMetadata).withMarshaller(new ListNamedQueriesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listNamedQueriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListNotebookMetadataResponse> listNotebookMetadata(ListNotebookMetadataRequest listNotebookMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listNotebookMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listNotebookMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotebookMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListNotebookMetadataResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotebookMetadata").withProtocolMetadata(protocolMetadata).withMarshaller(new ListNotebookMetadataRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listNotebookMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListNotebookSessionsResponse> listNotebookSessions(ListNotebookSessionsRequest listNotebookSessionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listNotebookSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listNotebookSessionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotebookSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListNotebookSessionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotebookSessions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListNotebookSessionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listNotebookSessionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListPreparedStatementsResponse> listPreparedStatements(ListPreparedStatementsRequest listPreparedStatementsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPreparedStatementsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listPreparedStatementsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPreparedStatements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPreparedStatementsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListPreparedStatementsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPreparedStatements").withProtocolMetadata(protocolMetadata).withMarshaller(new ListPreparedStatementsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listPreparedStatementsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListQueryExecutionsResponse> listQueryExecutions(ListQueryExecutionsRequest listQueryExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listQueryExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listQueryExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueryExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueryExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListQueryExecutionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueryExecutions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListQueryExecutionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listQueryExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listSessionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListSessionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSessions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListSessionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listSessionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListTableMetadataResponse> listTableMetadata(ListTableMetadataRequest listTableMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTableMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listTableMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListTableMetadataResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableMetadata").withProtocolMetadata(protocolMetadata).withMarshaller(new ListTableMetadataRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listTableMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListTagsForResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata).withMarshaller(new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListWorkGroupsResponse> listWorkGroups(ListWorkGroupsRequest listWorkGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listWorkGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, listWorkGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListWorkGroupsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkGroups").withProtocolMetadata(protocolMetadata).withMarshaller(new ListWorkGroupsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listWorkGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<PutCapacityAssignmentConfigurationResponse> putCapacityAssignmentConfiguration(PutCapacityAssignmentConfigurationRequest putCapacityAssignmentConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putCapacityAssignmentConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, putCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutCapacityAssignmentConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutCapacityAssignmentConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<PutCapacityAssignmentConfigurationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata).withMarshaller(new PutCapacityAssignmentConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(putCapacityAssignmentConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartCalculationExecutionResponse> startCalculationExecution(StartCalculationExecutionRequest startCalculationExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startCalculationExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, startCalculationExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCalculationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCalculationExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<StartCalculationExecutionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCalculationExecution").withProtocolMetadata(protocolMetadata).withMarshaller(new StartCalculationExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(startCalculationExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartQueryExecutionResponse> startQueryExecution(StartQueryExecutionRequest startQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, startQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<StartQueryExecutionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryExecution").withProtocolMetadata(protocolMetadata).withMarshaller(new StartQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(startQueryExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartSessionResponse> startSession(StartSessionRequest startSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, startSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<StartSessionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSession").withProtocolMetadata(protocolMetadata).withMarshaller(new StartSessionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(startSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StopCalculationExecutionResponse> stopCalculationExecution(StopCalculationExecutionRequest stopCalculationExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(stopCalculationExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, stopCalculationExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopCalculationExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopCalculationExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<StopCalculationExecutionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopCalculationExecution").withProtocolMetadata(protocolMetadata).withMarshaller(new StopCalculationExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(stopCalculationExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StopQueryExecutionResponse> stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(stopQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, stopQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopQueryExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopQueryExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<StopQueryExecutionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopQueryExecution").withProtocolMetadata(protocolMetadata).withMarshaller(new StopQueryExecutionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(stopQueryExecutionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<TagResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withMarshaller(new TagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<TerminateSessionResponse> terminateSession(TerminateSessionRequest terminateSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(terminateSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, terminateSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<TerminateSessionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateSession").withProtocolMetadata(protocolMetadata).withMarshaller(new TerminateSessionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(terminateSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UntagResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata(protocolMetadata).withMarshaller(new UntagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateCapacityReservationResponse> updateCapacityReservation(UpdateCapacityReservationRequest updateCapacityReservationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, updateCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCapacityReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCapacityReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateCapacityReservationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCapacityReservation").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateCapacityReservationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateCapacityReservationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataCatalogResponse> updateDataCatalog(UpdateDataCatalogRequest updateDataCatalogRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, updateDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataCatalog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCatalogResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateDataCatalogResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCatalog").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateDataCatalogRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateDataCatalogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateNamedQueryResponse> updateNamedQuery(UpdateNamedQueryRequest updateNamedQueryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, updateNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNamedQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNamedQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateNamedQueryResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNamedQuery").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateNamedQueryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateNamedQueryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateNotebookResponse> updateNotebook(UpdateNotebookRequest updateNotebookRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, updateNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotebookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateNotebookResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotebook").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateNotebookRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateNotebookRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateNotebookMetadataResponse> updateNotebookMetadata(UpdateNotebookMetadataRequest updateNotebookMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateNotebookMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, updateNotebookMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebookMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotebookMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateNotebookMetadataResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotebookMetadata").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateNotebookMetadataRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateNotebookMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdatePreparedStatementResponse> updatePreparedStatement(UpdatePreparedStatementRequest updatePreparedStatementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updatePreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, updatePreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePreparedStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePreparedStatementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdatePreparedStatementResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePreparedStatement").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdatePreparedStatementRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updatePreparedStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateWorkGroupResponse> updateWorkGroup(UpdateWorkGroupRequest updateWorkGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaAsyncClient.resolveMetricPublishers(clientConfiguration, updateWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                    }
                    case "SessionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateWorkGroupResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkGroup").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateWorkGroupRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateWorkGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final AthenaServiceClientConfiguration serviceClientConfiguration() {
        return new AthenaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return "athena";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(AthenaException::builder)).protocol(AwsJsonProtocol.AWS_JSON)).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AthenaServiceClientConfigurationBuilder serviceConfigBuilder = new AthenaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

