/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.AthenaServiceClientConfiguration;
import software.amazon.awssdk.services.athena.internal.AthenaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.athena.model.AthenaException;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.BatchGetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.CreateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.CreateNotebookRequest;
import software.amazon.awssdk.services.athena.model.CreateNotebookResponse;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.CreatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlRequest;
import software.amazon.awssdk.services.athena.model.CreatePresignedNotebookUrlResponse;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.CreateWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.DeleteCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.DeleteDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.DeleteNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.DeleteNotebookRequest;
import software.amazon.awssdk.services.athena.model.DeleteNotebookResponse;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.DeletePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.DeleteWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ExportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ExportNotebookResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionCodeResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetCalculationExecutionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.GetCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.GetDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.GetDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.GetDatabaseRequest;
import software.amazon.awssdk.services.athena.model.GetDatabaseResponse;
import software.amazon.awssdk.services.athena.model.GetNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.GetNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryRuntimeStatisticsResponse;
import software.amazon.awssdk.services.athena.model.GetSessionRequest;
import software.amazon.awssdk.services.athena.model.GetSessionResponse;
import software.amazon.awssdk.services.athena.model.GetSessionStatusRequest;
import software.amazon.awssdk.services.athena.model.GetSessionStatusResponse;
import software.amazon.awssdk.services.athena.model.GetTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.GetTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.GetWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.GetWorkGroupResponse;
import software.amazon.awssdk.services.athena.model.ImportNotebookRequest;
import software.amazon.awssdk.services.athena.model.ImportNotebookResponse;
import software.amazon.awssdk.services.athena.model.InternalServerException;
import software.amazon.awssdk.services.athena.model.InvalidRequestException;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListCalculationExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsRequest;
import software.amazon.awssdk.services.athena.model.ListCapacityReservationsResponse;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsRequest;
import software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsRequest;
import software.amazon.awssdk.services.athena.model.ListEngineVersionsResponse;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListNotebookSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;
import software.amazon.awssdk.services.athena.model.ListSessionsRequest;
import software.amazon.awssdk.services.athena.model.ListSessionsResponse;
import software.amazon.awssdk.services.athena.model.ListTableMetadataRequest;
import software.amazon.awssdk.services.athena.model.ListTableMetadataResponse;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.athena.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;
import software.amazon.awssdk.services.athena.model.MetadataException;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationRequest;
import software.amazon.awssdk.services.athena.model.PutCapacityAssignmentConfigurationResponse;
import software.amazon.awssdk.services.athena.model.ResourceNotFoundException;
import software.amazon.awssdk.services.athena.model.SessionAlreadyExistsException;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.StartSessionRequest;
import software.amazon.awssdk.services.athena.model.StartSessionResponse;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopCalculationExecutionResponse;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionRequest;
import software.amazon.awssdk.services.athena.model.StopQueryExecutionResponse;
import software.amazon.awssdk.services.athena.model.TagResourceRequest;
import software.amazon.awssdk.services.athena.model.TagResourceResponse;
import software.amazon.awssdk.services.athena.model.TerminateSessionRequest;
import software.amazon.awssdk.services.athena.model.TerminateSessionResponse;
import software.amazon.awssdk.services.athena.model.TooManyRequestsException;
import software.amazon.awssdk.services.athena.model.UntagResourceRequest;
import software.amazon.awssdk.services.athena.model.UntagResourceResponse;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest;
import software.amazon.awssdk.services.athena.model.UpdateCapacityReservationResponse;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogRequest;
import software.amazon.awssdk.services.athena.model.UpdateDataCatalogResponse;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryRequest;
import software.amazon.awssdk.services.athena.model.UpdateNamedQueryResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataResponse;
import software.amazon.awssdk.services.athena.model.UpdateNotebookRequest;
import software.amazon.awssdk.services.athena.model.UpdateNotebookResponse;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementRequest;
import software.amazon.awssdk.services.athena.model.UpdatePreparedStatementResponse;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest;
import software.amazon.awssdk.services.athena.model.UpdateWorkGroupResponse;
import software.amazon.awssdk.services.athena.transform.BatchGetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.BatchGetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CancelCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreatePresignedNotebookUrlRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.CreateWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeletePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.DeleteWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ExportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionCodeRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCalculationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetDatabaseRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetPreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetQueryRuntimeStatisticsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetSessionStatusRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.GetWorkGroupRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ImportNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListApplicationDpuSizesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCalculationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListCapacityReservationsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDataCatalogsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListExecutorsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNamedQueriesRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListNotebookSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListPreparedStatementsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListQueryExecutionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListSessionsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.ListWorkGroupsRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.PutCapacityAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopCalculationExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.StopQueryExecutionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateDataCatalogRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNamedQueryRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookMetadataRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateNotebookRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdatePreparedStatementRequestMarshaller;
import software.amazon.awssdk.services.athena.transform.UpdateWorkGroupRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAthenaClient
implements AthenaClient {
    private static final Logger log = Logger.loggerFor(DefaultAthenaClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAthenaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "Athena#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetNamedQueryResponse batchGetNamedQuery(BatchGetNamedQueryRequest batchGetNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGetNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, batchGetNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetNamedQuery");
            BatchGetNamedQueryResponse batchGetNamedQueryResponse = (BatchGetNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetNamedQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(batchGetNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new BatchGetNamedQueryRequestMarshaller(this.protocolFactory)));
            return batchGetNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetPreparedStatementResponse batchGetPreparedStatement(BatchGetPreparedStatementRequest batchGetPreparedStatementRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetPreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGetPreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, batchGetPreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetPreparedStatement");
            BatchGetPreparedStatementResponse batchGetPreparedStatementResponse = (BatchGetPreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetPreparedStatement").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(batchGetPreparedStatementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new BatchGetPreparedStatementRequestMarshaller(this.protocolFactory)));
            return batchGetPreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetQueryExecutionResponse batchGetQueryExecution(BatchGetQueryExecutionRequest batchGetQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGetQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, batchGetQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetQueryExecution");
            BatchGetQueryExecutionResponse batchGetQueryExecutionResponse = (BatchGetQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetQueryExecution").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(batchGetQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new BatchGetQueryExecutionRequestMarshaller(this.protocolFactory)));
            return batchGetQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelCapacityReservationResponse cancelCapacityReservation(CancelCapacityReservationRequest cancelCapacityReservationRequest) throws InvalidRequestException, InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(cancelCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, cancelCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservation");
            CancelCapacityReservationResponse cancelCapacityReservationResponse = (CancelCapacityReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelCapacityReservation").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(cancelCapacityReservationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CancelCapacityReservationRequestMarshaller(this.protocolFactory)));
            return cancelCapacityReservationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCapacityReservationResponse createCapacityReservation(CreateCapacityReservationRequest createCapacityReservationRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, createCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservation");
            CreateCapacityReservationResponse createCapacityReservationResponse = (CreateCapacityReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCapacityReservation").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createCapacityReservationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateCapacityReservationRequestMarshaller(this.protocolFactory)));
            return createCapacityReservationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataCatalogResponse createDataCatalog(CreateDataCatalogRequest createDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, createDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataCatalog");
            CreateDataCatalogResponse createDataCatalogResponse = (CreateDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCatalog").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateDataCatalogRequestMarshaller(this.protocolFactory)));
            return createDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNamedQueryResponse createNamedQuery(CreateNamedQueryRequest createNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, createNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamedQuery");
            CreateNamedQueryResponse createNamedQueryResponse = (CreateNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNamedQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateNamedQueryRequestMarshaller(this.protocolFactory)));
            return createNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNotebookResponse createNotebook(CreateNotebookRequest createNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, createNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNotebook");
            CreateNotebookResponse createNotebookResponse = (CreateNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNotebook").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createNotebookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateNotebookRequestMarshaller(this.protocolFactory)));
            return createNotebookResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePreparedStatementResponse createPreparedStatement(CreatePreparedStatementRequest createPreparedStatementRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createPreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, createPreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePreparedStatement");
            CreatePreparedStatementResponse createPreparedStatementResponse = (CreatePreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePreparedStatement").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createPreparedStatementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreatePreparedStatementRequestMarshaller(this.protocolFactory)));
            return createPreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePresignedNotebookUrlResponse createPresignedNotebookUrl(CreatePresignedNotebookUrlRequest createPresignedNotebookUrlRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePresignedNotebookUrlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createPresignedNotebookUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, createPresignedNotebookUrlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePresignedNotebookUrl");
            CreatePresignedNotebookUrlResponse createPresignedNotebookUrlResponse = (CreatePresignedNotebookUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePresignedNotebookUrl").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createPresignedNotebookUrlRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreatePresignedNotebookUrlRequestMarshaller(this.protocolFactory)));
            return createPresignedNotebookUrlResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkGroupResponse createWorkGroup(CreateWorkGroupRequest createWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, createWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkGroup");
            CreateWorkGroupResponse createWorkGroupResponse = (CreateWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateWorkGroupRequestMarshaller(this.protocolFactory)));
            return createWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCapacityReservationResponse deleteCapacityReservation(DeleteCapacityReservationRequest deleteCapacityReservationRequest) throws InvalidRequestException, InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, deleteCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCapacityReservation");
            DeleteCapacityReservationResponse deleteCapacityReservationResponse = (DeleteCapacityReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCapacityReservation").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteCapacityReservationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteCapacityReservationRequestMarshaller(this.protocolFactory)));
            return deleteCapacityReservationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataCatalogResponse deleteDataCatalog(DeleteDataCatalogRequest deleteDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, deleteDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataCatalog");
            DeleteDataCatalogResponse deleteDataCatalogResponse = (DeleteDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCatalog").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteDataCatalogRequestMarshaller(this.protocolFactory)));
            return deleteDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNamedQueryResponse deleteNamedQuery(DeleteNamedQueryRequest deleteNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, deleteNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamedQuery");
            DeleteNamedQueryResponse deleteNamedQueryResponse = (DeleteNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamedQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteNamedQueryRequestMarshaller(this.protocolFactory)));
            return deleteNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNotebookResponse deleteNotebook(DeleteNotebookRequest deleteNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, deleteNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNotebook");
            DeleteNotebookResponse deleteNotebookResponse = (DeleteNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotebook").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteNotebookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteNotebookRequestMarshaller(this.protocolFactory)));
            return deleteNotebookResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePreparedStatementResponse deletePreparedStatement(DeletePreparedStatementRequest deletePreparedStatementRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deletePreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, deletePreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePreparedStatement");
            DeletePreparedStatementResponse deletePreparedStatementResponse = (DeletePreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePreparedStatement").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deletePreparedStatementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeletePreparedStatementRequestMarshaller(this.protocolFactory)));
            return deletePreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkGroupResponse deleteWorkGroup(DeleteWorkGroupRequest deleteWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, deleteWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkGroup");
            DeleteWorkGroupResponse deleteWorkGroupResponse = (DeleteWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteWorkGroupRequestMarshaller(this.protocolFactory)));
            return deleteWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportNotebookResponse exportNotebook(ExportNotebookRequest exportNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(exportNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, exportNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportNotebook");
            ExportNotebookResponse exportNotebookResponse = (ExportNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportNotebook").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(exportNotebookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ExportNotebookRequestMarshaller(this.protocolFactory)));
            return exportNotebookResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCalculationExecutionResponse getCalculationExecution(GetCalculationExecutionRequest getCalculationExecutionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCalculationExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getCalculationExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecution");
            GetCalculationExecutionResponse getCalculationExecutionResponse = (GetCalculationExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecution").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getCalculationExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetCalculationExecutionRequestMarshaller(this.protocolFactory)));
            return getCalculationExecutionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCalculationExecutionCodeResponse getCalculationExecutionCode(GetCalculationExecutionCodeRequest getCalculationExecutionCodeRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionCodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCalculationExecutionCodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getCalculationExecutionCodeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionCode");
            GetCalculationExecutionCodeResponse getCalculationExecutionCodeResponse = (GetCalculationExecutionCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecutionCode").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getCalculationExecutionCodeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetCalculationExecutionCodeRequestMarshaller(this.protocolFactory)));
            return getCalculationExecutionCodeResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCalculationExecutionStatusResponse getCalculationExecutionStatus(GetCalculationExecutionStatusRequest getCalculationExecutionStatusRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCalculationExecutionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCalculationExecutionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getCalculationExecutionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalculationExecutionStatus");
            GetCalculationExecutionStatusResponse getCalculationExecutionStatusResponse = (GetCalculationExecutionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCalculationExecutionStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getCalculationExecutionStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetCalculationExecutionStatusRequestMarshaller(this.protocolFactory)));
            return getCalculationExecutionStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCapacityAssignmentConfigurationResponse getCapacityAssignmentConfiguration(GetCapacityAssignmentConfigurationRequest getCapacityAssignmentConfigurationRequest) throws InvalidRequestException, InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCapacityAssignmentConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCapacityAssignmentConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityAssignmentConfiguration");
            GetCapacityAssignmentConfigurationResponse getCapacityAssignmentConfigurationResponse = (GetCapacityAssignmentConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getCapacityAssignmentConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetCapacityAssignmentConfigurationRequestMarshaller(this.protocolFactory)));
            return getCapacityAssignmentConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCapacityReservationResponse getCapacityReservation(GetCapacityReservationRequest getCapacityReservationRequest) throws InvalidRequestException, InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCapacityReservation");
            GetCapacityReservationResponse getCapacityReservationResponse = (GetCapacityReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCapacityReservation").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getCapacityReservationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetCapacityReservationRequestMarshaller(this.protocolFactory)));
            return getCapacityReservationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataCatalogResponse getDataCatalog(GetDataCatalogRequest getDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataCatalog");
            GetDataCatalogResponse getDataCatalogResponse = (GetDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCatalog").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetDataCatalogRequestMarshaller(this.protocolFactory)));
            return getDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDatabaseResponse getDatabase(GetDatabaseRequest getDatabaseRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDatabaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDatabaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getDatabaseRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDatabase");
            GetDatabaseResponse getDatabaseResponse = (GetDatabaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDatabase").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getDatabaseRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetDatabaseRequestMarshaller(this.protocolFactory)));
            return getDatabaseResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamedQueryResponse getNamedQuery(GetNamedQueryRequest getNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNamedQuery");
            GetNamedQueryResponse getNamedQueryResponse = (GetNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamedQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetNamedQueryRequestMarshaller(this.protocolFactory)));
            return getNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNotebookMetadataResponse getNotebookMetadata(GetNotebookMetadataRequest getNotebookMetadataRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNotebookMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getNotebookMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getNotebookMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNotebookMetadata");
            GetNotebookMetadataResponse getNotebookMetadataResponse = (GetNotebookMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNotebookMetadata").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getNotebookMetadataRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetNotebookMetadataRequestMarshaller(this.protocolFactory)));
            return getNotebookMetadataResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPreparedStatementResponse getPreparedStatement(GetPreparedStatementRequest getPreparedStatementRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getPreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getPreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPreparedStatement");
            GetPreparedStatementResponse getPreparedStatementResponse = (GetPreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPreparedStatement").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getPreparedStatementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetPreparedStatementRequestMarshaller(this.protocolFactory)));
            return getPreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryExecutionResponse getQueryExecution(GetQueryExecutionRequest getQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryExecution");
            GetQueryExecutionResponse getQueryExecutionResponse = (GetQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryExecution").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetQueryExecutionRequestMarshaller(this.protocolFactory)));
            return getQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryResults");
            GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getQueryResultsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetQueryResultsRequestMarshaller(this.protocolFactory)));
            return getQueryResultsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryRuntimeStatisticsResponse getQueryRuntimeStatistics(GetQueryRuntimeStatisticsRequest getQueryRuntimeStatisticsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryRuntimeStatisticsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryRuntimeStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getQueryRuntimeStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryRuntimeStatistics");
            GetQueryRuntimeStatisticsResponse getQueryRuntimeStatisticsResponse = (GetQueryRuntimeStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryRuntimeStatistics").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getQueryRuntimeStatisticsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetQueryRuntimeStatisticsRequestMarshaller(this.protocolFactory)));
            return getQueryRuntimeStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSession");
            GetSessionResponse getSessionResponse = (GetSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSession").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetSessionRequestMarshaller(this.protocolFactory)));
            return getSessionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSessionStatusResponse getSessionStatus(GetSessionStatusRequest getSessionStatusRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSessionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getSessionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getSessionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionStatus");
            GetSessionStatusResponse getSessionStatusResponse = (GetSessionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSessionStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getSessionStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetSessionStatusRequestMarshaller(this.protocolFactory)));
            return getSessionStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableMetadataResponse getTableMetadata(GetTableMetadataRequest getTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTableMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getTableMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableMetadata");
            GetTableMetadataResponse getTableMetadataResponse = (GetTableMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableMetadata").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getTableMetadataRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTableMetadataRequestMarshaller(this.protocolFactory)));
            return getTableMetadataResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkGroupResponse getWorkGroup(GetWorkGroupRequest getWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, getWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkGroup");
            GetWorkGroupResponse getWorkGroupResponse = (GetWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetWorkGroupRequestMarshaller(this.protocolFactory)));
            return getWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportNotebookResponse importNotebook(ImportNotebookRequest importNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(importNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, importNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportNotebook");
            ImportNotebookResponse importNotebookResponse = (ImportNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportNotebook").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(importNotebookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ImportNotebookRequestMarshaller(this.protocolFactory)));
            return importNotebookResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationDpuSizesResponse listApplicationDPUSizes(ListApplicationDpuSizesRequest listApplicationDpuSizesRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationDpuSizesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationDpuSizesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listApplicationDpuSizesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationDPUSizes");
            ListApplicationDpuSizesResponse listApplicationDpuSizesResponse = (ListApplicationDpuSizesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationDPUSizes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationDpuSizesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationDpuSizesRequestMarshaller(this.protocolFactory)));
            return listApplicationDpuSizesResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCalculationExecutionsResponse listCalculationExecutions(ListCalculationExecutionsRequest listCalculationExecutionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCalculationExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listCalculationExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listCalculationExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCalculationExecutions");
            ListCalculationExecutionsResponse listCalculationExecutionsResponse = (ListCalculationExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCalculationExecutions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listCalculationExecutionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListCalculationExecutionsRequestMarshaller(this.protocolFactory)));
            return listCalculationExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCapacityReservationsResponse listCapacityReservations(ListCapacityReservationsRequest listCapacityReservationsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCapacityReservationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listCapacityReservationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listCapacityReservationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCapacityReservations");
            ListCapacityReservationsResponse listCapacityReservationsResponse = (ListCapacityReservationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCapacityReservations").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listCapacityReservationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListCapacityReservationsRequestMarshaller(this.protocolFactory)));
            return listCapacityReservationsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataCatalogsResponse listDataCatalogs(ListDataCatalogsRequest listDataCatalogsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCatalogsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listDataCatalogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listDataCatalogsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataCatalogs");
            ListDataCatalogsResponse listDataCatalogsResponse = (ListDataCatalogsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCatalogs").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listDataCatalogsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListDataCatalogsRequestMarshaller(this.protocolFactory)));
            return listDataCatalogsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatabases");
            ListDatabasesResponse listDatabasesResponse = (ListDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listDatabasesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListDatabasesRequestMarshaller(this.protocolFactory)));
            return listDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEngineVersionsResponse listEngineVersions(ListEngineVersionsRequest listEngineVersionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEngineVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listEngineVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listEngineVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngineVersions");
            ListEngineVersionsResponse listEngineVersionsResponse = (ListEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEngineVersions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listEngineVersionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListEngineVersionsRequestMarshaller(this.protocolFactory)));
            return listEngineVersionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExecutorsResponse listExecutors(ListExecutorsRequest listExecutorsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExecutorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listExecutorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listExecutorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExecutors");
            ListExecutorsResponse listExecutorsResponse = (ListExecutorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExecutors").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listExecutorsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListExecutorsRequestMarshaller(this.protocolFactory)));
            return listExecutorsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNamedQueriesResponse listNamedQueries(ListNamedQueriesRequest listNamedQueriesRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNamedQueriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listNamedQueriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listNamedQueriesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamedQueries");
            ListNamedQueriesResponse listNamedQueriesResponse = (ListNamedQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNamedQueries").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listNamedQueriesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListNamedQueriesRequestMarshaller(this.protocolFactory)));
            return listNamedQueriesResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNotebookMetadataResponse listNotebookMetadata(ListNotebookMetadataRequest listNotebookMetadataRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotebookMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listNotebookMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listNotebookMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookMetadata");
            ListNotebookMetadataResponse listNotebookMetadataResponse = (ListNotebookMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotebookMetadata").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listNotebookMetadataRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListNotebookMetadataRequestMarshaller(this.protocolFactory)));
            return listNotebookMetadataResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNotebookSessionsResponse listNotebookSessions(ListNotebookSessionsRequest listNotebookSessionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotebookSessionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listNotebookSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listNotebookSessionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNotebookSessions");
            ListNotebookSessionsResponse listNotebookSessionsResponse = (ListNotebookSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotebookSessions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listNotebookSessionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListNotebookSessionsRequestMarshaller(this.protocolFactory)));
            return listNotebookSessionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPreparedStatementsResponse listPreparedStatements(ListPreparedStatementsRequest listPreparedStatementsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPreparedStatementsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPreparedStatementsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listPreparedStatementsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPreparedStatements");
            ListPreparedStatementsResponse listPreparedStatementsResponse = (ListPreparedStatementsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPreparedStatements").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listPreparedStatementsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListPreparedStatementsRequestMarshaller(this.protocolFactory)));
            return listPreparedStatementsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQueryExecutionsResponse listQueryExecutions(ListQueryExecutionsRequest listQueryExecutionsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQueryExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listQueryExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listQueryExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListQueryExecutions");
            ListQueryExecutionsResponse listQueryExecutionsResponse = (ListQueryExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueryExecutions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listQueryExecutionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListQueryExecutionsRequestMarshaller(this.protocolFactory)));
            return listQueryExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSessionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listSessionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSessions");
            ListSessionsResponse listSessionsResponse = (ListSessionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSessions").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listSessionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListSessionsRequestMarshaller(this.protocolFactory)));
            return listSessionsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableMetadataResponse listTableMetadata(ListTableMetadataRequest listTableMetadataRequest) throws InternalServerException, InvalidRequestException, MetadataException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTableMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listTableMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableMetadata");
            ListTableMetadataResponse listTableMetadataResponse = (ListTableMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableMetadata").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listTableMetadataRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTableMetadataRequestMarshaller(this.protocolFactory)));
            return listTableMetadataResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkGroupsResponse listWorkGroups(ListWorkGroupsRequest listWorkGroupsRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listWorkGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, listWorkGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkGroups");
            ListWorkGroupsResponse listWorkGroupsResponse = (ListWorkGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkGroups").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listWorkGroupsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListWorkGroupsRequestMarshaller(this.protocolFactory)));
            return listWorkGroupsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutCapacityAssignmentConfigurationResponse putCapacityAssignmentConfiguration(PutCapacityAssignmentConfigurationRequest putCapacityAssignmentConfigurationRequest) throws InvalidRequestException, InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutCapacityAssignmentConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putCapacityAssignmentConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, putCapacityAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutCapacityAssignmentConfiguration");
            PutCapacityAssignmentConfigurationResponse putCapacityAssignmentConfigurationResponse = (PutCapacityAssignmentConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutCapacityAssignmentConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putCapacityAssignmentConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutCapacityAssignmentConfigurationRequestMarshaller(this.protocolFactory)));
            return putCapacityAssignmentConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCalculationExecutionResponse startCalculationExecution(StartCalculationExecutionRequest startCalculationExecutionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCalculationExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startCalculationExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, startCalculationExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCalculationExecution");
            StartCalculationExecutionResponse startCalculationExecutionResponse = (StartCalculationExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCalculationExecution").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(startCalculationExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StartCalculationExecutionRequestMarshaller(this.protocolFactory)));
            return startCalculationExecutionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartQueryExecutionResponse startQueryExecution(StartQueryExecutionRequest startQueryExecutionRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, startQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQueryExecution");
            StartQueryExecutionResponse startQueryExecutionResponse = (StartQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryExecution").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(startQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StartQueryExecutionRequestMarshaller(this.protocolFactory)));
            return startQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSessionResponse startSession(StartSessionRequest startSessionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, SessionAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, startSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSession");
            StartSessionResponse startSessionResponse = (StartSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSession").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(startSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StartSessionRequestMarshaller(this.protocolFactory)));
            return startSessionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopCalculationExecutionResponse stopCalculationExecution(StopCalculationExecutionRequest stopCalculationExecutionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopCalculationExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(stopCalculationExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, stopCalculationExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopCalculationExecution");
            StopCalculationExecutionResponse stopCalculationExecutionResponse = (StopCalculationExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopCalculationExecution").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(stopCalculationExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StopCalculationExecutionRequestMarshaller(this.protocolFactory)));
            return stopCalculationExecutionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopQueryExecutionResponse stopQueryExecution(StopQueryExecutionRequest stopQueryExecutionRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopQueryExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(stopQueryExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, stopQueryExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopQueryExecution");
            StopQueryExecutionResponse stopQueryExecutionResponse = (StopQueryExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopQueryExecution").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(stopQueryExecutionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new StopQueryExecutionRequestMarshaller(this.protocolFactory)));
            return stopQueryExecutionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new TagResourceRequestMarshaller(this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateSessionResponse terminateSession(TerminateSessionRequest terminateSessionRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(terminateSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, terminateSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateSession");
            TerminateSessionResponse terminateSessionResponse = (TerminateSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateSession").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(terminateSessionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new TerminateSessionRequestMarshaller(this.protocolFactory)));
            return terminateSessionResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UntagResourceRequestMarshaller(this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCapacityReservationResponse updateCapacityReservation(UpdateCapacityReservationRequest updateCapacityReservationRequest) throws InvalidRequestException, InternalServerException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCapacityReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateCapacityReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, updateCapacityReservationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCapacityReservation");
            UpdateCapacityReservationResponse updateCapacityReservationResponse = (UpdateCapacityReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCapacityReservation").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateCapacityReservationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateCapacityReservationRequestMarshaller(this.protocolFactory)));
            return updateCapacityReservationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataCatalogResponse updateDataCatalog(UpdateDataCatalogRequest updateDataCatalogRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCatalogResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateDataCatalogRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, updateDataCatalogRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataCatalog");
            UpdateDataCatalogResponse updateDataCatalogResponse = (UpdateDataCatalogResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCatalog").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateDataCatalogRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateDataCatalogRequestMarshaller(this.protocolFactory)));
            return updateDataCatalogResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNamedQueryResponse updateNamedQuery(UpdateNamedQueryRequest updateNamedQueryRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNamedQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateNamedQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, updateNamedQueryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNamedQuery");
            UpdateNamedQueryResponse updateNamedQueryResponse = (UpdateNamedQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNamedQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateNamedQueryRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateNamedQueryRequestMarshaller(this.protocolFactory)));
            return updateNamedQueryResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNotebookResponse updateNotebook(UpdateNotebookRequest updateNotebookRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotebookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateNotebookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, updateNotebookRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebook");
            UpdateNotebookResponse updateNotebookResponse = (UpdateNotebookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotebook").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateNotebookRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateNotebookRequestMarshaller(this.protocolFactory)));
            return updateNotebookResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNotebookMetadataResponse updateNotebookMetadata(UpdateNotebookMetadataRequest updateNotebookMetadataRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotebookMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateNotebookMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, updateNotebookMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNotebookMetadata");
            UpdateNotebookMetadataResponse updateNotebookMetadataResponse = (UpdateNotebookMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotebookMetadata").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateNotebookMetadataRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateNotebookMetadataRequestMarshaller(this.protocolFactory)));
            return updateNotebookMetadataResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePreparedStatementResponse updatePreparedStatement(UpdatePreparedStatementRequest updatePreparedStatementRequest) throws InternalServerException, InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePreparedStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updatePreparedStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, updatePreparedStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePreparedStatement");
            UpdatePreparedStatementResponse updatePreparedStatementResponse = (UpdatePreparedStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePreparedStatement").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updatePreparedStatementRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdatePreparedStatementRequestMarshaller(this.protocolFactory)));
            return updatePreparedStatementResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkGroupResponse updateWorkGroup(UpdateWorkGroupRequest updateWorkGroupRequest) throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, AthenaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MetadataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MetadataException").httpStatusCode(400).exceptionBuilderSupplier(MetadataException::builder).build());
                }
                case "SessionAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionAlreadyExistsException").httpStatusCode(400).exceptionBuilderSupplier(SessionAlreadyExistsException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(400).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateWorkGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAthenaClient.resolveMetricPublishers(clientConfiguration, updateWorkGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Athena");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkGroup");
            UpdateWorkGroupResponse updateWorkGroupResponse = (UpdateWorkGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateWorkGroupRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateWorkGroupRequestMarshaller(this.protocolFactory)));
            return updateWorkGroupResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return "athena";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AthenaServiceClientConfigurationBuilder serviceConfigBuilder = new AthenaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(AthenaException::builder)).protocol(AwsJsonProtocol.AWS_JSON)).protocolVersion("1.1");
    }

    @Override
    public final AthenaServiceClientConfiguration serviceClientConfiguration() {
        return new AthenaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

