/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesRequest;
import software.amazon.awssdk.services.athena.model.ListApplicationDpuSizesResponse;

public class ListApplicationDPUSizesPublisher
implements SdkPublisher<ListApplicationDpuSizesResponse> {
    private final AthenaAsyncClient client;
    private final ListApplicationDpuSizesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationDPUSizesPublisher(AthenaAsyncClient client, ListApplicationDpuSizesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationDPUSizesPublisher(AthenaAsyncClient client, ListApplicationDpuSizesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationDpuSizesResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListApplicationDpuSizesResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListApplicationDpuSizesResponseFetcher
    implements AsyncPageFetcher<ListApplicationDpuSizesResponse> {
        private ListApplicationDpuSizesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationDpuSizesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListApplicationDpuSizesResponse> nextPage(ListApplicationDpuSizesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationDPUSizesPublisher.this.client.listApplicationDPUSizes(ListApplicationDPUSizesPublisher.this.firstRequest);
            }
            return ListApplicationDPUSizesPublisher.this.client.listApplicationDPUSizes((ListApplicationDpuSizesRequest)ListApplicationDPUSizesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

